/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.telnet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.TelnetNotificationHandler;
import org.apache.commons.net.telnet.TelnetOption;
import org.apache.commons.net.telnet.TelnetOptionHandler;

class Telnet
extends SocketClient {
    static final boolean debug = false;
    static final boolean debugoptions = false;
    static final byte[] COMMAND_DO = new byte[]{-1, -3};
    static final byte[] COMMAND_DONT = new byte[]{-1, -2};
    static final byte[] COMMAND_WILL = new byte[]{-1, -5};
    static final byte[] COMMAND_WONT = new byte[]{-1, -4};
    static final byte[] COMMAND_SB = new byte[]{-1, -6};
    static final byte[] COMMAND_SE = new byte[]{-1, -16};
    static final int WILL_MASK = 1;
    static final int DO_MASK = 2;
    static final int REQUESTED_WILL_MASK = 4;
    static final int REQUESTED_DO_MASK = 8;
    static final int DEFAULT_PORT = 23;
    private final int[] doResponse;
    private final int[] willResponse;
    private final int[] options;
    protected static final int TERMINAL_TYPE = 24;
    protected static final int TERMINAL_TYPE_SEND = 1;
    protected static final int TERMINAL_TYPE_IS = 0;
    static final byte[] COMMAND_IS = new byte[]{24, 0};
    private String terminalType;
    private final TelnetOptionHandler[] optionHandlers;
    static final byte[] COMMAND_AYT = new byte[]{-1, -10};
    private final Object aytMonitor = new Object();
    private volatile boolean aytFlag = true;
    private volatile OutputStream spyStream;
    private TelnetNotificationHandler notifhand;

    Telnet() {
        this.setDefaultPort(23);
        this.doResponse = new int[256];
        this.willResponse = new int[256];
        this.options = new int[256];
        this.optionHandlers = new TelnetOptionHandler[256];
    }

    Telnet(String termtype) {
        this.setDefaultPort(23);
        this.doResponse = new int[256];
        this.willResponse = new int[256];
        this.options = new int[256];
        this.terminalType = termtype;
        this.optionHandlers = new TelnetOptionHandler[256];
    }

    boolean stateIsWill(int option) {
        return (this.options[option] & 1) != 0;
    }

    boolean stateIsWont(int option) {
        return !this.stateIsWill(option);
    }

    boolean stateIsDo(int option) {
        return (this.options[option] & 2) != 0;
    }

    boolean stateIsDont(int option) {
        return !this.stateIsDo(option);
    }

    boolean requestedWill(int option) {
        return (this.options[option] & 4) != 0;
    }

    boolean requestedWont(int option) {
        return !this.requestedWill(option);
    }

    boolean requestedDo(int option) {
        return (this.options[option] & 8) != 0;
    }

    boolean requestedDont(int option) {
        return !this.requestedDo(option);
    }

    void setWill(int option) throws IOException {
        int n = option;
        this.options[n] = this.options[n] | 1;
        if (this.requestedWill(option) && this.optionHandlers[option] != null) {
            this.optionHandlers[option].setWill(true);
            int[] subneg = this.optionHandlers[option].startSubnegotiationLocal();
            if (subneg != null) {
                this._sendSubnegotiation(subneg);
            }
        }
    }

    void setDo(int option) throws IOException {
        int n = option;
        this.options[n] = this.options[n] | 2;
        if (this.requestedDo(option) && this.optionHandlers[option] != null) {
            this.optionHandlers[option].setDo(true);
            int[] subneg = this.optionHandlers[option].startSubnegotiationRemote();
            if (subneg != null) {
                this._sendSubnegotiation(subneg);
            }
        }
    }

    void setWantWill(int option) {
        int n = option;
        this.options[n] = this.options[n] | 4;
    }

    void setWantDo(int option) {
        int n = option;
        this.options[n] = this.options[n] | 8;
    }

    void setWont(int option) {
        int n = option;
        this.options[n] = this.options[n] & 0xFFFFFFFE;
        if (this.optionHandlers[option] != null) {
            this.optionHandlers[option].setWill(false);
        }
    }

    void setDont(int option) {
        int n = option;
        this.options[n] = this.options[n] & 0xFFFFFFFD;
        if (this.optionHandlers[option] != null) {
            this.optionHandlers[option].setDo(false);
        }
    }

    void setWantWont(int option) {
        int n = option;
        this.options[n] = this.options[n] & 0xFFFFFFFB;
    }

    void setWantDont(int option) {
        int n = option;
        this.options[n] = this.options[n] & 0xFFFFFFF7;
    }

    void processCommand(int command) {
        if (this.notifhand != null) {
            this.notifhand.receivedNegotiation(5, command);
        }
    }

    void processDo(int option) throws IOException {
        if (this.notifhand != null) {
            this.notifhand.receivedNegotiation(1, option);
        }
        boolean acceptNewState = false;
        if (this.optionHandlers[option] != null) {
            acceptNewState = this.optionHandlers[option].getAcceptLocal();
        } else if (option == 24 && this.terminalType != null && !this.terminalType.isEmpty()) {
            acceptNewState = true;
        }
        if (this.willResponse[option] > 0) {
            int n = option;
            this.willResponse[n] = this.willResponse[n] - 1;
            if (this.willResponse[option] > 0 && this.stateIsWill(option)) {
                int n2 = option;
                this.willResponse[n2] = this.willResponse[n2] - 1;
            }
        }
        if (this.willResponse[option] == 0) {
            if (this.requestedWont(option)) {
                switch (option) {
                    default: 
                }
                if (acceptNewState) {
                    this.setWantWill(option);
                    this.sendWill(option);
                } else {
                    int n = option;
                    this.willResponse[n] = this.willResponse[n] + 1;
                    this.sendWont(option);
                }
            } else {
                switch (option) {
                    default: 
                }
            }
        }
        this.setWill(option);
    }

    void processDont(int option) throws IOException {
        if (this.notifhand != null) {
            this.notifhand.receivedNegotiation(2, option);
        }
        if (this.willResponse[option] > 0) {
            int n = option;
            this.willResponse[n] = this.willResponse[n] - 1;
            if (this.willResponse[option] > 0 && this.stateIsWont(option)) {
                int n2 = option;
                this.willResponse[n2] = this.willResponse[n2] - 1;
            }
        }
        if (this.willResponse[option] == 0 && this.requestedWill(option)) {
            switch (option) {
                default: 
            }
            if (this.stateIsWill(option) || this.requestedWill(option)) {
                this.sendWont(option);
            }
            this.setWantWont(option);
        }
        this.setWont(option);
    }

    void processWill(int option) throws IOException {
        if (this.notifhand != null) {
            this.notifhand.receivedNegotiation(3, option);
        }
        boolean acceptNewState = false;
        if (this.optionHandlers[option] != null) {
            acceptNewState = this.optionHandlers[option].getAcceptRemote();
        }
        if (this.doResponse[option] > 0) {
            int n = option;
            this.doResponse[n] = this.doResponse[n] - 1;
            if (this.doResponse[option] > 0 && this.stateIsDo(option)) {
                int n2 = option;
                this.doResponse[n2] = this.doResponse[n2] - 1;
            }
        }
        if (this.doResponse[option] == 0 && this.requestedDont(option)) {
            switch (option) {
                default: 
            }
            if (acceptNewState) {
                this.setWantDo(option);
                this.sendDo(option);
            } else {
                int n = option;
                this.doResponse[n] = this.doResponse[n] + 1;
                this.sendDont(option);
            }
        }
        this.setDo(option);
    }

    void processWont(int option) throws IOException {
        if (this.notifhand != null) {
            this.notifhand.receivedNegotiation(4, option);
        }
        if (this.doResponse[option] > 0) {
            int n = option;
            this.doResponse[n] = this.doResponse[n] - 1;
            if (this.doResponse[option] > 0 && this.stateIsDont(option)) {
                int n2 = option;
                this.doResponse[n2] = this.doResponse[n2] - 1;
            }
        }
        if (this.doResponse[option] == 0 && this.requestedDo(option)) {
            switch (option) {
                default: 
            }
            if (this.stateIsDo(option) || this.requestedDo(option)) {
                this.sendDont(option);
            }
            this.setWantDont(option);
        }
        this.setDont(option);
    }

    void processSuboption(int[] suboption, int suboptionLength) throws IOException {
        if (suboptionLength > 0) {
            if (this.optionHandlers[suboption[0]] != null) {
                int[] responseSuboption = this.optionHandlers[suboption[0]].answerSubnegotiation(suboption, suboptionLength);
                this._sendSubnegotiation(responseSuboption);
            } else if (suboptionLength > 1 && suboption[0] == 24 && suboption[1] == 1) {
                this.sendTerminalType();
            }
        }
    }

    final synchronized void sendTerminalType() throws IOException {
        if (this.terminalType != null) {
            this._output_.write(COMMAND_SB);
            this._output_.write(COMMAND_IS);
            this._output_.write(this.terminalType.getBytes(this.getCharset()));
            this._output_.write(COMMAND_SE);
            this._output_.flush();
        }
    }

    final synchronized void _sendSubnegotiation(int[] subn) throws IOException {
        if (subn != null) {
            this._output_.write(COMMAND_SB);
            for (int element : subn) {
                byte b = (byte)element;
                if (b == -1) {
                    this._output_.write(b);
                }
                this._output_.write(b);
            }
            this._output_.write(COMMAND_SE);
            this._output_.flush();
        }
    }

    final synchronized void _sendCommand(byte cmd) throws IOException {
        this._output_.write(255);
        this._output_.write(cmd);
        this._output_.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void processAYTResponse() {
        if (!this.aytFlag) {
            Object object = this.aytMonitor;
            synchronized (object) {
                this.aytFlag = true;
                this.aytMonitor.notifyAll();
            }
        }
    }

    @Override
    protected void _connectAction_() throws IOException {
        int ii;
        for (ii = 0; ii < 256; ++ii) {
            this.doResponse[ii] = 0;
            this.willResponse[ii] = 0;
            this.options[ii] = 0;
            if (this.optionHandlers[ii] == null) continue;
            this.optionHandlers[ii].setDo(false);
            this.optionHandlers[ii].setWill(false);
        }
        super._connectAction_();
        this._input_ = new BufferedInputStream(this._input_);
        this._output_ = new BufferedOutputStream(this._output_);
        for (ii = 0; ii < 256; ++ii) {
            if (this.optionHandlers[ii] == null) continue;
            if (this.optionHandlers[ii].getInitLocal()) {
                this.requestWill(this.optionHandlers[ii].getOptionCode());
            }
            if (!this.optionHandlers[ii].getInitRemote()) continue;
            this.requestDo(this.optionHandlers[ii].getOptionCode());
        }
    }

    final synchronized void sendDo(int option) throws IOException {
        this._output_.write(COMMAND_DO);
        this._output_.write(option);
        this._output_.flush();
    }

    final synchronized void requestDo(int option) throws IOException {
        if (this.doResponse[option] == 0 && this.stateIsDo(option) || this.requestedDo(option)) {
            return;
        }
        this.setWantDo(option);
        int n = option;
        this.doResponse[n] = this.doResponse[n] + 1;
        this.sendDo(option);
    }

    final synchronized void sendDont(int option) throws IOException {
        this._output_.write(COMMAND_DONT);
        this._output_.write(option);
        this._output_.flush();
    }

    final synchronized void requestDont(int option) throws IOException {
        if (this.doResponse[option] == 0 && this.stateIsDont(option) || this.requestedDont(option)) {
            return;
        }
        this.setWantDont(option);
        int n = option;
        this.doResponse[n] = this.doResponse[n] + 1;
        this.sendDont(option);
    }

    final synchronized void sendWill(int option) throws IOException {
        this._output_.write(COMMAND_WILL);
        this._output_.write(option);
        this._output_.flush();
    }

    final synchronized void requestWill(int option) throws IOException {
        if (this.willResponse[option] == 0 && this.stateIsWill(option) || this.requestedWill(option)) {
            return;
        }
        this.setWantWill(option);
        int n = option;
        this.doResponse[n] = this.doResponse[n] + 1;
        this.sendWill(option);
    }

    final synchronized void sendWont(int option) throws IOException {
        this._output_.write(COMMAND_WONT);
        this._output_.write(option);
        this._output_.flush();
    }

    final synchronized void requestWont(int option) throws IOException {
        if (this.willResponse[option] == 0 && this.stateIsWont(option) || this.requestedWont(option)) {
            return;
        }
        this.setWantWont(option);
        int n = option;
        this.doResponse[n] = this.doResponse[n] + 1;
        this.sendWont(option);
    }

    final synchronized void sendByte(int b) throws IOException {
        this._output_.write(b);
        this.spyWrite(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean _sendAYT(long timeout) throws IOException, IllegalArgumentException, InterruptedException {
        boolean retValue = false;
        Object object = this.aytMonitor;
        synchronized (object) {
            Telnet telnet = this;
            synchronized (telnet) {
                this.aytFlag = false;
                this._output_.write(COMMAND_AYT);
                this._output_.flush();
            }
            this.aytMonitor.wait(timeout);
            if (!this.aytFlag) {
                retValue = false;
                this.aytFlag = true;
            } else {
                retValue = true;
            }
        }
        return retValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addOptionHandler(TelnetOptionHandler opthand) throws InvalidTelnetOptionException, IOException {
        int optcode = opthand.getOptionCode();
        if (!TelnetOption.isValidOption(optcode)) throw new InvalidTelnetOptionException("Invalid Option Code", optcode);
        if (this.optionHandlers[optcode] != null) throw new InvalidTelnetOptionException("Already registered option", optcode);
        this.optionHandlers[optcode] = opthand;
        if (!this.isConnected()) return;
        if (opthand.getInitLocal()) {
            this.requestWill(optcode);
        }
        if (!opthand.getInitRemote()) return;
        this.requestDo(optcode);
    }

    void deleteOptionHandler(int optcode) throws InvalidTelnetOptionException, IOException {
        if (TelnetOption.isValidOption(optcode)) {
            if (this.optionHandlers[optcode] == null) {
                throw new InvalidTelnetOptionException("Unregistered option", optcode);
            }
            TelnetOptionHandler opthand = this.optionHandlers[optcode];
            this.optionHandlers[optcode] = null;
            if (opthand.getWill()) {
                this.requestWont(optcode);
            }
            if (opthand.getDo()) {
                this.requestDont(optcode);
            }
        } else {
            throw new InvalidTelnetOptionException("Invalid Option Code", optcode);
        }
    }

    void _registerSpyStream(OutputStream spystream) {
        this.spyStream = spystream;
    }

    void _stopSpyStream() {
        this.spyStream = null;
    }

    void spyRead(int ch) {
        OutputStream spy = this.spyStream;
        if (spy != null) {
            try {
                if (ch != 13) {
                    if (ch == 10) {
                        spy.write(13);
                    }
                    spy.write(ch);
                    spy.flush();
                }
            }
            catch (IOException e) {
                this.spyStream = null;
            }
        }
    }

    void spyWrite(int ch) {
        OutputStream spy;
        if (!(this.stateIsDo(1) && this.requestedDo(1) || (spy = this.spyStream) == null)) {
            try {
                spy.write(ch);
                spy.flush();
            }
            catch (IOException e) {
                this.spyStream = null;
            }
        }
    }

    public void registerNotifHandler(TelnetNotificationHandler notifhand) {
        this.notifhand = notifhand;
    }

    public void unregisterNotifHandler() {
        this.notifhand = null;
    }
}

