/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import jakarta.ws.rs.core.MultivaluedMap;
import java.net.URI;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;

@MappedSuperclass
public class AuthorizationCodeGrant
implements AccessTokenGrant {
    private static final long serialVersionUID = -3738825769770411453L;
    private String code;
    private String redirectUri;
    private String codeVerifier;

    public AuthorizationCodeGrant() {
    }

    public AuthorizationCodeGrant(String code) {
        this.code = code;
    }

    public AuthorizationCodeGrant(String code, URI uri) {
        this.code = code;
        this.redirectUri = uri.toString();
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Id
    public String getCode() {
        return this.code;
    }

    public void setCode(String c) {
        this.code = c;
    }

    @Override
    @Transient
    public String getType() {
        return "authorization_code";
    }

    @Override
    public MultivaluedMap<String, String> toMap() {
        MetadataMap<String, String> map = new MetadataMap<String, String>();
        map.putSingle("grant_type", "authorization_code");
        map.putSingle("code", this.getCode());
        if (this.getRedirectUri() != null) {
            map.putSingle("redirect_uri", this.getRedirectUri());
        }
        if (this.getCodeVerifier() != null) {
            map.putSingle("code_verifier", this.getCodeVerifier());
        }
        return map;
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public void setCodeVerifier(String codeVerifier) {
        this.codeVerifier = codeVerifier;
    }
}

