/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJweJsonDecryptingFilter;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;

@Priority(value=1002)
public class JweJsonClientResponseFilter
extends AbstractJweJsonDecryptingFilter
implements ClientResponseFilter {
    public void filter(ClientRequestContext req, ClientResponseContext res) throws IOException {
        if (this.isMethodWithNoContent(req.getMethod()) || this.isStatusCodeWithNoContent(res.getStatus()) || this.isCheckEmptyStream() && !res.hasEntity()) {
            return;
        }
        byte[] encryptedContent = IOUtils.readBytesFromStream(res.getEntityStream());
        if (encryptedContent.length == 0) {
            return;
        }
        JweDecryptionOutput out = this.decrypt(encryptedContent);
        byte[] bytes = out.getContent();
        res.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
        res.getHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString(bytes.length));
        String ct = JoseUtils.checkContentType(out.getHeaders().getContentType(), this.getDefaultMediaType());
        if (ct != null) {
            res.getHeaders().putSingle((Object)"Content-Type", (Object)ct);
        }
        if (super.isValidateHttpHeaders()) {
            super.validateHttpHeadersIfNeeded((MultivaluedMap<String, String>)res.getHeaders(), out.getHeaders());
        }
    }

    protected boolean isMethodWithNoContent(String method) {
        return "DELETE".equals(method) || HttpUtils.isMethodWithNoResponseContent(method);
    }

    protected boolean isStatusCodeWithNoContent(int statusCode) {
        return statusCode == Response.Status.NO_CONTENT.getStatusCode();
    }
}

