/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.config;

import java.security.Key;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.lang.JoseException;

public class JWTAuthConfiguration {
    private static final Logger logger = Logger.getLogger(JWTAuthConfiguration.class.getName());
    public static final String DEFAULT_KEY = "DEFAULT";
    private Map<String, Key> publicKeys;
    private String issuer;
    private int expGracePeriodSecs = 60;
    private String headerName = "Authorization";
    private String headerScheme = "Bearer";
    private boolean allowNoExpiryClaim = false;

    private JWTAuthConfiguration(Key publicKey, String issuer, boolean allowNoExpiryClaim) {
        this.publicKeys = Collections.singletonMap(DEFAULT_KEY, publicKey);
        this.issuer = issuer;
        this.allowNoExpiryClaim = allowNoExpiryClaim;
    }

    private JWTAuthConfiguration(Map<String, Key> publicKeys, String issuer, boolean allowNoExpiryClaim) {
        if (publicKeys.size() == 1) {
            Key singleKey = publicKeys.values().iterator().next();
            this.publicKeys = Collections.singletonMap(DEFAULT_KEY, singleKey);
        } else {
            this.publicKeys = Collections.unmodifiableMap(publicKeys);
        }
        this.issuer = issuer;
        this.allowNoExpiryClaim = allowNoExpiryClaim;
    }

    public static JWTAuthConfiguration authConfiguration(Key publicKey, String issuer, boolean allowNoExpiryClaim) {
        return new JWTAuthConfiguration(publicKey, issuer, allowNoExpiryClaim);
    }

    public static JWTAuthConfiguration authConfiguration(Map<String, Key> publicKeys, String issuer, boolean allowNoExpiryClaim) {
        return new JWTAuthConfiguration(publicKeys, issuer, allowNoExpiryClaim);
    }

    public boolean isSingleKey() {
        return this.publicKeys.size() == 1;
    }

    public Key getPublicKey() {
        return this.publicKeys.get(DEFAULT_KEY);
    }

    public List<JsonWebKey> getPublicKeys() {
        return this.publicKeys.entrySet().stream().map(key -> {
            try {
                JsonWebKey jsonWebKey = JsonWebKey.Factory.newJwk((Key)((Key)key.getValue()));
                jsonWebKey.setKeyId((String)key.getKey());
                return jsonWebKey;
            }
            catch (JoseException e) {
                logger.warning(e.getMessage());
                return null;
            }
        }).collect(Collectors.toList());
    }

    public String getIssuer() {
        return this.issuer;
    }

    public int getExpGracePeriodSecs() {
        return this.expGracePeriodSecs;
    }

    public void setExpGracePeriodSecs(int expGracePeriodSecs) {
        this.expGracePeriodSecs = expGracePeriodSecs;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getHeaderScheme() {
        return this.headerScheme;
    }

    public void setHeaderScheme(String headerScheme) {
        this.headerScheme = headerScheme;
    }

    public boolean isAllowNoExpiryClaim() {
        return this.allowNoExpiryClaim;
    }

    public void setAllowNoExpiryClaim(boolean allowNoExpiryClaim) {
        this.allowNoExpiryClaim = allowNoExpiryClaim;
    }
}

