/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.webapp;

import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UpdateModelException;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExceptionHandlerFactory;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.faces.event.SystemEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreJsf2ExceptionHandlerFactory
extends ExceptionHandlerFactory {
    @Override
    public ExceptionHandler getExceptionHandler() {
        return new PreJsf2ExceptionHandlerImpl();
    }

    private static class PreJsf2ExceptionHandlerImpl
    extends ExceptionHandler {
        private static final Logger log = Logger.getLogger(PreJsf2ExceptionHandlerImpl.class.getName());
        private Queue<ExceptionQueuedEvent> handled;
        private Queue<ExceptionQueuedEvent> unhandled;
        private ExceptionQueuedEvent handledAndThrown;

        @Override
        public ExceptionQueuedEvent getHandledExceptionQueuedEvent() {
            return this.handledAndThrown;
        }

        @Override
        public Iterable<ExceptionQueuedEvent> getHandledExceptionQueuedEvents() {
            return this.handled == null ? Collections.emptyList() : this.handled;
        }

        @Override
        public Throwable getRootCause(Throwable t) {
            if (t == null) {
                throw new NullPointerException("t");
            }
            while (t != null) {
                Class<?> clazz = t.getClass();
                if (!clazz.equals(FacesException.class) && !clazz.equals(ELException.class)) {
                    return t;
                }
                t = t.getCause();
            }
            return null;
        }

        @Override
        public Iterable<ExceptionQueuedEvent> getUnhandledExceptionQueuedEvents() {
            return this.unhandled == null ? Collections.emptyList() : this.unhandled;
        }

        @Override
        public void handle() throws FacesException {
            if (this.unhandled != null && !this.unhandled.isEmpty()) {
                if (this.handled == null) {
                    this.handled = new LinkedList<ExceptionQueuedEvent>();
                }
                FacesException toThrow = null;
                do {
                    ExceptionQueuedEvent event = this.unhandled.peek();
                    try {
                        ExceptionQueuedEventContext context = event.getContext();
                        Throwable exception = context.getException();
                        if (exception instanceof UpdateModelException) {
                            FacesMessage message = ((UpdateModelException)exception).getFacesMessage();
                            log.log(Level.SEVERE, message.getSummary(), exception.getCause());
                            UIComponent component = context.getComponent();
                            String clientId = null;
                            if (component != null) {
                                clientId = component.getClientId(context.getContext());
                            }
                            context.getContext().addMessage(clientId, message);
                            continue;
                        }
                        if (!(this.shouldSkip(exception) || context.inBeforePhase() || context.inAfterPhase())) {
                            this.handledAndThrown = event;
                            toThrow = this.wrap(this.getRethrownException(exception));
                            break;
                        }
                        log.log(Level.SEVERE, exception.getClass().getName() + " occured while processing " + (context.inBeforePhase() ? "beforePhase() of " : (context.inAfterPhase() ? "afterPhase() of " : "")) + "phase " + context.getPhaseId() + ": UIComponent-ClientId=" + (context.getComponent() != null ? context.getComponent().getClientId(context.getContext()) : "") + ", Message=" + exception.getMessage());
                        log.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                    catch (Throwable t) {
                        throw new FacesException("Could not perform the algorithm to handle the Exception", t);
                    }
                    finally {
                        this.handled.add(event);
                        this.unhandled.remove(event);
                    }
                } while (!this.unhandled.isEmpty());
                if (toThrow != null) {
                    throw toThrow;
                }
            }
        }

        @Override
        public boolean isListenerForSource(Object source) {
            return source instanceof ExceptionQueuedEventContext;
        }

        @Override
        public void processEvent(SystemEvent exceptionQueuedEvent) throws AbortProcessingException {
            if (this.unhandled == null) {
                this.unhandled = new LinkedList<ExceptionQueuedEvent>();
            }
            this.unhandled.add((ExceptionQueuedEvent)exceptionQueuedEvent);
        }

        protected Throwable getRethrownException(Throwable exception) {
            Throwable toRethrow = this.getRootCause(exception);
            if (toRethrow == null) {
                toRethrow = exception;
            }
            return toRethrow;
        }

        protected FacesException wrap(Throwable exception) {
            if (exception instanceof FacesException) {
                return (FacesException)exception;
            }
            return new FacesException(exception);
        }

        protected boolean shouldSkip(Throwable exception) {
            return exception instanceof AbortProcessingException;
        }
    }
}

