/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.jsl;

import jakarta.batch.operations.BatchRuntimeException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.batchee.container.jsl.JSLValidationEventHandler;
import org.apache.batchee.container.jsl.Xsds;
import org.apache.batchee.jaxb.JSLJob;

public class JobModelResolver {
    private static final JAXBContext JOB_CONTEXT;

    private JSLJob unmarshalJobXML(String jobXML) {
        JSLJob result;
        JSLValidationEventHandler handler = new JSLValidationEventHandler();
        try {
            Unmarshaller u = JOB_CONTEXT.createUnmarshaller();
            u.setSchema(Xsds.jobXML());
            u.setEventHandler((ValidationEventHandler)handler);
            result = (JSLJob)u.unmarshal((Source)new StreamSource(new StringReader(jobXML)), JSLJob.class).getValue();
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Exception unmarshalling jobXML", e);
        }
        if (handler.eventOccurred()) {
            throw new IllegalArgumentException("xJCL invalid per schema");
        }
        return result;
    }

    public JSLJob resolveModel(final String jobXML) {
        if (System.getSecurityManager() == null) {
            return this.unmarshalJobXML(jobXML);
        }
        return AccessController.doPrivileged(new PrivilegedAction<JSLJob>(){

            @Override
            public JSLJob run() {
                return JobModelResolver.this.unmarshalJobXML(jobXML);
            }
        });
    }

    static {
        try {
            JOB_CONTEXT = JAXBContext.newInstance((String)JSLJob.class.getPackage().getName());
        }
        catch (JAXBException e) {
            throw new BatchRuntimeException((Throwable)e);
        }
    }
}

