/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.config;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.servlet.ServletContext;
import java.security.Key;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.tomee.microprofile.jwt.config.JWTAuthConfiguration;
import org.apache.tomee.microprofile.jwt.config.PublicKeyResolver;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@ApplicationScoped
public class JWTAuthConfigurationProperties {
    public static final List<String> JWK_SUPPORTED_KEY_TYPES = Collections.singletonList("RSA");
    public static final String PUBLIC_KEY_ERROR = "Could not read MicroProfile Public Key";
    public static final String PUBLIC_KEY_ERROR_LOCATION = "Could not read MicroProfile Public Key from Location: ";
    private Config config;
    private JWTAuthConfiguration jwtAuthConfiguration;

    public void init(@Observes @Initialized(value=ApplicationScoped.class) ServletContext context) {
        this.config = ConfigProvider.getConfig();
        this.jwtAuthConfiguration = this.createJWTAuthConfiguration();
    }

    public Optional<JWTAuthConfiguration> getJWTAuthConfiguration() {
        return Optional.ofNullable(this.jwtAuthConfiguration);
    }

    private Optional<String> getVerifierPublicKey() {
        return this.config.getOptionalValue("mp.jwt.verify.publickey", String.class).map(s -> s.isEmpty() ? null : s);
    }

    private Optional<String> getPublicKeyLocation() {
        return this.config.getOptionalValue("mp.jwt.verify.publickey.location", String.class).map(s -> s.isEmpty() ? null : s);
    }

    private Optional<String> getIssuer() {
        return this.config.getOptionalValue("mp.jwt.verify.issuer", String.class);
    }

    private JWTAuthConfiguration createJWTAuthConfiguration() {
        if (this.getVerifierPublicKey().isPresent() && this.getPublicKeyLocation().isPresent()) {
            throw new DeploymentException("Both mp.jwt.verify.publickey and mp.jwt.verify.publickey.location are being supplied. You must use only one.");
        }
        Optional<String> publicKeyContents = this.getVerifierPublicKey();
        Optional<String> publicKeyLocation = this.getPublicKeyLocation();
        Optional<Map<String, Key>> first = new PublicKeyResolver().resolve(publicKeyContents, publicKeyLocation);
        Boolean allowNoExp = this.config.getOptionalValue("mp.jwt.tomee.allow.no-exp", Boolean.class).orElse(false);
        return first.map(keys -> JWTAuthConfiguration.authConfiguration(keys, (String)this.getIssuer().orElse(null), (boolean)allowNoExp)).orElse(null);
    }
}

