/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.security.auth.message.AuthException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.authentication.mechanism.http.LoginToContinue;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import org.apache.tomee.security.http.LoginToContinueMechanism;
import org.apache.tomee.security.http.SavedAuthentication;
import org.apache.tomee.security.http.SavedHttpServletRequest;
import org.apache.tomee.security.http.SavedRequest;

@LoginToContinue
@Interceptor
@Priority(value=220)
public class LoginToContinueInterceptor {
    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        if (invocationContext.getMethod().getName().equals("validateRequest") && Arrays.equals(invocationContext.getMethod().getParameterTypes(), new Class[]{HttpServletRequest.class, HttpServletResponse.class, HttpMessageContext.class})) {
            return this.validateRequest(invocationContext);
        }
        return invocationContext.proceed();
    }

    private AuthenticationStatus validateRequest(InvocationContext invocationContext) throws Exception {
        HttpMessageContext httpMessageContext = (HttpMessageContext)invocationContext.getParameters()[2];
        this.clearStaleState(httpMessageContext);
        if (httpMessageContext.getAuthParameters().isNewAuthentication()) {
            return this.processCallerInitiatedAuthentication(invocationContext, httpMessageContext);
        }
        return this.processContainerInitiatedAuthentication(invocationContext, httpMessageContext);
    }

    private void clearStaleState(HttpMessageContext httpMessageContext) {
        if (httpMessageContext.isProtected() && !httpMessageContext.isAuthenticationRequest() && LoginToContinueMechanism.hasRequest(httpMessageContext.getRequest()) && !LoginToContinueMechanism.hasAuthentication(httpMessageContext.getRequest()) && !httpMessageContext.getRequest().getRequestURI().endsWith("j_security_check")) {
            httpMessageContext.getRequest().getSession().removeAttribute("org.apache.tomee.security.request.original");
            httpMessageContext.getRequest().getSession().removeAttribute("org.apache.tomee.security.request.caller.authentication");
        }
        if (httpMessageContext.getAuthParameters().isNewAuthentication()) {
            httpMessageContext.getRequest().getSession().setAttribute("org.apache.tomee.security.request.caller.authentication", (Object)true);
            httpMessageContext.getRequest().getSession().removeAttribute("org.apache.tomee.security.request.original");
            httpMessageContext.getRequest().getSession().removeAttribute("org.apache.tomee.security.request.authentication");
        }
    }

    private AuthenticationStatus processCallerInitiatedAuthentication(InvocationContext invocationContext, HttpMessageContext httpMessageContext) throws Exception {
        AuthenticationStatus authstatus;
        try {
            authstatus = (AuthenticationStatus)invocationContext.proceed();
        }
        catch (AuthException e) {
            authstatus = AuthenticationStatus.SEND_FAILURE;
        }
        if (authstatus == AuthenticationStatus.SUCCESS && httpMessageContext.getCallerPrincipal() == null) {
            return AuthenticationStatus.SUCCESS;
        }
        return authstatus;
    }

    private AuthenticationStatus processContainerInitiatedAuthentication(InvocationContext invocationContext, HttpMessageContext httpMessageContext) throws Exception {
        if (this.isOnInitialProtectedURL(httpMessageContext)) {
            LoginToContinueMechanism.saveRequest(httpMessageContext.getRequest());
            LoginToContinue loginToContinue = this.getLoginToContinue(invocationContext);
            if (loginToContinue.useForwardToLogin()) {
                return httpMessageContext.forward(loginToContinue.loginPage());
            }
            return httpMessageContext.redirect(this.toAbsoluteUrl(httpMessageContext.getRequest(), loginToContinue.loginPage()));
        }
        if (this.isOnLoginPostback(httpMessageContext)) {
            AuthenticationStatus authenticationStatus = (AuthenticationStatus)invocationContext.proceed();
            if (authenticationStatus.equals((Object)AuthenticationStatus.SUCCESS)) {
                if (httpMessageContext.getCallerPrincipal() == null) {
                    return AuthenticationStatus.SUCCESS;
                }
                if (LoginToContinueMechanism.matchRequest(httpMessageContext.getRequest())) {
                    return AuthenticationStatus.SUCCESS;
                }
                LoginToContinueMechanism.saveAuthentication(httpMessageContext.getRequest(), httpMessageContext.getCallerPrincipal(), httpMessageContext.getGroups());
                SavedRequest savedRequest = LoginToContinueMechanism.getRequest(httpMessageContext.getRequest());
                return httpMessageContext.redirect(savedRequest.getRequestURLWithQueryString());
            }
            if (authenticationStatus.equals((Object)AuthenticationStatus.SEND_FAILURE)) {
                LoginToContinue loginToContinue = this.getLoginToContinue(invocationContext);
                if (!loginToContinue.errorPage().isEmpty()) {
                    return httpMessageContext.redirect(this.toAbsoluteUrl(httpMessageContext.getRequest(), loginToContinue.errorPage()));
                }
                return authenticationStatus;
            }
            return authenticationStatus;
        }
        if (this.isOnOriginalURLAfterAuthenticate(httpMessageContext)) {
            SavedRequest savedRequest = LoginToContinueMechanism.getRequest(httpMessageContext.getRequest());
            SavedAuthentication savedAuthentication = LoginToContinueMechanism.getAuthentication(httpMessageContext.getRequest());
            LoginToContinueMechanism.clearRequestAndAuthentication(httpMessageContext.getRequest());
            SavedHttpServletRequest savedHttpServletRequest = new SavedHttpServletRequest(httpMessageContext.getRequest(), savedRequest);
            return httpMessageContext.withRequest((HttpServletRequest)savedHttpServletRequest).notifyContainerAboutLogin(savedAuthentication.getPrincipal(), savedAuthentication.getGroups());
        }
        return (AuthenticationStatus)invocationContext.proceed();
    }

    private String toAbsoluteUrl(HttpServletRequest request, String page) {
        String url = request.getRequestURL().toString();
        String baseContextUrl = url.substring(0, url.length() - request.getRequestURI().length()) + request.getContextPath();
        return baseContextUrl.endsWith("/") && page.startsWith("/") ? baseContextUrl.substring(0, baseContextUrl.length() - 2) + page : baseContextUrl + page;
    }

    private boolean isOnInitialProtectedURL(HttpMessageContext httpMessageContext) {
        return httpMessageContext.isProtected() && !LoginToContinueMechanism.hasRequest(httpMessageContext.getRequest());
    }

    private boolean isOnLoginPostback(HttpMessageContext httpMessageContext) {
        return LoginToContinueMechanism.hasRequest(httpMessageContext.getRequest()) && !LoginToContinueMechanism.hasAuthentication(httpMessageContext.getRequest());
    }

    private boolean isOnOriginalURLAfterAuthenticate(HttpMessageContext httpMessageContext) {
        return LoginToContinueMechanism.hasRequest(httpMessageContext.getRequest()) && LoginToContinueMechanism.hasAuthentication(httpMessageContext.getRequest());
    }

    private LoginToContinue getLoginToContinue(InvocationContext invocationContext) {
        if (invocationContext.getTarget() instanceof LoginToContinueMechanism) {
            return ((LoginToContinueMechanism)invocationContext.getTarget()).getLoginToContinue();
        }
        throw new IllegalArgumentException();
    }
}

