/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.cxf.common.security.SimpleGroup;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.rt.security.claims.ClaimsSecurityContext;

public class JwtTokenSecurityContext
implements ClaimsSecurityContext {
    private final JwtToken token;
    private final Principal principal;
    private final Set<Principal> roles;
    private final ClaimCollection claims = new ClaimCollection();

    public JwtTokenSecurityContext(JwtToken jwt, String roleClaim) {
        this.principal = new SimplePrincipal(jwt.getClaims().getSubject());
        this.token = jwt;
        if (roleClaim != null && jwt.getClaims().containsProperty(roleClaim)) {
            this.roles = new HashSet<Principal>();
            String role = jwt.getClaims().getStringProperty(roleClaim).trim();
            for (String r : role.split(",")) {
                this.roles.add(new SimpleGroup(r));
            }
        } else {
            this.roles = Collections.emptySet();
        }
        jwt.getClaims().asMap().forEach((name, values) -> {
            Claim claim = new Claim();
            claim.setClaimType((String)name);
            if (values instanceof List) {
                claim.setValues(CastUtils.cast((List)values));
            } else {
                claim.setValues(Collections.singletonList(values));
            }
            this.claims.add(claim);
        });
    }

    public JwtToken getToken() {
        return this.token;
    }

    @Override
    public Subject getSubject() {
        return null;
    }

    @Override
    public Set<Principal> getUserRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.principal;
    }

    @Override
    public boolean isUserInRole(String role) {
        for (Principal principalRole : this.roles) {
            if (principalRole == this.principal || !principalRole.getName().equals(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ClaimCollection getClaims() {
        return this.claims;
    }
}

