/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.InjectionException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.metadata.MethodDescriptor;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.sse.SseContextProvider;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.validation.JAXRSBeanValidationInInterceptor;
import org.apache.cxf.jaxrs.validation.JAXRSBeanValidationOutInterceptor;
import org.apache.cxf.jaxrs.validation.ValidationExceptionMapper;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.servlet.BaseUrlHelper;
import org.apache.cxf.validation.BeanValidationFeature;
import org.apache.cxf.validation.BeanValidationInInterceptor;
import org.apache.cxf.validation.BeanValidationOutInterceptor;
import org.apache.cxf.validation.BeanValidationProvider;
import org.apache.cxf.validation.ResponseConstraintViolationException;
import org.apache.johnzon.jaxrs.WadlDocumentMessageBodyWriter;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Injection;
import org.apache.openejb.api.internal.Internal;
import org.apache.openejb.api.jmx.Description;
import org.apache.openejb.api.jmx.MBean;
import org.apache.openejb.api.jmx.ManagedAttribute;
import org.apache.openejb.api.jmx.ManagedOperation;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.assembler.classic.util.ServiceInfos;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.rest.ThreadLocalContextManager;
import org.apache.openejb.server.cxf.rs.ApplicationData;
import org.apache.openejb.server.cxf.rs.AutoJAXRSInvoker;
import org.apache.openejb.server.cxf.rs.CdiResourceProvider;
import org.apache.openejb.server.cxf.rs.CdiSingletonResourceProvider;
import org.apache.openejb.server.cxf.rs.CxfRSService;
import org.apache.openejb.server.cxf.rs.EJBExceptionMapper;
import org.apache.openejb.server.cxf.rs.Logs;
import org.apache.openejb.server.cxf.rs.NoResourcesFoundException;
import org.apache.openejb.server.cxf.rs.NoopResourceProvider;
import org.apache.openejb.server.cxf.rs.OpenEJBEJBInvoker;
import org.apache.openejb.server.cxf.rs.OpenEJBPerRequestPojoResourceProvider;
import org.apache.openejb.server.cxf.rs.event.ExtensionProviderRegistration;
import org.apache.openejb.server.cxf.rs.event.ServerCreated;
import org.apache.openejb.server.cxf.rs.event.ServerDestroyed;
import org.apache.openejb.server.cxf.rs.sse.TomEESseEventSinkContextProvider;
import org.apache.openejb.server.cxf.transport.HttpDestination;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.ServletRequestAdapter;
import org.apache.openejb.server.rest.EJBRestServiceInfo;
import org.apache.openejb.server.rest.InternalApplication;
import org.apache.openejb.server.rest.RsHttpListener;
import org.apache.openejb.util.AppFinder;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.proxy.ProxyEJB;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;

public class CxfRsHttpListener
implements RsHttpListener {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_RS, CxfRsHttpListener.class);
    private static final java.util.logging.Logger SERVER_IMPL_LOGGER = LogUtils.getL7dLogger(ServerImpl.class);
    public static final String CXF_JAXRS_PREFIX = "cxf.jaxrs.";
    public static final String PROVIDERS_KEY = "cxf.jaxrs.providers";
    public static final String STATIC_RESOURCE_KEY = "cxf.jaxrs.static-resources-list";
    public static final String STATIC_SUB_RESOURCE_RESOLUTION_KEY = "staticSubresourceResolution";
    public static final String RESOURCE_COMPARATOR_KEY = "cxf.jaxrs.resourceComparator";
    private static final String GLOBAL_PROVIDERS = SystemInstance.get().getProperty("cxf.jaxrs.providers");
    public static final boolean TRY_STATIC_RESOURCES = "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.jaxrs.static-first", "true"));
    private static final boolean FAIL_ON_CONSTRAINED_TO = "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.jaxrs.fail-on-constrainedto", "true"));
    private static final Map<String, String> STATIC_CONTENT_TYPES;
    private static final String[] DEFAULT_WELCOME_FILES;
    private static final Object FAKE_SERVICE_OBJECT;
    private final DestinationFactory transportFactory;
    private final String wildcard;
    private final CxfRSService service;
    private HttpDestination destination;
    private Server server;
    private String context = "";
    private String servlet = "";
    private final Collection<Pattern> staticResourcesList = new CopyOnWriteArrayList<Pattern>();
    private final List<ObjectName> jmxNames = new ArrayList<ObjectName>();
    private final Collection<CreationalContext<?>> toRelease = new LinkedHashSet();
    private final Collection<CdiSingletonResourceProvider> singletons = new LinkedHashSet<CdiSingletonResourceProvider>();
    private static final char[] URL_SEP;
    private String pattern;

    public CxfRsHttpListener(DestinationFactory destinationFactory, String star, CxfRSService cxfRSService) {
        this.transportFactory = destinationFactory;
        this.wildcard = star;
        this.service = cxfRSService;
    }

    public void setUrlPattern(String pattern) {
        this.pattern = pattern;
    }

    public void onMessage(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        String pathInfo;
        HttpRequest unwrapped = httpRequest;
        while (ServletRequestAdapter.class.isInstance(unwrapped)) {
            unwrapped = ((ServletRequestAdapter)ServletRequestAdapter.class.cast(unwrapped)).getRequest();
        }
        while (HttpServletRequestWrapper.class.isInstance(unwrapped)) {
            unwrapped = ((HttpServletRequestWrapper)HttpServletRequestWrapper.class.cast(unwrapped)).getRequest();
        }
        if (HttpRequestImpl.class.isInstance(unwrapped)) {
            HttpRequestImpl requestImpl = (HttpRequestImpl)HttpRequestImpl.class.cast(unwrapped);
            requestImpl.initPathFromContext((!this.context.startsWith("/") ? "/" : "") + this.context);
            requestImpl.initServletPath(this.servlet);
        }
        boolean matchedStatic = false;
        if ((TRY_STATIC_RESOURCES || (matchedStatic = this.matchPath((HttpServletRequest)httpRequest))) && this.serveStaticContent((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, pathInfo = httpRequest.getPathInfo())) {
            if (matchedStatic) {
                throw new ServletException("Static resource " + pathInfo + " is not available");
            }
            return;
        }
        this.doInvoke(httpRequest, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvoke(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        Object baseURL = BaseUrlHelper.getBaseURL((HttpServletRequest)(this.pattern != null ? new ServletRequestAdapter((HttpServletRequest)httpRequest){

            public String getServletPath() {
                return CxfRsHttpListener.this.pattern;
            }
        } : httpRequest));
        if (!((String)baseURL).endsWith("/")) {
            baseURL = (String)baseURL + "/";
        }
        httpRequest.setAttribute("org.apache.cxf.transport.endpoint.address", baseURL);
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            this.destination.invoke(null, httpRequest.getServletContext(), (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        }
        finally {
            CxfUtil.clearBusLoader((ClassLoader)oldLoader);
        }
    }

    public boolean matchPath(HttpServletRequest request) {
        if (this.staticResourcesList.isEmpty()) {
            return false;
        }
        String path = request.getRequestURI().substring(request.getContextPath().length());
        if (path.isEmpty()) {
            path = "/";
        }
        for (Pattern pattern : this.staticResourcesList) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    public InputStream findStaticContent(HttpServletRequest request, String[] welcomeFiles) throws ServletException {
        String pathInfo = request.getRequestURI().substring(request.getContextPath().length());
        for (char c : URL_SEP) {
            int indexOf = pathInfo.indexOf(c);
            if (indexOf <= 0) continue;
            pathInfo = pathInfo.substring(0, indexOf);
        }
        if (pathInfo.endsWith("/") || pathInfo.isEmpty()) {
            if (pathInfo.endsWith("/")) {
                pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
            }
            for (String n : welcomeFiles) {
                InputStream is = request.getServletContext().getResourceAsStream(pathInfo + n);
                if (is == null) continue;
                return is;
            }
            return null;
        }
        return request.getServletContext().getResourceAsStream(pathInfo);
    }

    public boolean serveStaticContent(HttpServletRequest request, HttpServletResponse response, String pathInfo) throws ServletException {
        InputStream is = this.findStaticContent(request, DEFAULT_WELCOME_FILES);
        if (is == null) {
            return false;
        }
        try {
            String type;
            int ind = pathInfo.lastIndexOf(".");
            if (ind != -1 && ind < pathInfo.length() && (type = STATIC_CONTENT_TYPES.get(pathInfo.substring(ind + 1))) != null) {
                response.setContentType(type);
            }
            ServletOutputStream os = response.getOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)os);
            os.flush();
            response.setStatus(200);
        }
        catch (IOException ex) {
            throw new ServletException("Static resource " + pathInfo + " can not be written to the output stream");
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private Application findApplication() {
        try {
            ApplicationInfo appInfo = (ApplicationInfo)this.server.getEndpoint().get((Object)Application.class.getName());
            return (Application)appInfo.getProvider();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean applicationProvidesResources(Application application) {
        try {
            if (application == null) {
                return false;
            }
            if (InternalApplication.class.isInstance(application) && ((InternalApplication)InternalApplication.class.cast(application)).getOriginal() == null) {
                return false;
            }
            return !application.getClasses().isEmpty() || !application.getSingletons().isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isCXFResource(HttpServletRequest request) {
        block5: {
            try {
                Application application = this.findApplication();
                if (!this.applicationProvidesResources(application)) {
                    JAXRSServiceImpl service = (JAXRSServiceImpl)this.server.getEndpoint().getService();
                    if (service == null) {
                        return false;
                    }
                    String pathToMatch = HttpUtils.getPathToMatch((String)request.getServletPath(), (String)this.pattern, (boolean)true);
                    List resources = service.getClassResourceInfos();
                    for (ClassResourceInfo info : resources) {
                        if (info.getResourceClass() == null || info.getURITemplate() == null) continue;
                        MultivaluedHashMap parameters = new MultivaluedHashMap();
                        if (!info.getURITemplate().match(pathToMatch, (MultivaluedMap)parameters)) continue;
                        return true;
                    }
                    break block5;
                }
                return true;
            }
            catch (Exception e) {
                LOGGER.info("No JAX-RS service");
            }
        }
        return false;
    }

    @Deprecated
    public void deploySingleton(String contextRoot, String fullContext, Object o, Application application, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        this.deploy(contextRoot, o.getClass(), fullContext, (ResourceProvider)new SingletonResourceProvider(o), o, application, null, additionalProviders, configuration, null);
    }

    @Deprecated
    public void deployPojo(ClassLoader loader, String contextRoot, String fullContext, Class<?> loadedClazz, Application application, Collection<Injection> injections, javax.naming.Context context, WebBeansContext owbCtx, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        this.deploy(contextRoot, loadedClazz, fullContext, new OpenEJBPerRequestPojoResourceProvider(loader, loadedClazz, injections, context, owbCtx), null, application, null, additionalProviders, configuration, owbCtx);
    }

    @Deprecated
    public void deployEJB(String contextRoot, String fullContext, BeanContext beanContext, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        Object proxy = ProxyEJB.subclassProxy((BeanContext)beanContext);
        this.deploy(contextRoot, beanContext.getBeanClass(), fullContext, new NoopResourceProvider(beanContext.getBeanClass(), proxy), proxy, (Application)new InternalApplication(null), (Invoker)new OpenEJBEJBInvoker(Collections.singleton(beanContext)), additionalProviders, configuration, beanContext.getWebBeansContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploy(String contextRoot, Class<?> clazz, String address, ResourceProvider rp, Object serviceBean, Application application, Invoker invoker, Collection<Object> additionalProviders, ServiceConfiguration configuration, WebBeansContext webBeansContext) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            JAXRSServerFactoryBean factory = this.newFactory(address, CxfRsHttpListener.createServiceJmxName(clazz.getClassLoader()), CxfRsHttpListener.createEndpointName(application));
            this.configureFactory(additionalProviders, configuration, factory, webBeansContext, application);
            factory.setResourceClasses(new Class[]{clazz});
            this.context = contextRoot;
            if (this.context == null) {
                this.context = "";
            }
            if (!this.context.startsWith("/")) {
                this.context = "/" + this.context;
            }
            if (rp != null) {
                factory.setResourceProvider(rp);
            }
            if (application != null) {
                factory.setApplication(application);
            }
            if (invoker != null) {
                factory.setInvoker(invoker);
            }
            if (serviceBean != null) {
                factory.setServiceBean(serviceBean);
            } else {
                factory.setServiceClass(clazz);
            }
            factory.setTransportId("http://cxf.apache.org/transports/http/sse");
            this.server = factory.create();
            this.destination = (HttpDestination)this.server.getDestination();
            this.fireServerCreated(oldLoader);
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    private void fireServerCreated(ClassLoader oldLoader) {
        WebContext webContext;
        Object ctx = AppFinder.findAppContextOrWeb((ClassLoader)oldLoader, (AppFinder.Transformer)new AppFinder.Transformer<Object>(){

            public Object from(AppContext appCtx) {
                return appCtx;
            }

            public Object from(WebContext webCtx) {
                return webCtx;
            }
        });
        AppContext appCtx = AppContext.class.isInstance(ctx) ? (AppContext)AppContext.class.cast(ctx) : ((WebContext)WebContext.class.cast(ctx)).getAppContext();
        WebContext webContext2 = webContext = appCtx == ctx ? null : (WebContext)WebContext.class.cast(ctx);
        if (webContext == null && appCtx.getWebContexts().size() == 1 && ((WebContext)appCtx.getWebContexts().get(0)).getClassLoader() == oldLoader) {
            webContext = (WebContext)appCtx.getWebContexts().get(0);
        }
        SystemInstance.get().fireEvent((Object)new ServerCreated(this.server, appCtx, webContext, this.context));
    }

    private List<Object> providers(Collection<ServiceInfo> services, Collection<Object> additionalProviders, WebBeansContext ctx) {
        ArrayList<Object> instances = new ArrayList<Object>();
        BeanManagerImpl bm = ctx == null ? null : ctx.getBeanManagerImpl();
        for (Object o : additionalProviders) {
            String name;
            Class<?> clazz;
            if (o instanceof Class) {
                List instance;
                clazz = (Class<?>)o;
                if (this.isNotServerProvider(clazz) || this.shouldSkipProvider(name = clazz.getName())) continue;
                if (bm != null && bm.isInUse()) {
                    try {
                        Set beans = bm.getBeans(clazz, new Annotation[0]);
                        if (beans != null && !beans.isEmpty()) {
                            Bean bean = bm.resolve(beans);
                            CreationalContextImpl creationalContext = bm.createCreationalContext((Contextual)bean);
                            instances.add(bm.getReference(bean, clazz, (CreationalContext)creationalContext));
                            this.toRelease.add((CreationalContext<?>)creationalContext);
                            continue;
                        }
                    }
                    catch (Throwable th) {
                        LOGGER.info("Can't use CDI to create provider " + name);
                    }
                }
                if ((instance = ServiceInfos.resolve(services, (String[])new String[]{name}, (ServiceInfos.Factory)OpenEJBProviderFactory.INSTANCE)) != null && !instance.isEmpty()) {
                    instances.add(instance.iterator().next());
                    continue;
                }
                try {
                    instances.add(this.newProvider(clazz));
                }
                catch (Exception e) {
                    LOGGER.error("can't instantiate " + name, (Throwable)e);
                }
                continue;
            }
            clazz = o.getClass();
            if (this.isNotServerProvider(clazz) || this.shouldSkipProvider(name = clazz.getName())) continue;
            instances.add(o);
        }
        return instances;
    }

    private boolean isNotServerProvider(Class<?> clazz) {
        ConstrainedTo ct = clazz.getAnnotation(ConstrainedTo.class);
        if (ct != null && ct.value() != RuntimeType.SERVER) {
            if (!FAIL_ON_CONSTRAINED_TO) {
                LOGGER.warning(clazz + " is not a SERVER provider, ignoring");
                return true;
            }
            throw new IllegalArgumentException(clazz + " is not a SERVER provider");
        }
        return ClientRequestFilter.class.isAssignableFrom(clazz);
    }

    private boolean shouldSkipProvider(String name) {
        return !this.service.isActive(name) || name.startsWith("org.apache.wink.common.internal.");
    }

    private void addMandatoryProviders(Collection<Object> instances, ServiceConfiguration serviceConfiguration) {
        if (SystemInstance.get().getProperty("openejb.jaxrs.jsonProviders") == null && !this.shouldSkipProvider(WadlDocumentMessageBodyWriter.class.getName())) {
            instances.add(new WadlDocumentMessageBodyWriter());
        }
        if (!this.shouldSkipProvider(EJBExceptionMapper.class.getName())) {
            instances.add(new EJBExceptionMapper());
        }
        if (!this.shouldSkipProvider(ValidationExceptionMapper.class.getName())) {
            instances.add(new ValidationExceptionMapper());
            String level = SystemInstance.get().getProperty("openejb.cxf.rs.bval.log.level", serviceConfiguration.getProperties().getProperty("cxf.jaxrs.bval.log.level"));
            if (level != null) {
                try {
                    LogUtils.getL7dLogger(ValidationExceptionMapper.class).setLevel(Level.parse(level));
                }
                catch (UnsupportedOperationException uoe) {
                    LOGGER.warning("Can't set level " + level + " on org.apache.cxf.jaxrs.validation.ValidationExceptionMapper logger, please configure it in your logging framework.");
                }
            }
        }
    }

    private Object newProvider(Class<?> clazz) throws IllegalAccessException, InstantiationException {
        return clazz.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        for (ObjectName objectName : this.jmxNames) {
            LocalMBeanServer.unregisterSilently((ObjectName)objectName);
        }
        for (CreationalContext creationalContext : this.toRelease) {
            try {
                creationalContext.release();
            }
            catch (Exception e) {
                LOGGER.warning(e.getMessage(), (Throwable)e);
            }
        }
        for (CdiSingletonResourceProvider cdiSingletonResourceProvider : this.singletons) {
            try {
                cdiSingletonResourceProvider.release();
            }
            catch (Exception e) {
                LOGGER.warning(e.getMessage(), (Throwable)e);
            }
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            this.server.destroy();
            SystemInstance.get().fireEvent((Object)new ServerDestroyed(this.server));
        }
        catch (RuntimeException runtimeException) {
            LOGGER.warning("Can't stop correctly the endpoint " + this.server);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(runtimeException.getMessage(), (Throwable)runtimeException);
            }
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployApplication(Application application, String prefix, String webContext, Collection<Object> additionalProviders, Map<String, EJBRestServiceInfo> restEjbs, ClassLoader classLoader, Collection<Injection> injections, javax.naming.Context context, WebBeansContext owbCtx, ServiceConfiguration serviceConfiguration) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            ApplicationData applicationData = this.getApplicationData(application, prefix, additionalProviders);
            this.logApplication(applicationData);
            if (applicationData.getResources().size() == 0) {
                throw new NoResourcesFoundException(applicationData);
            }
            JAXRSServerFactoryBean factory = this.newFactory(prefix, CxfRsHttpListener.createServiceJmxName(classLoader), CxfRsHttpListener.createEndpointName(application));
            this.configureFactory(additionalProviders, serviceConfiguration, factory, owbCtx, application);
            factory.setApplication(application);
            ArrayList classes = new ArrayList();
            for (Class clazz : application.getClasses()) {
                if (additionalProviders.contains(clazz) || clazz.isInterface()) continue;
                classes.add(clazz);
                EJBRestServiceInfo restServiceInfo = this.getEjbRestServiceInfo(restEjbs, clazz);
                if (restServiceInfo != null) {
                    Object proxy = ProxyEJB.subclassProxy((BeanContext)restServiceInfo.context);
                    factory.setResourceProvider(clazz, (ResourceProvider)new NoopResourceProvider(restServiceInfo.context.getBeanClass(), proxy));
                    continue;
                }
                if (owbCtx != null) {
                    BeanManagerImpl bm = owbCtx.getBeanManagerImpl();
                    Bean bean = null;
                    if (bm != null && bm.isInUse()) {
                        try {
                            Set beans = bm.getBeans((Type)clazz, new Annotation[0]);
                            bean = bm.resolve(beans);
                        }
                        catch (InjectionException ie) {
                            String msg = "Resource class " + clazz.getName() + " can not be instantiated";
                            LOGGER.warning(msg, (Throwable)ie);
                            throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
                        }
                        if (bean != null && this.isConsideredSingleton(bean.getScope())) {
                            Object reference = bm.getReference(bean, (Type)bean.getBeanClass(), (CreationalContext)bm.createCreationalContext((Contextual)bean));
                            factory.setResourceProvider(clazz, (ResourceProvider)new CdiSingletonResourceProvider(classLoader, clazz, reference, injections, context, owbCtx));
                            continue;
                        }
                    }
                }
                factory.setResourceProvider(clazz, (ResourceProvider)new OpenEJBPerRequestPojoResourceProvider(classLoader, clazz, injections, context, owbCtx));
            }
            for (Object o : application.getSingletons()) {
                if (additionalProviders.contains(o)) continue;
                Iterator clazz = CxfRsHttpListener.realClass(o.getClass());
                classes.add((Class<?>)((Object)clazz));
                EJBRestServiceInfo restServiceInfo = this.getEjbRestServiceInfo(restEjbs, (Class<?>)((Object)clazz));
                if (restServiceInfo != null) {
                    Object proxy = ProxyEJB.subclassProxy((BeanContext)restServiceInfo.context);
                    factory.setResourceProvider(clazz, (ResourceProvider)new NoopResourceProvider(restServiceInfo.context.getBeanClass(), proxy));
                    continue;
                }
                if (owbCtx != null && owbCtx.getBeanManagerImpl().isInUse()) {
                    CdiSingletonResourceProvider provider = new CdiSingletonResourceProvider(classLoader, (Class<?>)((Object)clazz), o, injections, context, owbCtx);
                    this.singletons.add(provider);
                    factory.setResourceProvider(clazz, (ResourceProvider)provider);
                    continue;
                }
                factory.setResourceProvider(clazz, (ResourceProvider)new SingletonResourceProvider(o));
            }
            factory.setResourceClasses(classes);
            factory.setInvoker((Invoker)new AutoJAXRSInvoker(restEjbs));
            CxfRsHttpListener.injectApplication(application, factory);
            factory.setApplication(application);
            this.context = webContext;
            if (!webContext.startsWith("/")) {
                this.context = "/" + webContext;
            }
            Level level = SERVER_IMPL_LOGGER.getLevel();
            try {
                SERVER_IMPL_LOGGER.setLevel(Level.OFF);
            }
            catch (UnsupportedOperationException o) {
                // empty catch block
            }
            try {
                factory.setProvider((Object)new SseContextProvider());
                factory.setProvider((Object)new TomEESseEventSinkContextProvider());
                this.server = factory.create();
                this.fixProviders(serviceConfiguration);
                this.fireServerCreated(oldLoader);
                ServerProviderFactory spf = (ServerProviderFactory)ServerProviderFactory.class.cast(this.server.getEndpoint().get((Object)ServerProviderFactory.class.getName()));
                LOGGER.info("Using readers:");
                for (Object provider : (List)List.class.cast(Reflections.get((Object)spf, (String)"messageReaders"))) {
                    LOGGER.info("     " + ((ProviderInfo)ProviderInfo.class.cast(provider)).getProvider());
                }
                LOGGER.info("Using writers:");
                for (Object provider : (List)List.class.cast(Reflections.get((Object)spf, (String)"messageWriters"))) {
                    LOGGER.info("     " + ((ProviderInfo)ProviderInfo.class.cast(provider)).getProvider());
                }
                LOGGER.info("Using exception mappers:");
                for (Object provider : (List)List.class.cast(Reflections.get((Object)spf, (String)"exceptionMappers"))) {
                    LOGGER.info("     " + ((ProviderInfo)ProviderInfo.class.cast(provider)).getProvider());
                }
            }
            finally {
                try {
                    SERVER_IMPL_LOGGER.setLevel(level);
                }
                catch (UnsupportedOperationException spf) {}
            }
            int servletIdx = 1 + this.context.substring(1).indexOf(47);
            if (servletIdx > 0) {
                this.servlet = this.context.substring(servletIdx);
                this.context = this.context.substring(0, servletIdx);
            }
            this.destination = (HttpDestination)this.server.getDestination();
            String base = prefix.endsWith("/") ? prefix.substring(0, prefix.length() - 1) : (prefix.endsWith(this.wildcard) ? prefix.substring(0, prefix.length() - this.wildcard.length()) : prefix);
            this.logEndpoints(application, prefix, restEjbs, factory, base);
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    private void logApplication(ApplicationData applicationData) {
        String toString;
        LOGGER.info(applicationData.toString());
        for (ApplicationData.Resource resource : applicationData.getResources()) {
            toString = resource.toString();
            LOGGER.info(toString);
        }
        for (ApplicationData.Provider provider1 : applicationData.getProviders()) {
            toString = provider1.toString();
            LOGGER.info(toString);
        }
        for (ApplicationData.Invalid invalid : applicationData.getInvalids()) {
            toString = invalid.toString();
            LOGGER.warning(toString);
        }
    }

    private ApplicationData getApplicationData(Application application, String prefix, Collection<Object> additionalProviders) {
        ApplicationData applicationData = new ApplicationData(prefix, application);
        HashSet declaredClasses = new HashSet();
        HashSet declaredSingletons = new HashSet();
        if (application instanceof InternalApplication && ((InternalApplication)application).getOriginal() != null) {
            InternalApplication internalApplication = (InternalApplication)application;
            declaredClasses.addAll(internalApplication.getOriginal().getClasses());
            declaredSingletons.addAll(internalApplication.getOriginal().getSingletons());
        } else {
            declaredClasses.addAll(application.getClasses());
            declaredSingletons.addAll(application.getSingletons());
        }
        for (Object declaredSingleton : new ArrayList(declaredSingletons)) {
            if (declaredSingleton instanceof Class) continue;
            declaredSingletons.add(declaredSingleton.getClass());
        }
        HashSet seen = new HashSet();
        for (Object additionalProvider : additionalProviders) {
            Class<?> providerClass = additionalProvider instanceof Class ? (Class<?>)additionalProvider : additionalProvider.getClass();
            if (!seen.add(providerClass)) continue;
            if (declaredSingletons.contains(providerClass)) {
                applicationData.addProvider(false, providerClass, additionalProvider);
                continue;
            }
            if (declaredClasses.contains(providerClass)) {
                applicationData.addProvider(false, providerClass, null);
                continue;
            }
            if (additionalProvider instanceof Class) {
                applicationData.addProvider(true, providerClass, null);
                continue;
            }
            applicationData.addProvider(true, providerClass, additionalProvider);
        }
        for (Class clazz : application.getClasses()) {
            if (additionalProviders.contains(clazz)) continue;
            if (clazz.isInterface()) {
                applicationData.addInvalid(clazz, "is interface");
                continue;
            }
            if (clazz.isEnum()) {
                applicationData.addInvalid(clazz, "is enum");
                continue;
            }
            if (clazz.isPrimitive()) {
                applicationData.addInvalid(clazz, "is primitive");
                continue;
            }
            boolean discovered = !declaredClasses.contains(clazz) && !declaredSingletons.contains(clazz);
            applicationData.addResource(discovered, clazz, null);
        }
        for (Object singleton : application.getSingletons()) {
            if (additionalProviders.contains(singleton)) continue;
            Class<?> clazz = CxfRsHttpListener.realClass(singleton.getClass());
            boolean configured = declaredSingletons.contains(clazz) || declaredSingletons.contains(singleton.getClass());
            applicationData.addResource(!configured, clazz, singleton);
        }
        return applicationData;
    }

    public static void injectApplication(Application application, JAXRSServerFactoryBean factory) {
        if (application == null) {
            return;
        }
        if (application instanceof InternalApplication) {
            InternalApplication internalApplication = (InternalApplication)application;
            Application original = internalApplication.getOriginal();
            CxfRsHttpListener.injectApplication(original, factory);
            return;
        }
        Bus bus = factory.getBus();
        new ApplicationInfo(application, bus);
    }

    private boolean isConsideredSingleton(Class<?> scope) {
        return Singleton.class == scope || Dependent.class == scope;
    }

    private void fixProviders(ServiceConfiguration serviceConfiguration) {
        ServerProviderFactory spf = (ServerProviderFactory)ServerProviderFactory.class.cast(this.server.getEndpoint().get((Object)ServerProviderFactory.class.getName()));
        for (String field : Arrays.asList("messageWriters", "messageReaders")) {
            List values = (List)List.class.cast(Reflections.get((Object)spf, (String)field));
            boolean customJsonProvider = false;
            for (ProviderInfo o : values) {
                String name = o.getResourceClass().getName();
                if (!"org.apache.johnzon.jaxrs.ConfigurableJohnzonProvider".equals(name) && !"org.apache.johnzon.jaxrs.jsonb.jaxrs.JsonbJaxrsProvider".equals(name) && !name.contains("com.fasterxml.jackson.jaxrs.json")) continue;
                customJsonProvider = true;
                break;
            }
            Iterator it = values.iterator();
            while (it.hasNext()) {
                String name = ((ProviderInfo)it.next()).getResourceClass().getName();
                if (("org.apache.johnzon.jaxrs.JohnzonProvider".equals(name) || "org.apache.openejb.server.cxf.rs.CxfRSService$TomEEJohnzonProvider".equals(name)) && customJsonProvider) {
                    it.remove();
                }
                if (this.isActive(name, serviceConfiguration)) continue;
                it.remove();
            }
        }
    }

    public boolean isActive(String name, ServiceConfiguration serviceConfiguration) {
        String key = name + ".activated";
        return "true".equalsIgnoreCase(SystemInstance.get().getProperty(key, serviceConfiguration.getProperties().getProperty(key, "true")));
    }

    private static Class<?> realClass(Class<?> aClass) {
        Class<?> result = aClass;
        while (result.getName().contains("$$")) {
            if ((result = result.getSuperclass()) != null) continue;
            return aClass;
        }
        return result;
    }

    private EJBRestServiceInfo getEjbRestServiceInfo(Map<String, EJBRestServiceInfo> restEjbs, Class<?> clazz) {
        String name = clazz.getName();
        EJBRestServiceInfo restServiceInfo = restEjbs.get(name);
        if (name.endsWith("$$Impl") && (restServiceInfo = restEjbs.get(name = name.substring(0, name.length() - "$$Impl".length()))) != null) {
            restEjbs.put(clazz.getName(), restServiceInfo);
        }
        return restServiceInfo;
    }

    private static String createEndpointName(Application application) {
        if (application == null) {
            return "jaxrs-application";
        }
        if (InternalApplication.class.isInstance(application)) {
            Application original = ((InternalApplication)InternalApplication.class.cast(application)).getOriginal();
            if (original != null) {
                return original.getClass().getSimpleName();
            }
            return "jaxrs-application";
        }
        return application.getClass().getSimpleName();
    }

    private static String createServiceJmxName(ClassLoader classLoader) {
        AppContext app = (AppContext)AppFinder.findAppContextOrWeb((ClassLoader)classLoader, (AppFinder.Transformer)AppFinder.AppContextTransformer.INSTANCE);
        return app == null ? "application" : app.getId();
    }

    private void logEndpoints(Application application, String prefix, Map<String, EJBRestServiceInfo> restEjbs, JAXRSServerFactoryBean factory, String base) {
        ArrayList<Logs.LogResourceEndpointInfo> resourcesToLog = new ArrayList<Logs.LogResourceEndpointInfo>();
        int classSize = 0;
        int addressSize = 0;
        JAXRSServiceImpl service = (JAXRSServiceImpl)factory.getServiceFactory().getService();
        List resources = service.getClassResourceInfos();
        for (ClassResourceInfo info : resources) {
            if (info.getResourceClass() == null) continue;
            String address = Logs.singleSlash(base, info.getURITemplate().getValue());
            String clazz = info.getResourceClass().getName();
            String type = restEjbs.containsKey(clazz) ? "EJB" : "Pojo";
            classSize = Math.max(classSize, clazz.length());
            addressSize = Math.max(addressSize, address.length());
            int methodSize = 7;
            int methodStrSize = 0;
            ArrayList<Logs.LogOperationEndpointInfo> toLog = new ArrayList<Logs.LogOperationEndpointInfo>();
            MethodDispatcher md = info.getMethodDispatcher();
            for (OperationResourceInfo ori : md.getOperationResourceInfos()) {
                String httpMethod = ori.getHttpMethod();
                String currentAddress = Logs.singleSlash(address, ori.getURITemplate().getValue());
                String methodToStr = Logs.toSimpleString(ori.getMethodToInvoke());
                toLog.add(new Logs.LogOperationEndpointInfo(httpMethod, currentAddress, methodToStr));
                if (httpMethod != null) {
                    methodSize = Math.max(methodSize, httpMethod.length());
                }
                addressSize = Math.max(addressSize, currentAddress.length());
                methodStrSize = Math.max(methodStrSize, methodToStr.length());
            }
            Collections.sort(toLog);
            resourcesToLog.add(new Logs.LogResourceEndpointInfo(type, address, clazz, toLog, methodSize, methodStrSize));
        }
        LOGGER.info("REST Application: " + Logs.forceLength(prefix, addressSize, true) + " -> " + (InternalApplication.class.isInstance(application) && ((InternalApplication)InternalApplication.class.cast(application)).getOriginal() != null ? ((InternalApplication)InternalApplication.class.cast(application)).getOriginal() : application));
        Collections.sort(resourcesToLog);
        for (Logs.LogResourceEndpointInfo resource : resourcesToLog) {
            ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management").set("j2eeType", "JAX-RS").set("J2EEServer", "openejb").set("J2EEApplication", base).set("EndpointType", resource.type).set("name", resource.classname);
            ObjectName jmxObjectName = jmxName.build();
            LocalMBeanServer.registerDynamicWrapperSilently((Object)new RestServiceMBean(resource), (ObjectName)jmxObjectName);
            this.jmxNames.add(jmxObjectName);
            LOGGER.info("     Service URI: " + Logs.forceLength(resource.address, addressSize, true) + " -> " + Logs.forceLength(resource.type, 4, false) + " " + Logs.forceLength(resource.classname, classSize, true));
            for (Logs.LogOperationEndpointInfo log : resource.operations) {
                LOGGER.info("          " + Logs.forceLength(log.http, resource.methodSize, false) + " " + Logs.forceLength(log.address, addressSize, true) + " ->      " + Logs.forceLength(log.method, resource.methodStrSize, true));
            }
            resource.operations.clear();
        }
        resourcesToLog.clear();
    }

    private JAXRSServerFactoryBean newFactory(String prefix, final String service, final String endpoint) {
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean(){

            protected Endpoint createEndpoint() throws BusException, EndpointException {
                Endpoint created = super.createEndpoint();
                created.put((Object)"managed.service.name", (Object)service);
                created.put((Object)"managed.endpoint.name", (Object)endpoint);
                return created;
            }
        };
        factory.setDestinationFactory(this.transportFactory);
        factory.setBus(CxfUtil.getBus());
        factory.setAddress(prefix);
        return factory;
    }

    private void configureFactory(Collection<Object> givenAdditionalProviders, ServiceConfiguration serviceConfiguration, JAXRSServerFactoryBean factory, WebBeansContext ctx, Application application) {
        String staticResources;
        String resourceComparator;
        CxfUtil.configureEndpoint((AbstractEndpointFactory)factory, (ServiceConfiguration)serviceConfiguration, (String)CXF_JAXRS_PREFIX);
        boolean enforceCxfBvalMapper = false;
        if (ctx == null || !ctx.getBeanManagerImpl().isInUse()) {
            boolean bvalActive = Boolean.parseBoolean(SystemInstance.get().getProperty("openejb.cxf.rs.bval.active", serviceConfiguration.getProperties().getProperty("cxf.jaxrs.bval.active", "true")));
            if (factory.getFeatures() == null && bvalActive) {
                factory.setFeatures(new ArrayList());
            } else if (bvalActive) {
                for (Feature f : factory.getFeatures()) {
                    if (!BeanValidationFeature.class.isInstance(f)) continue;
                    bvalActive = false;
                    break;
                }
                for (Interceptor i : factory.getInInterceptors()) {
                    if (!BeanValidationInInterceptor.class.isInstance(i)) continue;
                    bvalActive = false;
                    break;
                }
                for (Interceptor i : factory.getOutInterceptors()) {
                    if (!BeanValidationOutInterceptor.class.isInstance(i)) continue;
                    bvalActive = false;
                    break;
                }
            }
            if (bvalActive) {
                BeanValidationProvider provider = new BeanValidationProvider();
                ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
                final Validator validator = validatorFactory.getValidator();
                JAXRSBeanValidationInInterceptor in = new JAXRSBeanValidationInInterceptor(){

                    protected Object getServiceObject(Message message) {
                        return CxfRsHttpListener.this.getServiceObject(message);
                    }
                };
                in.setProvider(provider);
                in.setServiceObject(FAKE_SERVICE_OBJECT);
                factory.getInInterceptors().add(in);
                JAXRSBeanValidationOutInterceptor jAXRSBeanValidationOutInterceptor = new JAXRSBeanValidationOutInterceptor(){

                    protected Object getServiceObject(Message message) {
                        return CxfRsHttpListener.this.getServiceObject(message);
                    }

                    protected void handleValidation(Message message, Object resourceInstance, Method method, List<Object> arguments) {
                        MethodDescriptor constraintsForMethod = validator.getConstraintsForClass(resourceInstance.getClass()).getConstraintsForMethod(method.getName(), (Class[])method.getParameterTypes());
                        if (constraintsForMethod != null && constraintsForMethod.hasConstrainedReturnValue()) {
                            super.handleValidation(message, resourceInstance, method, arguments);
                        }
                    }
                };
                jAXRSBeanValidationOutInterceptor.setEnforceOnlyBeanConstraints(true);
                jAXRSBeanValidationOutInterceptor.setProvider(provider);
                jAXRSBeanValidationOutInterceptor.setServiceObject(FAKE_SERVICE_OBJECT);
                factory.getOutInterceptors().add(jAXRSBeanValidationOutInterceptor);
                enforceCxfBvalMapper = true;
            }
        }
        Collection services = serviceConfiguration.getAvailableServices();
        String staticSubresourceResolution = serviceConfiguration.getProperties().getProperty("cxf.jaxrs.staticSubresourceResolution");
        if (staticSubresourceResolution != null) {
            factory.setStaticSubresourceResolution("true".equalsIgnoreCase(staticSubresourceResolution));
        }
        if ((resourceComparator = serviceConfiguration.getProperties().getProperty(RESOURCE_COMPARATOR_KEY)) != null) {
            try {
                ResourceComparator instance = (ResourceComparator)ServiceInfos.resolve((Collection)services, (String)resourceComparator);
                if (instance == null) {
                    instance = (ResourceComparator)Thread.currentThread().getContextClassLoader().loadClass(resourceComparator).newInstance();
                }
                factory.setResourceComparator(instance);
            }
            catch (Exception e) {
                LOGGER.error("Can't create the resource comparator " + resourceComparator, (Throwable)e);
            }
        }
        if ((staticResources = serviceConfiguration.getProperties().getProperty(STATIC_RESOURCE_KEY)) != null) {
            String[] resources;
            for (String r : resources = staticResources.split(",")) {
                String trimmed = r.trim();
                if (trimmed.isEmpty()) continue;
                this.staticResourcesList.add(Pattern.compile(trimmed));
            }
        }
        HashSet<String> providersConfig = null;
        String string = serviceConfiguration.getProperties().getProperty(PROVIDERS_KEY);
        if (string != null) {
            providersConfig = new HashSet<String>();
            for (String p : Arrays.asList(string.split(","))) {
                providersConfig.add(p.trim());
            }
        }
        if (GLOBAL_PROVIDERS != null) {
            if (providersConfig == null) {
                providersConfig = new HashSet();
            }
            providersConfig.addAll(Arrays.asList(GLOBAL_PROVIDERS.split(",")));
        }
        String string2 = "cxf.jaxrs.skip-provider-scanning";
        boolean ignoreAutoProviders = "true".equalsIgnoreCase(SystemInstance.get().getProperty("cxf.jaxrs.skip-provider-scanning", serviceConfiguration.getProperties().getProperty("cxf.jaxrs.skip-provider-scanning", "false")));
        ArrayList<Object> additionalProviders = new ArrayList<Object>(ignoreAutoProviders ? Collections.EMPTY_LIST : givenAdditionalProviders);
        for (Class clzz : application.getClasses()) {
            if (!this.isProvider(clzz) || additionalProviders.contains(clzz)) continue;
            additionalProviders.add(clzz);
        }
        List<Object> providers = null;
        if (providersConfig != null && (providers = ServiceInfos.resolve((Collection)services, (String[])providersConfig.toArray(new String[providersConfig.size()]), (ServiceInfos.Factory)OpenEJBProviderFactory.INSTANCE)) != null && additionalProviders != null && !additionalProviders.isEmpty()) {
            providers.addAll(this.providers(serviceConfiguration.getAvailableServices(), additionalProviders, ctx));
        }
        if (providers == null) {
            providers = new ArrayList<Object>(4);
            if (additionalProviders != null && !additionalProviders.isEmpty()) {
                providers.addAll(this.providers(serviceConfiguration.getAvailableServices(), additionalProviders, ctx));
            }
        }
        if (!ignoreAutoProviders) {
            this.addMandatoryProviders(providers, serviceConfiguration);
            if (enforceCxfBvalMapper && !this.shouldSkipProvider(CxfResponseValidationExceptionMapper.class.getName())) {
                providers.add(new CxfResponseValidationExceptionMapper());
            }
        }
        SystemInstance.get().fireEvent((Object)new ExtensionProviderRegistration((AppContext)AppFinder.findAppContextOrWeb((ClassLoader)Thread.currentThread().getContextClassLoader(), (AppFinder.Transformer)AppFinder.AppContextTransformer.INSTANCE), providers));
        if (!providers.isEmpty()) {
            factory.setProviders(providers);
        }
    }

    private boolean isProvider(Class<?> clazz) {
        return ContextResolver.class.isAssignableFrom(clazz) || ExceptionMapper.class.isAssignableFrom(clazz) || MessageBodyReader.class.isAssignableFrom(clazz) || MessageBodyWriter.class.isAssignableFrom(clazz) || ParamConverterProvider.class.isAssignableFrom(clazz);
    }

    private Object getServiceObject(Message message) {
        OperationResourceInfo ori = (OperationResourceInfo)message.getExchange().get(OperationResourceInfo.class);
        if (ori == null) {
            return null;
        }
        if (!ori.getClassResourceInfo().isRoot()) {
            return message.getExchange().get((Object)"org.apache.cxf.service.object.last");
        }
        ResourceProvider resourceProvider = ori.getClassResourceInfo().getResourceProvider();
        if (resourceProvider.isSingleton()) {
            return resourceProvider.getInstance(message);
        }
        Object o = message.getExchange().get((Object)CdiResourceProvider.INSTANCE_KEY);
        return o != null || !OpenEJBPerRequestPojoResourceProvider.class.isInstance(resourceProvider) ? o : resourceProvider.getInstance(message);
    }

    static {
        DEFAULT_WELCOME_FILES = new String[]{"/index.html", "/index.htm"};
        FAKE_SERVICE_OBJECT = new Object();
        URL_SEP = new char[]{'?', '#', ';'};
        STATIC_CONTENT_TYPES = new HashMap<String, String>();
        STATIC_CONTENT_TYPES.put("html", "text/html");
        STATIC_CONTENT_TYPES.put("htm", "text/html");
        STATIC_CONTENT_TYPES.put("xhtml", "text/html");
        STATIC_CONTENT_TYPES.put("txt", "text/plain");
        STATIC_CONTENT_TYPES.put("css", "text/css");
        STATIC_CONTENT_TYPES.put("jpg", "image/jpg");
        STATIC_CONTENT_TYPES.put("png", "image/png");
        STATIC_CONTENT_TYPES.put("ico", "image/ico");
        STATIC_CONTENT_TYPES.put("pdf", "application/pdf");
        STATIC_CONTENT_TYPES.put("xsd", "application/xml");
    }

    @Provider
    public static class CxfResponseValidationExceptionMapper
    implements ExceptionMapper<ResponseConstraintViolationException> {
        public Response toResponse(ResponseConstraintViolationException exception) {
            return JAXRSUtils.toResponse((Response.Status)Response.Status.BAD_REQUEST);
        }
    }

    @MBean
    @Internal
    @Description(value="JAX-RS service information")
    public class RestServiceMBean {
        private final String type;
        private final String address;
        private final String classname;
        private final TabularData operations;

        public RestServiceMBean(Logs.LogResourceEndpointInfo jmxName) {
            this.type = jmxName.type;
            this.address = jmxName.address;
            this.classname = jmxName.classname;
            String[] names = new String[jmxName.operations.size()];
            Object[] values = new String[jmxName.operations.size()];
            int idx = 0;
            for (Logs.LogOperationEndpointInfo operation : jmxName.operations) {
                names[idx] = operation.http + " " + operation.address;
                values[idx] = operation.method;
                ++idx;
            }
            this.operations = LocalMBeanServer.tabularData((String)"Operations", (String)"Operations for this endpoint", (String[])names, (Object[])values);
        }

        @ManagedAttribute
        @Description(value="The type of the REST service")
        public String getWadlUrl() {
            if (this.address.endsWith("?_wadl")) {
                return this.address;
            }
            return this.address + "?_wadl";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ManagedOperation
        @Description(value="The type of the REST service")
        public String getWadl(String format) {
            if (format != null && format.toLowerCase().contains("json")) {
                InputStream inputStream = null;
                try {
                    URL url = new URL(this.getWadlUrl() + "&_type=json");
                    HttpURLConnection connection = (HttpURLConnection)HttpURLConnection.class.cast(url.openConnection());
                    connection.setRequestProperty("Accept", "application/json");
                    connection.setRequestProperty("Content-type", "application/json");
                    inputStream = connection.getInputStream();
                    String string = IO.slurp((InputStream)inputStream);
                    IO.close((Closeable)inputStream);
                    return string;
                }
                catch (Exception e) {
                    String string = e.getMessage();
                    return string;
                }
                finally {
                    IO.close(inputStream);
                }
            }
            try {
                return IO.slurp((URL)new URL(this.getWadlUrl()));
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }

        @ManagedAttribute
        @Description(value="The type of the REST service")
        public String getType() {
            return this.type;
        }

        @ManagedAttribute
        @Description(value="The REST service address")
        public String getAddress() {
            return this.address;
        }

        @ManagedAttribute
        @Description(value="The REST service class name")
        public String getClassname() {
            return this.classname;
        }

        @ManagedAttribute
        @Description(value="All available methods")
        public TabularData getOperations() {
            return this.operations;
        }
    }

    private static class OpenEJBProviderFactory
    implements ServiceInfos.Factory {
        private static final ServiceInfos.Factory INSTANCE = new OpenEJBProviderFactory();

        private OpenEJBProviderFactory() {
        }

        public Object newInstance(Class<?> clazz) throws Exception {
            boolean found = false;
            Object instance = null;
            List constructors = Stream.of(clazz.getConstructors()).sorted((a, b) -> Integer.compare(b.getParameterCount(), a.getParameterCount())).collect(Collectors.toList());
            for (Constructor c : constructors) {
                int contextAnnotations = 0;
                Annotation[][] annotationArray = c.getParameterAnnotations();
                int n = annotationArray.length;
                block1: for (int i = 0; i < n; ++i) {
                    Annotation[] annotations;
                    for (Annotation a2 : annotations = annotationArray[i]) {
                        if (!Context.class.equals(a2.annotationType())) continue;
                        ++contextAnnotations;
                        continue block1;
                    }
                }
                if (contextAnnotations != c.getParameterTypes().length) continue;
                if (found) {
                    LOGGER.warning("Found multiple matching constructor for " + clazz.getName());
                    return instance;
                }
                Object[] params = new Object[c.getParameterTypes().length];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = ThreadLocalContextManager.findThreadLocal(c.getParameterTypes()[i]);
                }
                instance = c.newInstance(params);
                found = true;
            }
            if (instance != null) {
                return instance;
            }
            return clazz.newInstance();
        }
    }
}

