/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.spi;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.Extensible;

public abstract class AbstractAnnotationScanner
implements AnnotationScanner {
    private static final String EMPTY = "";
    protected String currentAppPath = "";
    private String contextRoot = "";

    @Override
    public void setContextRoot(String path) {
        this.contextRoot = path;
    }

    protected String makePath(String operationPath) {
        return AbstractAnnotationScanner.createPathFromSegments(this.contextRoot, this.currentAppPath, operationPath);
    }

    protected static String createPathFromSegments(String ... segments) {
        StringBuilder builder = new StringBuilder();
        for (String segment : segments) {
            if (segment.startsWith("/")) {
                segment = segment.substring(1);
            }
            if (segment.endsWith("/")) {
                segment = segment.substring(0, segment.length() - 1);
            }
            if (segment.isEmpty()) continue;
            builder.append("/");
            builder.append(segment);
        }
        String rval = builder.toString();
        if (rval.isEmpty()) {
            return "/";
        }
        return rval;
    }

    protected static boolean processProfiles(OpenApiConfig config, Extensible<?> extensible) {
        HashSet<String> profiles = new HashSet<String>();
        HashMap extensions = extensible.getExtensions();
        if (extensions != null && !extensions.isEmpty()) {
            extensions = new HashMap(extensions);
            for (String name : extensions.keySet()) {
                if (!name.startsWith("x-smallrye-profile-")) continue;
                String profile = name.substring("x-smallrye-profile-".length());
                profiles.add(profile);
                extensible.removeExtension(name);
            }
        }
        return AbstractAnnotationScanner.profileIncluded(config, profiles);
    }

    private static boolean profileIncluded(OpenApiConfig config, Set<String> profiles) {
        if (!config.getScanExcludeProfiles().isEmpty()) {
            return config.getScanExcludeProfiles().stream().noneMatch(profiles::contains);
        }
        if (config.getScanProfiles().isEmpty()) {
            return true;
        }
        return config.getScanProfiles().stream().anyMatch(profiles::contains);
    }
}

