/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.metrics;

import io.smallrye.metrics.MetricsRequestHandler;
import jakarta.inject.Inject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.stream.Stream;

@WebServlet(name="metrics-servlet", urlPatterns={"/metrics/*"})
public class MicroProfileMetricsEndpoint
extends HttpServlet {
    @Inject
    private MetricsRequestHandler metricsHandler;

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestPath = request.getContextPath().length() > 1 ? request.getRequestURI().substring(request.getContextPath().length()) : request.getRequestURI();
        String method = request.getMethod();
        Stream acceptHeaders = Collections.list(request.getHeaders("Accept")).stream();
        this.metricsHandler.handleRequest(requestPath, method, acceptHeaders, (status, message, headers) -> {
            headers.forEach((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1));
            response.setStatus(status);
            response.getWriter().write(message);
        });
    }
}

