/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.oauth2.common.AbstractFormImplicitResponse;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.FormTokenResponse;
import org.apache.cxf.rs.security.oauth2.common.OAuthRedirectionState;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenResponseFilter;
import org.apache.cxf.rs.security.oauth2.services.RedirectionBasedGrantService;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public abstract class AbstractImplicitGrantService
extends RedirectionBasedGrantService {
    private boolean reportClientId;
    private List<AccessTokenResponseFilter> responseHandlers = new LinkedList<AccessTokenResponseFilter>();

    protected AbstractImplicitGrantService(String supportedResponseType, String supportedGrantType) {
        super(supportedResponseType, supportedGrantType);
    }

    protected AbstractImplicitGrantService(Set<String> supportedResponseTypes, String supportedGrantType) {
        super(supportedResponseTypes, supportedGrantType);
    }

    @Override
    protected Response createGrant(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preAuthorizedToken) {
        if (this.isFormResponse(state)) {
            return this.createHtmlResponse(this.prepareFormResponse(state, client, requestedScope, approvedScope, userSubject, preAuthorizedToken));
        }
        StringBuilder sb = this.prepareRedirectResponse(state, client, requestedScope, approvedScope, userSubject, preAuthorizedToken);
        return Response.seeOther((URI)URI.create(sb.toString())).build();
    }

    protected StringBuilder prepareRedirectResponse(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preAuthorizedToken) {
        ClientAccessToken clientToken = this.getClientAccessToken(state, client, requestedScope, approvedScope, userSubject, preAuthorizedToken);
        StringBuilder sb = this.getUriWithFragment(state.getRedirectUri());
        sb.append("access_token").append('=').append(clientToken.getTokenKey());
        sb.append('&');
        sb.append("token_type").append('=').append(clientToken.getTokenType());
        if (this.isWriteOptionalParameters()) {
            sb.append('&').append("expires_in").append('=').append(clientToken.getExpiresIn());
            if (!StringUtils.isEmpty(clientToken.getApprovedScope())) {
                sb.append('&').append("scope").append('=').append(HttpUtils.queryEncode(clientToken.getApprovedScope()));
            }
            for (Map.Entry<String, String> entry : clientToken.getParameters().entrySet()) {
                sb.append('&').append(entry.getKey()).append('=').append(HttpUtils.queryEncode(entry.getValue()));
            }
        }
        if (clientToken.getRefreshToken() != null) {
            this.processRefreshToken(sb, clientToken.getRefreshToken());
        }
        this.finalizeResponse(sb, state);
        return sb;
    }

    protected AbstractFormImplicitResponse prepareFormResponse(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preAuthorizedToken) {
        ClientAccessToken clientToken = this.getClientAccessToken(state, client, requestedScope, approvedScope, userSubject, preAuthorizedToken);
        FormTokenResponse bean = new FormTokenResponse();
        bean.setResponseType("token");
        bean.setRedirectUri(state.getRedirectUri());
        bean.setState(state.getState());
        bean.setAccessToken(clientToken.getTokenKey());
        bean.setAccessTokenType(clientToken.getTokenType());
        bean.setAccessTokenExpiresIn(clientToken.getExpiresIn());
        bean.getParameters().putAll(clientToken.getParameters());
        return bean;
    }

    protected ClientAccessToken getClientAccessToken(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preAuthorizedToken) {
        ServerAccessToken token;
        if (preAuthorizedToken == null) {
            AccessTokenRegistration reg = this.createTokenRegistration(state, client, requestedScope, approvedScope, userSubject);
            token = this.getDataProvider().createAccessToken(reg);
        } else {
            token = preAuthorizedToken;
            if (state.getNonce() != null) {
                JAXRSUtils.getCurrentMessage().getExchange().put("nonce", state.getNonce());
            }
        }
        ClientAccessToken clientToken = OAuthUtils.toClientAccessToken(token, this.isWriteOptionalParameters());
        this.processClientAccessToken(clientToken, token);
        return clientToken;
    }

    protected AccessTokenRegistration createTokenRegistration(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject) {
        AccessTokenRegistration reg = new AccessTokenRegistration();
        reg.setClient(client);
        reg.setGrantType(super.getSupportedGrantType());
        reg.setResponseType(state.getResponseType());
        reg.setSubject(userSubject);
        reg.setRequestedScope(requestedScope);
        reg.setApprovedScope(this.getApprovedScope(requestedScope, approvedScope));
        reg.setAudiences(Collections.singletonList(state.getAudience()));
        reg.setNonce(state.getNonce());
        reg.getExtraProperties().putAll(state.getExtraProperties());
        return reg;
    }

    protected void finalizeResponse(StringBuilder sb, OAuthRedirectionState state) {
        if (state.getState() != null) {
            sb.append('&');
            String stateParam = state.getState();
            sb.append("state").append('=').append(HttpUtils.urlEncode(stateParam));
        }
        if (this.reportClientId) {
            sb.append('&').append("client_id").append('=').append(state.getClientId());
        }
    }

    protected void processRefreshToken(StringBuilder sb, String refreshToken) {
        LOG.warning("Implicit grant tokens MUST not have refresh tokens, refresh token will not be reported");
    }

    protected void processClientAccessToken(ClientAccessToken clientToken, ServerAccessToken serverToken) {
        for (AccessTokenResponseFilter filter : this.responseHandlers) {
            filter.process(clientToken, serverToken);
        }
    }

    @Override
    protected Response createErrorResponse(String state, String redirectUri, String error) {
        StringBuilder sb = this.getUriWithFragment(redirectUri);
        sb.append("error").append('=').append(error);
        if (state != null) {
            sb.append('&');
            sb.append("state").append('=').append(state);
        }
        return Response.seeOther((URI)URI.create(sb.toString())).build();
    }

    protected StringBuilder getUriWithFragment(String redirectUri) {
        StringBuilder sb = new StringBuilder();
        sb.append(redirectUri);
        sb.append('#');
        return sb;
    }

    public void setReportClientId(boolean reportClientId) {
        this.reportClientId = reportClientId;
    }

    public void setResponseFilters(List<AccessTokenResponseFilter> handlers) {
        this.responseHandlers = handlers;
    }

    public void setResponseFilter(AccessTokenResponseFilter responseHandler) {
        this.responseHandlers.add(responseHandler);
    }

    @Override
    protected boolean canRedirectUriBeEmpty(Client c) {
        return false;
    }

    @Override
    protected boolean canSupportPublicClient(Client c) {
        return true;
    }
}

