/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.jsrjsonb;

import jakarta.json.JsonException;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;

@Produces(value={"application/json", "text/json", "application/*+json"})
@Consumes(value={"application/json", "text/json", "application/*+json"})
@Provider
public class JsrJsonbProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private final Jsonb jsonb;

    public JsrJsonbProvider() {
        this(JsonbBuilder.create());
    }

    public JsrJsonbProvider(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isSupportedMediaType(mediaType);
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.jsonb.toJson(t, type, entityStream);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isSupportedMediaType(mediaType);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            if (genericType == null) {
                return this.jsonb.fromJson(entityStream, type);
            }
            return this.jsonb.fromJson(entityStream, genericType);
        }
        catch (JsonException ex) {
            throw ExceptionUtils.toBadRequestException(ex, null);
        }
    }

    protected boolean isSupportedMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return "json".equalsIgnoreCase(subtype) || subtype.endsWith("+json");
        }
        return false;
    }
}

