/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import jakarta.decorator.Decorator;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.openejb.BeanContext;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.BeansInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.cdi.OpenEJBBeanInfoService;
import org.apache.openejb.cdi.OpenEJBLifecycle;
import org.apache.openejb.cdi.StartupObject;
import org.apache.openejb.cdi.transactional.MandatoryInterceptor;
import org.apache.openejb.cdi.transactional.NeverInterceptor;
import org.apache.openejb.cdi.transactional.NotSupportedInterceptor;
import org.apache.openejb.cdi.transactional.RequiredInterceptor;
import org.apache.openejb.cdi.transactional.RequiredNewInterceptor;
import org.apache.openejb.cdi.transactional.SupportsInterceptor;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.classloader.ClassLoaderComparator;
import org.apache.openejb.util.classloader.DefaultClassLoaderComparator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.BdaScannerService;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.xml.DefaultBeanArchiveInformation;

public class CdiScanner
implements BdaScannerService {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_CDI, OpenEJBLifecycle.class);
    public static final String OPENEJB_CDI_FILTER_CLASSLOADER = "openejb.cdi.filter.classloader";
    private static final Class<?>[] TRANSACTIONAL_INTERCEPTORS = new Class[]{MandatoryInterceptor.class, NeverInterceptor.class, NotSupportedInterceptor.class, RequiredInterceptor.class, RequiredNewInterceptor.class, SupportsInterceptor.class};
    private final Set<Class<?>> startupClasses = new HashSet();
    private final Set<URL> beansXml = new HashSet<URL>();
    private final boolean logDebug;
    private WebBeansContext webBeansContext;
    private ClassLoader containerLoader;
    private final DefaultBeanArchiveInformation tomeeBeanArchiveInformation;
    private Map<BeanArchiveService.BeanArchiveInformation, Set<Class<?>>> beanClassesPerBda = new HashMap();

    public CdiScanner() {
        this.logDebug = "true".equals(SystemInstance.get().getProperty("openejb.cdi.noclassdeffound.log", "false"));
        this.tomeeBeanArchiveInformation = new DefaultBeanArchiveInformation("tomee");
        this.tomeeBeanArchiveInformation.setBeanDiscoveryMode(BeanArchiveService.BeanDiscoveryMode.ALL);
    }

    public void setContext(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    /*
     * Could not resolve type clashes
     */
    public void init(Object object) {
        if (!StartupObject.class.isInstance(object)) {
            return;
        }
        this.containerLoader = ParentClassLoaderFinder.Helper.get();
        StartupObject startupObject = (StartupObject)StartupObject.class.cast(object);
        AppInfo appInfo = startupObject.getAppInfo();
        ClassLoader classLoader = startupObject.getClassLoader();
        ClassLoaderComparator comparator = classLoader instanceof ClassLoaderComparator ? (ClassLoaderComparator)((Object)classLoader) : new DefaultClassLoaderComparator(classLoader);
        WebBeansContext webBeansContext = startupObject.getWebBeansContext();
        InterceptorsManager interceptorsManager = webBeansContext.getInterceptorsManager();
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            HashSet classes = new HashSet();
            BeansInfo beans = ejbJar.beans;
            if (beans == null || "false".equalsIgnoreCase(ejbJar.properties.getProperty("openejb.cdi.activated")) || (!startupObject.isFromWebApp() ? ejbJar.webapp && !appInfo.webAppAlone : !ejbJar.moduleId.equals(startupObject.getWebContext().getId()))) continue;
            if (appInfo.webAppAlone || !ejbJar.webapp) {
                classes.addAll(Arrays.asList(TRANSACTIONAL_INTERCEPTORS));
                for (Class<?> interceptor : TRANSACTIONAL_INTERCEPTORS) {
                    interceptorsManager.addEnabledInterceptorClass(interceptor);
                }
            }
            ClassLoader scl = ClassLoader.getSystemClassLoader();
            boolean filterByClassLoader = "true".equals(ejbJar.properties.getProperty(OPENEJB_CDI_FILTER_CLASSLOADER, SystemInstance.get().getProperty(OPENEJB_CDI_FILTER_CLASSLOADER, "true")));
            BeanArchiveService beanArchiveService = webBeansContext.getBeanArchiveService();
            boolean openejb = OpenEJBBeanInfoService.class.isInstance(beanArchiveService);
            HashMap<BeansInfo.BDAInfo, BeanArchiveService.BeanArchiveInformation> infoByBda = new HashMap<BeansInfo.BDAInfo, BeanArchiveService.BeanArchiveInformation>();
            for (BeansInfo.BDAInfo bda : beans.bdas) {
                if (bda.uri != null) {
                    try {
                        this.beansXml.add(bda.uri.toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                infoByBda.put(bda, this.handleBda(startupObject, classLoader, comparator, ejbJar, scl, filterByClassLoader, beanArchiveService, openejb, bda));
            }
            for (BeansInfo.BDAInfo bda : beans.noDescriptorBdas) {
                this.handleBda(startupObject, classLoader, comparator, ejbJar, scl, filterByClassLoader, beanArchiveService, openejb, bda);
            }
            if (startupObject.getBeanContexts() != null) {
                block6: for (BeanContext bc : startupObject.getBeanContexts()) {
                    String name = bc.getBeanClass().getName();
                    if (BeanContext.Comp.class.getName().equals(name)) continue;
                    boolean cdi = false;
                    for (BeansInfo.BDAInfo bda : beans.bdas) {
                        BeanArchiveService.BeanArchiveInformation info = (BeanArchiveService.BeanArchiveInformation)infoByBda.get(bda);
                        if (info.getBeanDiscoveryMode() == BeanArchiveService.BeanDiscoveryMode.NONE || !bda.managedClasses.contains(name)) continue;
                        classes.add(this.load(name, classLoader));
                        cdi = true;
                        break;
                    }
                    if (cdi) continue;
                    for (BeansInfo.BDAInfo bda : beans.noDescriptorBdas) {
                        if (!bda.managedClasses.contains(name)) continue;
                        classes.add(this.load(name, classLoader));
                        continue block6;
                    }
                }
            }
            if ("true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.cdi.debug", "false"))) {
                Logger logger = Logger.getInstance(LogCategory.OPENEJB, CdiScanner.class.getName());
                logger.info("CDI beans for " + startupObject.getAppInfo().appId + (String)(startupObject.getWebContext() != null ? " webcontext = " + startupObject.getWebContext().getContextRoot() : ""));
                ArrayList<String> names = new ArrayList<String>(classes.size());
                for (Class c : classes) {
                    names.add(c.getName());
                }
                Collections.sort(names);
                for (String c : names) {
                    logger.info("    " + c);
                }
            }
            if (classes.isEmpty()) continue;
            this.addClasses((BeanArchiveService.BeanArchiveInformation)this.tomeeBeanArchiveInformation, classes);
        }
    }

    private void addClasses(BeanArchiveService.BeanArchiveInformation bdaInfo, Collection<String> list, ClassLoader loader) {
        Set classes = this.beanClassesPerBda.computeIfAbsent(bdaInfo, k -> new HashSet());
        for (String s : list) {
            Class load = this.load(s, loader);
            if (load == null) continue;
            classes.add(load);
        }
    }

    private void addClasses(BeanArchiveService.BeanArchiveInformation bdaInfo, Collection<Class<?>> list) {
        Set classes = this.beanClassesPerBda.computeIfAbsent(bdaInfo, k -> new HashSet());
        classes.addAll(list);
    }

    public Map<BeanArchiveService.BeanArchiveInformation, Set<Class<?>>> getBeanClassesPerBda() {
        return this.beanClassesPerBda;
    }

    private BeanArchiveService.BeanArchiveInformation handleBda(StartupObject startupObject, ClassLoader classLoader, ClassLoaderComparator comparator, EjbJarInfo ejbJarInfo, ClassLoader scl, boolean filterByClassLoader, BeanArchiveService beanArchiveService, boolean openejb, BeansInfo.BDAInfo bda) {
        boolean isNotEarWebApp;
        BeanArchiveService.BeanArchiveInformation information;
        if (openejb) {
            OpenEJBBeanInfoService beanInfoService = (OpenEJBBeanInfoService)OpenEJBBeanInfoService.class.cast(beanArchiveService);
            information = beanInfoService.createBeanArchiveInformation(bda, ejbJarInfo.beans, classLoader);
            try {
                beanInfoService.getBeanArchiveInfo().put(bda.uri == null ? null : bda.uri.toURL(), information);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            information = beanArchiveService.getBeanArchiveInformation(bda.uri.toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        this.addClasses(information, information.getAlternativeClasses(), classLoader);
        this.addClasses(information, information.getDecorators(), classLoader);
        this.addClasses(information, information.getInterceptors(), classLoader);
        this.addClasses(information, information.getAlternativeStereotypes(), classLoader);
        boolean scanModeAnnotated = BeanArchiveService.BeanDiscoveryMode.ANNOTATED.equals((Object)information.getBeanDiscoveryMode());
        boolean noScan = BeanArchiveService.BeanDiscoveryMode.NONE.equals((Object)information.getBeanDiscoveryMode());
        boolean bl = isNotEarWebApp = startupObject.getWebContext() == null;
        if (!noScan) {
            if (scanModeAnnotated) {
                try {
                    Logger.getInstance(LogCategory.OPENEJB, CdiScanner.class.getName()).info("Using annotated mode for " + bda.uri.toASCIIString() + " looking all classes to find CDI beans, maybe think to add a beans.xml if not there or add the jar to exclusions.list");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            HashSet classes = new HashSet(bda.managedClasses.size());
            for (String name : bda.managedClasses) {
                Class clazz;
                if (information.isClassExcluded(name) || (clazz = this.load(name, classLoader)) == null) continue;
                if (scanModeAnnotated) {
                    if (!this.isBean(clazz)) continue;
                    classes.add(clazz);
                    if (!ejbJarInfo.beans.startupClasses.contains(name)) continue;
                    logger.debug("Adding class " + clazz.getName() + " from " + CdiScanner.getLocation(clazz) + ", in module " + ejbJarInfo.moduleId + " to startup list. Scan mode=" + information.getBeanDiscoveryMode().toString() + ". EAR webapp=" + !isNotEarWebApp);
                    this.startupClasses.add(clazz);
                    continue;
                }
                ClassLoader loader = clazz.getClassLoader();
                if (filterByClassLoader && !comparator.isSame(loader) && (!loader.equals(scl) && loader != this.containerLoader || !isNotEarWebApp)) continue;
                classes.add(clazz);
                if (!ejbJarInfo.beans.startupClasses.contains(name)) continue;
                logger.debug("Adding class " + clazz.getName() + " from " + CdiScanner.getLocation(clazz) + ", in module " + ejbJarInfo.moduleId + " to startup list. Scan mode=" + information.getBeanDiscoveryMode().toString() + ". EAR webapp=" + !isNotEarWebApp);
                this.startupClasses.add(clazz);
            }
            this.addClasses(information, classes);
        }
        return information;
    }

    private boolean isBean(Class clazz) {
        try {
            for (Annotation a : clazz.getAnnotations()) {
                Class<? extends Annotation> annotationType = a.annotationType();
                BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
                if (!beanManager.isScope(annotationType) && !beanManager.isStereotype(annotationType) && !beanManager.isInterceptorBinding(annotationType) && Decorator.class != a.annotationType()) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return false;
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return null;
    }

    private Class load(String className, ClassLoader classLoader) {
        try {
            Class<?> loadClass = classLoader.loadClass(className);
            this.tryToMakeItFail(loadClass);
            return loadClass;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            if (this.logDebug) {
                Logger.getInstance(LogCategory.OPENEJB_CDI, CdiScanner.class).warning(className + " -> " + e);
            }
            return null;
        }
    }

    private void tryToMakeItFail(Class<?> loadClass) {
        loadClass.getDeclaredFields();
        loadClass.getDeclaredMethods();
    }

    public void scan() {
    }

    public Set<URL> getBeanXmls() {
        return this.beansXml;
    }

    public Set<Class<?>> getBeanClasses() {
        return Collections.EMPTY_SET;
    }

    public void release() {
        this.beanClassesPerBda.clear();
    }

    public Set<Class<?>> getStartupClasses() {
        return this.startupClasses;
    }

    public static String getLocation(Class<?> clazz) {
        if (clazz != null && clazz.getProtectionDomain() != null && clazz.getProtectionDomain().getCodeSource() != null && clazz.getProtectionDomain().getCodeSource().getLocation() != null) {
            return clazz.getProtectionDomain().getCodeSource().getLocation().toString();
        }
        return "<not available>";
    }
}

