/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import jakarta.ejb.ScheduleExpression;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.openejb.core.timer.TimerExpiredException;
import org.apache.openejb.quartz.impl.triggers.CronTriggerImpl;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class EJBCronTrigger
extends CronTriggerImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getInstance(LogCategory.TIMER, EJBCronTrigger.class);
    private static final Pattern INCREMENTS = Pattern.compile("(\\d+|\\*)/(\\d+)*");
    private static final Pattern LIST = Pattern.compile("(([A-Za-z0-9]+)(-[A-Za-z0-9]+)?)?((1ST|2ND|3RD|4TH|5TH|LAST)([A-za-z]+))?(-([0-7]+))?(LAST)?(?:,(([A-Za-z0-9]+)(-[A-Za-z0-9]+)?)?((1ST|2ND|3RD|4TH|5TH|LAST)([A-za-z]+))?(-([0-7]+))?(LAST)?)*");
    private static final Pattern WEEKDAY = Pattern.compile("(1ST|2ND|3RD|4TH|5TH|LAST)(SUN|MON|TUE|WED|THU|FRI|SAT)");
    private static final Pattern DAYS_TO_LAST = Pattern.compile("-([0-7]+)");
    private static final Pattern VALID_YEAR = Pattern.compile("([0-9][0-9][0-9][0-9])|\\*");
    private static final Pattern VALID_MONTH = Pattern.compile("(([0]?[1-9])|(1[0-2]))|\\*");
    private static final Pattern VALID_DAYS_OF_WEEK = Pattern.compile("[0-7]|\\*");
    private static final Pattern VALID_DAYS_OF_MONTH = Pattern.compile("((1ST|2ND|3RD|4TH|5TH|LAST)(SUN|MON|TUE|WED|THU|FRI|SAT))|(([1-9])|(0[1-9])|([12])([0-9]?)|(3[01]?))|(LAST)|-([0-7])|[*]");
    private static final Pattern VALID_HOUR = Pattern.compile("(([0-1]?[0-9])|([2][0-3]))|\\*");
    private static final Pattern VALID_MINUTE = Pattern.compile("([0-5]?[0-9])|\\*");
    private static final Pattern VALID_SECOND = Pattern.compile("([0-5]?[0-9])|\\*");
    private static final Pattern RANGE = Pattern.compile("(-?[A-Za-z0-9]+)-(-?[A-Za-z0-9]+)");
    public static final String DELIMITER = ";";
    private static final String LAST_IDENTIFIER = "LAST";
    private static final Map<String, Integer> WEEKDAYS_MAP = new HashMap<String, Integer>();
    private static final Map<String, Integer> MONTHS_MAP = new HashMap<String, Integer>();
    private static final int[] ORDERED_CALENDAR_FIELDS;
    private static final Map<Integer, Integer> CALENDAR_FIELD_TYPE_ORDERED_INDEX_MAP;
    private final FieldExpression[] expressions = new FieldExpression[7];
    private final TimeZone timezone;
    private final String rawValue;
    private final boolean isExpired;

    public EJBCronTrigger(ScheduleExpression expr) throws ParseException {
        LinkedHashMap<Integer, String> fieldValues = new LinkedHashMap<Integer, String>();
        fieldValues.put(1, expr.getYear());
        fieldValues.put(2, expr.getMonth());
        fieldValues.put(5, expr.getDayOfMonth());
        fieldValues.put(7, expr.getDayOfWeek());
        fieldValues.put(11, expr.getHour());
        fieldValues.put(12, expr.getMinute());
        fieldValues.put(13, expr.getSecond());
        this.timezone = expr.getTimezone() == null ? TimeZone.getDefault() : TimeZone.getTimeZone(expr.getTimezone());
        this.setStartTime(expr.getStart() == null ? new Date() : expr.getStart());
        if (expr.getEnd() == null || !this.isBefore(expr.getEnd(), this.getStartTime())) {
            this.setEndTime(expr.getEnd());
            this.isExpired = false;
        } else {
            this.isExpired = true;
        }
        HashMap<Integer, ParseException> errors = new HashMap<Integer, ParseException>();
        int index = 0;
        for (Map.Entry entry : fieldValues.entrySet()) {
            int field = (Integer)entry.getKey();
            String value = (String)entry.getValue();
            try {
                this.expressions[index++] = this.parseExpression(field, value);
            }
            catch (ParseException e) {
                errors.put(field, e);
            }
        }
        if (!errors.isEmpty()) {
            throw new ParseException(errors);
        }
        this.rawValue = expr.getYear() + DELIMITER + expr.getMonth() + DELIMITER + expr.getDayOfMonth() + DELIMITER + expr.getDayOfWeek() + DELIMITER + expr.getHour() + DELIMITER + expr.getMinute() + DELIMITER + expr.getSecond();
    }

    private boolean isBefore(Date end, Date start) {
        return start != null && end != null && start.after(end);
    }

    protected FieldExpression parseExpression(int field, String expr) throws ParseException {
        if (expr == null || expr.isEmpty()) {
            throw new ParseException(field, expr, "expression can't be null");
        }
        if ((expr = expr.replaceAll("\\s+", "").toUpperCase(Locale.ENGLISH)).length() > 1 && expr.indexOf(44) > 0) {
            String[] expressions;
            for (String subExpression : expressions = expr.split(",")) {
                this.validateExpression(field, subExpression);
            }
        } else {
            this.validateExpression(field, expr);
        }
        if (expr.equals("*")) {
            return new AsteriskExpression(field);
        }
        Matcher m = RANGE.matcher(expr);
        if (m.matches()) {
            return new RangeExpression(m, field);
        }
        switch (field) {
            case 11: 
            case 12: 
            case 13: {
                m = INCREMENTS.matcher(expr);
                if (!m.matches()) break;
                return new IncrementExpression(m, field);
            }
            case 5: {
                if (expr.equals(LAST_IDENTIFIER)) {
                    return new DaysFromLastDayExpression();
                }
                m = DAYS_TO_LAST.matcher(expr);
                if (m.matches()) {
                    return new DaysFromLastDayExpression(m);
                }
                m = WEEKDAY.matcher(expr);
                if (!m.matches()) break;
                return new WeekdayExpression(m);
            }
        }
        m = LIST.matcher(expr);
        if (m.matches()) {
            return new ListExpression(m, field);
        }
        throw new ParseException(field, expr, "Unparseable time expression");
    }

    private void validateExpression(int field, String expression) throws ParseException {
        Matcher rangeMatcher = RANGE.matcher(expression);
        Matcher incrementsMatcher = INCREMENTS.matcher(expression);
        if (expression.length() > 2 && rangeMatcher.matches()) {
            this.validateSingleToken(field, rangeMatcher.group(1));
            this.validateSingleToken(field, rangeMatcher.group(2));
        } else if (expression.length() > 2 && incrementsMatcher.matches()) {
            this.validateSingleToken(field, incrementsMatcher.group(1));
            this.validateSingleToken(field, incrementsMatcher.group(2));
        } else {
            this.validateSingleToken(field, expression);
        }
    }

    private void validateSingleToken(int field, String token) throws ParseException {
        if (token == null || token.isEmpty()) {
            throw new ParseException(field, token, "expression can't be null");
        }
        switch (field) {
            case 1: {
                Matcher m = VALID_YEAR.matcher(token);
                if (m.matches()) break;
                throw new ParseException(field, token, "Valid YEAR is four digit");
            }
            case 2: {
                Matcher m = VALID_MONTH.matcher(token);
                if (m.matches() || MONTHS_MAP.containsKey(token)) break;
                throw new ParseException(field, token, "Valid MONTH is 1-12 or {'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', Dec'}");
            }
            case 5: {
                Matcher m = VALID_DAYS_OF_MONTH.matcher(token);
                if (m.matches()) break;
                throw new ParseException(field, token, "Valid DAYS_OF_MONTH is 0-7 or {'Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'} ");
            }
            case 7: {
                Matcher m = VALID_DAYS_OF_WEEK.matcher(token);
                if (m.matches() || WEEKDAYS_MAP.containsKey(token)) break;
                throw new ParseException(field, token, "Valid DAYS_OF_WEEK is 1-31  -(1-7) or {'1st', '2nd', '3rd', '4th',  '5th', 'Last'} + {'Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'} ");
            }
            case 11: {
                Matcher m = VALID_HOUR.matcher(token);
                if (m.matches()) break;
                throw new ParseException(field, token, "Valid HOUR_OF_DAY value is 0-23");
            }
            case 12: {
                Matcher m = VALID_MINUTE.matcher(token);
                if (m.matches()) break;
                throw new ParseException(field, token, "Valid MINUTE value is 0-59");
            }
            case 13: {
                Matcher m = VALID_SECOND.matcher(token);
                if (m.matches()) break;
                throw new ParseException(field, token, "Valid SECOND value is 0-59");
            }
        }
    }

    public Date getFinalFireTime() {
        GregorianCalendar calendar = new GregorianCalendar(this.timezone);
        calendar.setFirstDayOfWeek(1);
        if (this.getEndTime() == null) {
            if (this.expressions[0] instanceof AsteriskExpression) {
                return null;
            }
            this.resetFields(calendar, 0, true);
            calendar.set(14, 0);
        } else {
            calendar.setTime(this.getEndTime());
        }
        GregorianCalendar stopCalendar = new GregorianCalendar(this.timezone);
        if (this.getStartTime() != null) {
            stopCalendar.setTime(this.getStartTime());
        } else {
            stopCalendar.setTimeInMillis(0L);
        }
        int currentFieldIndex = 0;
        while (currentFieldIndex <= 6 && calendar.after(stopCalendar)) {
            FieldExpression expr = this.expressions[currentFieldIndex];
            Integer value = expr.getPreviousValue(calendar);
            if (value != null) {
                int oldValue = calendar.get(expr.field);
                if (oldValue != value) {
                    calendar.set(expr.field, value);
                    this.resetFields(calendar, expr.field, true);
                    if (expr.field == 7) {
                        --currentFieldIndex;
                        continue;
                    }
                    ++currentFieldIndex;
                    continue;
                }
                ++currentFieldIndex;
                continue;
            }
            if (currentFieldIndex >= 1) {
                int maxAffectedFieldType = this.updateCalendar(calendar, this.expressions[currentFieldIndex - 1].field, -1);
                currentFieldIndex = CALENDAR_FIELD_TYPE_ORDERED_INDEX_MAP.get(maxAffectedFieldType);
                this.resetFields(calendar, maxAffectedFieldType, true);
                continue;
            }
            return null;
        }
        return calendar.after(stopCalendar) ? calendar.getTime() : null;
    }

    public Date computeFirstFireTime(org.apache.openejb.quartz.Calendar calendar) {
        if (this.isExpired) {
            throw new TimerExpiredException(String.format("Timer %s expired.", new Object[]{this}));
        }
        return super.computeFirstFireTime(calendar);
    }

    public Date getFireTimeAfter(Date afterTime) {
        log.debug("start to getFireTimeAfter:" + afterTime);
        GregorianCalendar calendar = new GregorianCalendar(this.timezone);
        calendar.setFirstDayOfWeek(1);
        if (this.getStartTime() != null && this.getStartTime().after(afterTime)) {
            calendar.setTime(this.getStartTime());
        } else {
            calendar.setTime(afterTime);
            ((Calendar)calendar).add(13, 1);
        }
        GregorianCalendar stopCalendar = new GregorianCalendar(this.timezone);
        if (this.getEndTime() != null) {
            stopCalendar.setTime(this.getEndTime());
        } else {
            int stopYear = calendar.get(1) + 100;
            stopCalendar.set(1, stopYear);
        }
        int currentFieldIndex = 0;
        while (currentFieldIndex <= 6 && calendar.before(stopCalendar)) {
            FieldExpression expr = this.expressions[currentFieldIndex];
            Integer value = expr.getNextValue(calendar);
            if (currentFieldIndex == 2 && !(this.expressions[3] instanceof AsteriskExpression)) {
                Calendar clonedCalendarDayOfWeek = (Calendar)((Calendar)calendar).clone();
                Integer nextDayOfWeek = this.expressions[3].getNextValue(clonedCalendarDayOfWeek);
                while (nextDayOfWeek == null) {
                    clonedCalendarDayOfWeek.add(5, 1);
                    nextDayOfWeek = this.expressions[3].getNextValue(clonedCalendarDayOfWeek);
                }
                if (nextDayOfWeek != null) {
                    clonedCalendarDayOfWeek.set(this.expressions[3].field, nextDayOfWeek);
                    int newDayOfMonth = clonedCalendarDayOfWeek.get(this.expressions[2].field);
                    if (value == null) {
                        value = newDayOfMonth;
                    } else if (clonedCalendarDayOfWeek.get(this.expressions[1].field) == calendar.get(this.expressions[1].field)) {
                        value = Math.min(value, newDayOfMonth);
                    }
                    if (this.expressions[1].getNextValue(clonedCalendarDayOfWeek) == null) {
                        return null;
                    }
                    if (value.intValue() != calendar.get(this.expressions[2].field) && clonedCalendarDayOfWeek.get(this.expressions[1].field) > calendar.get(this.expressions[1].field)) {
                        calendar.set(2, clonedCalendarDayOfWeek.get(2));
                    }
                }
            }
            if (currentFieldIndex >= 1 && value == null) {
                if (currentFieldIndex == 3 && !(this.expressions[2] instanceof AsteriskExpression)) {
                    ++currentFieldIndex;
                    continue;
                }
                int parentFieldIndex = currentFieldIndex == 4 ? currentFieldIndex - 2 : currentFieldIndex - 1;
                int maxAffectedFieldType = this.updateCalendar(calendar, this.expressions[parentFieldIndex].field, 1);
                currentFieldIndex = CALENDAR_FIELD_TYPE_ORDERED_INDEX_MAP.get(maxAffectedFieldType);
                this.resetFields(calendar, maxAffectedFieldType, false);
                continue;
            }
            if (value != null) {
                int oldValue = calendar.get(expr.field);
                if (oldValue != value) {
                    if (currentFieldIndex == 3 && !(this.expressions[2] instanceof AsteriskExpression)) {
                        ++currentFieldIndex;
                        continue;
                    }
                    calendar.set(expr.field, value);
                    this.resetFields(calendar, expr.field, false);
                    ++currentFieldIndex;
                    continue;
                }
                ++currentFieldIndex;
                continue;
            }
            log.debug("end of getFireTimeAfter, result is:" + null);
            return null;
        }
        log.debug("end of getFireTimeAfter, result is:" + (calendar.before(stopCalendar) ? calendar.getTime() : null));
        return calendar.before(stopCalendar) ? calendar.getTime() : null;
    }

    private int updateCalendar(Calendar calendar, int field, int amount) {
        GregorianCalendar old = new GregorianCalendar(this.timezone);
        old.setTime(calendar.getTime());
        calendar.add(field, amount);
        for (int fieldType : ORDERED_CALENDAR_FIELDS) {
            if (calendar.get(fieldType) == old.get(fieldType)) continue;
            return fieldType;
        }
        return -1;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    private void resetFields(Calendar calendar, int currentField, boolean max) {
        int calendarField;
        for (int index = ORDERED_CALENDAR_FIELDS.length - 1; index >= 0 && (calendarField = ORDERED_CALENDAR_FIELDS[index]) > currentField; --index) {
            int value = max ? calendar.getActualMaximum(calendarField) : calendar.getActualMinimum(calendarField);
            calendar.set(calendarField, value);
        }
    }

    public boolean hasAdditionalProperties() {
        return true;
    }

    static {
        int i = 0;
        for (String month : new DateFormatSymbols(Locale.US).getShortMonths()) {
            MONTHS_MAP.put(month.toUpperCase(Locale.US), i++);
        }
        i = 0;
        for (String weekday : new DateFormatSymbols(Locale.US).getShortWeekdays()) {
            WEEKDAYS_MAP.put(weekday.toUpperCase(Locale.US), i++);
        }
        ORDERED_CALENDAR_FIELDS = new int[]{1, 2, 5, 11, 12, 13};
        CALENDAR_FIELD_TYPE_ORDERED_INDEX_MAP = new LinkedHashMap<Integer, Integer>();
        CALENDAR_FIELD_TYPE_ORDERED_INDEX_MAP.put(1, 0);
        CALENDAR_FIELD_TYPE_ORDERED_INDEX_MAP.put(2, 1);
        CALENDAR_FIELD_TYPE_ORDERED_INDEX_MAP.put(5, 2);
        CALENDAR_FIELD_TYPE_ORDERED_INDEX_MAP.put(7, 3);
        CALENDAR_FIELD_TYPE_ORDERED_INDEX_MAP.put(11, 4);
        CALENDAR_FIELD_TYPE_ORDERED_INDEX_MAP.put(12, 5);
        CALENDAR_FIELD_TYPE_ORDERED_INDEX_MAP.put(13, 6);
    }

    private static class AsteriskExpression
    extends FieldExpression {
        public AsteriskExpression(int field) {
            super(field);
        }

        @Override
        public Integer getNextValue(Calendar calendar) {
            return calendar.get(this.field);
        }

        @Override
        public Integer getPreviousValue(Calendar calendar) {
            return calendar.get(this.field);
        }
    }

    private static class DaysFromLastDayExpression
    extends FieldExpression {
        private final int days;

        public DaysFromLastDayExpression(Matcher m) {
            super(5);
            this.days = new Integer(m.group(1));
        }

        public DaysFromLastDayExpression() {
            super(5);
            this.days = 0;
        }

        @Override
        public Integer getNextValue(Calendar calendar) {
            int maxValue;
            int value;
            int currValue = calendar.get(this.field);
            Integer result = currValue <= (value = (maxValue = calendar.getActualMaximum(this.field)) - this.days) ? Integer.valueOf(value) : null;
            return this.isValidResult(calendar, result) ? result : null;
        }

        @Override
        public Integer getPreviousValue(Calendar calendar) {
            int maxValue = calendar.getActualMaximum(this.field);
            Integer result = maxValue - this.days;
            return this.isValidResult(calendar, result) ? result : null;
        }
    }

    private static class WeekdayExpression
    extends FieldExpression {
        private final Integer ordinal;
        private final int weekday;

        public WeekdayExpression(Matcher m) throws ParseException {
            super(5);
            Character firstChar = Character.valueOf(m.group(1).charAt(0));
            this.ordinal = Character.isDigit(firstChar.charValue()) ? Integer.valueOf(firstChar.toString()) : null;
            this.weekday = WeekdayExpression.convertValue(m.group(2), 7);
        }

        @Override
        public Integer getNextValue(Calendar calendar) {
            int currDay = calendar.get(5);
            Integer nthDay = this.getWeekdayInMonth(calendar);
            Integer result = nthDay != null && nthDay >= currDay ? nthDay : null;
            return this.isValidResult(calendar, result) ? result : null;
        }

        public Integer getWeekdayInMonth(Calendar calendar) {
            int currDay = calendar.get(5);
            int currWeekday = calendar.get(7);
            int maxDay = calendar.getActualMaximum(5);
            int firstWeekday = currDay % 7 - (currWeekday - this.weekday);
            firstWeekday = firstWeekday == 0 ? 7 : firstWeekday;
            int numWeekdays = firstWeekday >= 0 ? (maxDay - firstWeekday) / 7 + 1 : (maxDay - firstWeekday) / 7;
            int multiplier = this.ordinal != null ? this.ordinal : numWeekdays;
            int nthDay = firstWeekday >= 0 ? firstWeekday + (multiplier - 1) * 7 : firstWeekday + multiplier * 7;
            return nthDay <= maxDay ? Integer.valueOf(nthDay) : null;
        }

        @Override
        public Integer getPreviousValue(Calendar calendar) {
            int currDay = calendar.get(5);
            Integer nthDay = this.getWeekdayInMonth(calendar);
            Integer result = nthDay != null && nthDay <= currDay ? nthDay : null;
            return this.isValidResult(calendar, result) ? result : null;
        }
    }

    private static class IncrementExpression
    extends FieldExpression {
        private final int start;
        private final int interval;

        public IncrementExpression(Matcher m, int field) {
            super(field);
            int minValue = CALENDAR.getMinimum(field);
            this.start = m.group(1).equals("*") ? minValue : Integer.parseInt(m.group(1));
            this.interval = Integer.parseInt(m.group(2));
        }

        @Override
        public Integer getNextValue(Calendar calendar) {
            int currValue = calendar.get(this.field);
            if (currValue > this.start) {
                Integer nextValue = this.start + this.interval;
                while (this.isValidResult(calendar, nextValue)) {
                    if (nextValue >= currValue) {
                        return nextValue;
                    }
                    nextValue = nextValue + this.interval;
                }
            } else {
                return this.start;
            }
            return null;
        }

        @Override
        public Integer getPreviousValue(Calendar calendar) {
            int currValue = calendar.get(this.field);
            if (currValue < this.start) {
                Integer previousValue = this.start - this.interval;
                while (this.isValidResult(calendar, previousValue)) {
                    if (previousValue < currValue) {
                        return previousValue;
                    }
                    previousValue = previousValue - this.interval;
                }
            } else {
                return this.start;
            }
            return null;
        }
    }

    private static class ListExpression
    extends FieldExpression {
        private final Set<Integer> values = new TreeSet<Integer>();
        private final List<RangeExpression> weekDayRangeExpressions = new ArrayList<RangeExpression>();
        private final List<WeekdayExpression> weekDayExpressions = new ArrayList<WeekdayExpression>();
        private final List<DaysFromLastDayExpression> daysFromLastDayExpressions = new ArrayList<DaysFromLastDayExpression>();

        public ListExpression(Matcher m, int field) throws ParseException {
            super(field);
            this.initialize(m);
        }

        private void initialize(Matcher m) throws ParseException {
            for (String value : m.group().split("[,]")) {
                Matcher rangeMatcher = RANGE.matcher(value);
                Matcher weekDayMatcher = WEEKDAY.matcher(value);
                Matcher daysToLastMatcher = DAYS_TO_LAST.matcher(value);
                if (value.equals(EJBCronTrigger.LAST_IDENTIFIER)) {
                    this.daysFromLastDayExpressions.add(new DaysFromLastDayExpression());
                    continue;
                }
                if (daysToLastMatcher.matches()) {
                    this.daysFromLastDayExpressions.add(new DaysFromLastDayExpression(daysToLastMatcher));
                    continue;
                }
                if (weekDayMatcher.matches()) {
                    this.weekDayExpressions.add(new WeekdayExpression(weekDayMatcher));
                    continue;
                }
                if (rangeMatcher.matches()) {
                    RangeExpression rangeExpression = new RangeExpression(rangeMatcher, this.field);
                    if (rangeExpression.isDynamicRangeExpression()) {
                        this.weekDayRangeExpressions.add(new RangeExpression(rangeMatcher, this.field));
                        continue;
                    }
                    this.values.addAll(rangeExpression.getAllValuesInRange(null));
                    continue;
                }
                int individualValue = this.convertValue(value);
                if (this.field == 7 && individualValue == 8) {
                    individualValue = 1;
                }
                this.values.add(individualValue);
            }
        }

        private TreeSet<Integer> getNewValuesFromDynamicExpressions(Calendar calendar) {
            Integer value;
            TreeSet<Integer> newValues = new TreeSet<Integer>(this.values);
            for (RangeExpression weekDayRangeExpression : this.weekDayRangeExpressions) {
                newValues.addAll(weekDayRangeExpression.getAllValuesInRange(calendar));
            }
            for (WeekdayExpression weekdayExpression : this.weekDayExpressions) {
                value = weekdayExpression.getNextValue(calendar);
                if (value == null) continue;
                newValues.add(value);
            }
            for (DaysFromLastDayExpression daysFromLastDayExpression : this.daysFromLastDayExpressions) {
                value = daysFromLastDayExpression.getNextValue(calendar);
                if (value == null) continue;
                newValues.add(value);
            }
            return newValues;
        }

        @Override
        public Integer getNextValue(Calendar calendar) {
            int currValue;
            TreeSet<Integer> newValues = this.getNewValuesFromDynamicExpressions(calendar);
            Integer result = newValues.ceiling(currValue = calendar.get(this.field));
            return this.isValidResult(calendar, result) ? result : null;
        }

        @Override
        public Integer getPreviousValue(Calendar calendar) {
            int currValue;
            TreeSet<Integer> newValues = this.getNewValuesFromDynamicExpressions(calendar);
            Integer result = newValues.floor(currValue = calendar.get(this.field));
            return this.isValidResult(calendar, result) ? result : null;
        }
    }

    private static class RangeExpression
    extends FieldExpression {
        private int start;
        private int end;
        private int start2 = -1;
        private String startWeekDay;
        private String endWeekDay;
        private WeekdayExpression startWeekdayExpr;
        private WeekdayExpression endWeekdayExpr;
        private DaysFromLastDayExpression startDaysFromLastDayExpr;
        private DaysFromLastDayExpression endDaysFromLastDayExpr;
        private boolean isDynamicRangeExpression;

        public boolean isDynamicRangeExpression() {
            return this.isDynamicRangeExpression;
        }

        public RangeExpression(int field, int start, int end, int start2) {
            super(field);
            this.start = start;
            this.end = end;
            this.start2 = start2;
        }

        public RangeExpression(Matcher m, int field) throws ParseException {
            super(field);
            this.startWeekDay = m.group(1);
            this.endWeekDay = m.group(2);
            if (field == 5) {
                Matcher startWeekDayMatcher = WEEKDAY.matcher(m.group(1));
                Matcher endWeekDayMatcher = WEEKDAY.matcher(m.group(2));
                Matcher startDaysFromLastDayMatcher = DAYS_TO_LAST.matcher(m.group(1));
                Matcher endDaysFromLastDayMatcher = DAYS_TO_LAST.matcher(m.group(2));
                if (startWeekDayMatcher.matches()) {
                    this.startWeekdayExpr = new WeekdayExpression(startWeekDayMatcher);
                }
                if (endWeekDayMatcher.matches()) {
                    this.endWeekdayExpr = new WeekdayExpression(endWeekDayMatcher);
                }
                if (startDaysFromLastDayMatcher.matches()) {
                    this.startDaysFromLastDayExpr = new DaysFromLastDayExpression(startDaysFromLastDayMatcher);
                }
                if (endDaysFromLastDayMatcher.matches()) {
                    this.endDaysFromLastDayExpr = new DaysFromLastDayExpression(endDaysFromLastDayMatcher);
                }
                if (this.startWeekdayExpr != null || this.endWeekdayExpr != null || this.startDaysFromLastDayExpr != null || this.endDaysFromLastDayExpr != null || this.startWeekDay.equals(EJBCronTrigger.LAST_IDENTIFIER) || this.endWeekDay.equals(EJBCronTrigger.LAST_IDENTIFIER)) {
                    this.isDynamicRangeExpression = true;
                    return;
                }
            }
            this.initStartEndValues(null);
        }

        private void initStartEndValues(Calendar calendar) throws ParseException {
            int endValue;
            int beginValue;
            if (this.isDynamicRangeExpression) {
                Integer next;
                beginValue = this.startWeekDay.equals(EJBCronTrigger.LAST_IDENTIFIER) ? calendar.getActualMaximum(this.field) : (this.startWeekdayExpr != null ? this.startWeekdayExpr.getWeekdayInMonth(calendar) : (this.startDaysFromLastDayExpr != null ? ((next = this.startDaysFromLastDayExpr.getNextValue(calendar)) == null ? calendar.get(this.field) : next.intValue()) : this.convertValue(this.startWeekDay)));
                endValue = this.endWeekDay.equals(EJBCronTrigger.LAST_IDENTIFIER) ? calendar.getActualMaximum(this.field) : (this.endWeekdayExpr != null ? this.endWeekdayExpr.getWeekdayInMonth(calendar) : (this.endDaysFromLastDayExpr != null ? ((next = this.endDaysFromLastDayExpr.getNextValue(calendar)) == null ? calendar.get(this.field) : next.intValue()) : this.convertValue(this.endWeekDay)));
            } else {
                beginValue = this.convertValue(this.startWeekDay);
                endValue = this.convertValue(this.endWeekDay);
            }
            if (this.field == 7) {
                if (beginValue == 8 && endValue == 1 || endValue == 8 && beginValue == 1) {
                    beginValue = 1;
                    endValue = 7;
                } else {
                    if (beginValue == 8) {
                        beginValue = 1;
                    }
                    if (endValue == 8) {
                        endValue = 1;
                    }
                }
            }
            if (this.endWeekDay.equals(EJBCronTrigger.LAST_IDENTIFIER)) {
                this.start = -1;
                this.end = -1;
                this.start2 = beginValue;
            } else if (beginValue > endValue) {
                this.start = CALENDAR.getMinimum(this.field);
                this.end = endValue;
                this.start2 = beginValue;
            } else {
                this.start = beginValue;
                this.end = endValue;
            }
        }

        @Override
        public Integer getNextValue(Calendar calendar) {
            if (this.isDynamicRangeExpression) {
                Integer nextStartWeekday = this.startWeekdayExpr == null ? this.start : this.startWeekdayExpr.getWeekdayInMonth(calendar);
                Integer nextendWeekday = this.endWeekdayExpr == null ? this.end : this.endWeekdayExpr.getWeekdayInMonth(calendar);
                if (nextStartWeekday == null || nextendWeekday == null) {
                    return null;
                }
                try {
                    this.initStartEndValues(calendar);
                }
                catch (ParseException e) {
                    return null;
                }
            }
            int currValue = calendar.get(this.field);
            if (this.start2 != -1) {
                if (currValue >= this.start2) {
                    return this.isValidResult(calendar, currValue) ? Integer.valueOf(currValue) : null;
                }
                if (currValue > this.end) {
                    return this.isValidResult(calendar, this.start2) ? Integer.valueOf(this.start2) : null;
                }
            }
            if (currValue <= this.start) {
                return this.isValidResult(calendar, this.start) ? Integer.valueOf(this.start) : null;
            }
            if (currValue <= this.end) {
                return this.isValidResult(calendar, currValue) ? Integer.valueOf(currValue) : null;
            }
            return null;
        }

        @Override
        public Integer getPreviousValue(Calendar calendar) {
            if (this.isDynamicRangeExpression) {
                try {
                    this.initStartEndValues(calendar);
                }
                catch (ParseException e) {
                    return null;
                }
            }
            int currValue = calendar.get(this.field);
            if (this.start2 != -1 && currValue >= this.start2) {
                return this.isValidResult(calendar, currValue) ? Integer.valueOf(currValue) : null;
            }
            if (currValue <= this.start) {
                return null;
            }
            if (currValue <= this.end) {
                return this.isValidResult(calendar, currValue) ? Integer.valueOf(currValue) : null;
            }
            return this.isValidResult(calendar, this.end) ? Integer.valueOf(this.end) : null;
        }

        public List<Integer> getAllValuesInRange(Calendar calendar) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            if (this.isDynamicRangeExpression) {
                try {
                    this.initStartEndValues(calendar);
                }
                catch (ParseException e) {
                    return values;
                }
            }
            if (this.start2 == -1) {
                for (int i = this.start; i <= this.end; ++i) {
                    values.add(i);
                }
            } else {
                int i;
                for (i = this.start; i <= this.end; ++i) {
                    values.add(i);
                }
                for (i = this.start2; i <= CALENDAR.getMaximum(this.field); ++i) {
                    values.add(i);
                }
            }
            return values;
        }
    }

    private static abstract class FieldExpression
    implements Serializable {
        protected static final Calendar CALENDAR = new GregorianCalendar(Locale.US);
        public final int field;

        protected static int convertValue(String value, int field) throws ParseException {
            if (Character.isDigit(value.charAt(0))) {
                int numValue;
                try {
                    numValue = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new ParseException(field, value, "Unparseable value");
                }
                if (field == 7) {
                    ++numValue;
                } else if (field == 2) {
                    --numValue;
                }
                return numValue;
            }
            switch (field) {
                case 2: {
                    return (Integer)MONTHS_MAP.get(value);
                }
                case 7: {
                    return (Integer)WEEKDAYS_MAP.get(value);
                }
            }
            throw new ParseException(field, value, "Unparseable value");
        }

        protected FieldExpression(int field) {
            this.field = field;
        }

        protected int convertValue(String value) throws ParseException {
            return FieldExpression.convertValue(value, this.field);
        }

        protected boolean isValidResult(Calendar calendar, Integer result) {
            return result != null && result >= calendar.getActualMinimum(this.field) && result <= calendar.getActualMaximum(this.field);
        }

        public abstract Integer getNextValue(Calendar var1);

        public abstract Integer getPreviousValue(Calendar var1);
    }

    public static class ParseException
    extends Exception {
        private final Map<Integer, ParseException> children;
        private final Integer field;
        private final String value;
        private final String error;

        protected ParseException(int field, String value, String message) {
            this.children = null;
            this.field = field;
            this.value = value;
            this.error = message;
        }

        protected ParseException(Map<Integer, ParseException> children) {
            this.children = children;
            this.field = null;
            this.value = null;
            this.error = null;
        }

        public Map<Integer, ParseException> getChildren() {
            return this.children != null ? Collections.unmodifiableMap(this.children) : null;
        }

        public Integer getField() {
            return this.field;
        }

        public String getValue() {
            return this.value;
        }

        public String getError() {
            return this.error;
        }

        @Override
        public String toString() {
            return "ParseException [field=" + this.field + ", value=" + this.value + ", error=" + this.error + "]";
        }
    }
}

