/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.ws.wsaddressing;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.WebServiceException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;

@XmlRootElement(name="EndpointReference", namespace="http://www.w3.org/2005/08/addressing")
@XmlType(name="EndpointReferenceType", namespace="http://www.w3.org/2005/08/addressing")
public final class W3CEndpointReference
extends EndpointReference {
    protected static final String NS = "http://www.w3.org/2005/08/addressing";
    private static JAXBContext jaxbContext;
    @XmlElement(name="Address", namespace="http://www.w3.org/2005/08/addressing", required=true)
    private AttributedURIType address;
    @XmlElement(name="ReferenceParameters", namespace="http://www.w3.org/2005/08/addressing")
    private ReferenceParametersType referenceParameters;
    @XmlElement(name="Metadata", namespace="http://www.w3.org/2005/08/addressing")
    private MetadataType metadata;
    @XmlAnyElement(lax=true)
    private List<Object> any;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    protected W3CEndpointReference() {
    }

    public W3CEndpointReference(Source eprInfoset) {
        try {
            Unmarshaller um = jaxbContext.createUnmarshaller();
            W3CEndpointReference w3cEPR = (W3CEndpointReference)um.unmarshal(eprInfoset);
            this.address = w3cEPR.address;
            this.referenceParameters = w3cEPR.referenceParameters;
            this.metadata = w3cEPR.metadata;
            this.any = w3cEPR.any;
            this.otherAttributes.putAll(w3cEPR.otherAttributes);
        }
        catch (Exception e) {
            throw new WebServiceException("Unable to create W3C endpoint reference.", e);
        }
    }

    public void writeTo(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Null is not allowed.");
        }
        try {
            Marshaller m = jaxbContext.createMarshaller();
            m.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            m.marshal((Object)this, result);
        }
        catch (Exception e) {
            throw new WebServiceException("writeTo failure.", e);
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{W3CEndpointReference.class});
        }
        catch (Exception e) {
            throw new WebServiceException("JAXBContext creation failed.", e);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="MetadataType", propOrder={"any"})
    private static class MetadataType {
        @XmlAnyElement(lax=true)
        protected List<Object> any;
        @XmlAnyAttribute
        protected Map<QName, String> otherAttributes = new HashMap<QName, String>();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="ReferenceParametersType", propOrder={"any"})
    private static class ReferenceParametersType {
        @XmlAnyElement(lax=true)
        protected List<Object> any;
        @XmlAnyAttribute
        protected Map<QName, String> otherAttributes = new HashMap<QName, String>();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="AttributedURIType", propOrder={"value"})
    private static class AttributedURIType {
        @XmlValue
        @XmlSchemaType(name="anyURI")
        protected String value;
        @XmlAnyAttribute
        protected Map<QName, String> otherAttributes = new HashMap<QName, String>();
    }
}

