/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import jakarta.ejb.embeddable.EJBContainer;
import jakarta.jms.MessageListener;
import java.lang.reflect.Constructor;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.ModuleContext;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.JndiNameInfo;
import org.apache.openejb.assembler.classic.ManagedBeanInfo;
import org.apache.openejb.core.ivm.naming.BusinessLocalBeanReference;
import org.apache.openejb.core.ivm.naming.BusinessLocalReference;
import org.apache.openejb.core.ivm.naming.BusinessRemoteReference;
import org.apache.openejb.core.ivm.naming.IntraVmJndiReference;
import org.apache.openejb.core.ivm.naming.ObjectReference;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Classes;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.StringTemplate;
import org.apache.openejb.util.Strings;

public class JndiBuilder {
    public static final String DEFAULT_NAME_KEY = "default";
    final boolean embeddedEjbContainerApi;
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, JndiBuilder.class.getPackage().getName());
    private static final boolean USE_OLD_JNDI_NAMES = SystemInstance.get().getOptions().get("openejb.use-old-jndi-names", false);
    private final Context openejbContext;
    private static final String JNDINAME_STRATEGY_CLASS = "openejb.jndiname.strategy.class";
    private static final String JNDINAME_FAILONCOLLISION = "openejb.jndiname.failoncollision";
    private final boolean failOnCollision;

    public JndiBuilder(Context openejbContext) {
        this.openejbContext = openejbContext;
        Options options = SystemInstance.get().getOptions();
        this.failOnCollision = options.get(JNDINAME_FAILONCOLLISION, true);
        this.embeddedEjbContainerApi = options.get(EJBContainer.class.getName(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(EjbJarInfo ejbJar, HashMap<String, BeanContext> deployments) {
        JndiNameStrategy strategy = JndiBuilder.createStrategy(ejbJar, deployments);
        for (EnterpriseBeanInfo beanInfo : ejbJar.enterpriseBeans) {
            BeanContext beanContext = deployments.get(beanInfo.ejbDeploymentId);
            strategy.begin(beanContext);
            try {
                this.bind(ejbJar, beanContext, beanInfo, strategy);
            }
            finally {
                strategy.end();
            }
        }
    }

    public static JndiNameStrategy createStrategy(EjbJarInfo ejbJar, Map<String, BeanContext> deployments) {
        Options options = new Options(ejbJar.properties, SystemInstance.get().getOptions());
        Class<TemplatedStrategy> strategyClass = options.get(JNDINAME_STRATEGY_CLASS, TemplatedStrategy.class);
        String strategyClassName = strategyClass.getName();
        try {
            try {
                Constructor constructor = strategyClass.getConstructor(EjbJarInfo.class, Map.class);
                return (JndiNameStrategy)constructor.newInstance(ejbJar, deployments);
            }
            catch (NoSuchMethodException constructor) {
                Constructor constructor2 = strategyClass.getConstructor(new Class[0]);
                return (JndiNameStrategy)constructor2.newInstance(new Object[0]);
            }
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Could not instantiate JndiNameStrategy: " + strategyClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access JndiNameStrategy: " + strategyClassName, e);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Could not create JndiNameStrategy: " + strategyClassName, t);
        }
    }

    public void bind(EjbJarInfo ejbJarInfo, BeanContext bean, EnterpriseBeanInfo beanInfo, JndiNameStrategy strategy) {
        String name;
        ObjectReference ref;
        String name2;
        String internalName;
        org.apache.openejb.core.ivm.naming.Reference ref2;
        Object home;
        if (BeanContext.Comp.class.equals((Object)bean.getBeanClass())) {
            return;
        }
        Bindings bindings = new Bindings();
        bean.set(Bindings.class, bindings);
        org.apache.openejb.core.ivm.naming.Reference simpleNameRef = null;
        Object id = bean.getDeploymentID();
        try {
            if (bean.isLocalbean()) {
                Class beanClass = bean.getBeanClass();
                BeanContext.BusinessLocalBeanHome home2 = bean.getBusinessLocalBeanHome();
                BusinessLocalBeanReference ref3 = new BusinessLocalBeanReference(home2);
                this.optionalBind(bindings, (Reference)((Object)ref3), "openejb/Deployment/" + JndiBuilder.format(id, beanClass.getName(), InterfaceType.LOCALBEAN));
                if (!bean.getBeanClass().isInterface()) {
                    Class clazz = bean.getBeanClass().getSuperclass();
                    while (!clazz.equals(Object.class)) {
                        this.optionalBind(bindings, (Reference)((Object)ref3), "openejb/Deployment/" + JndiBuilder.format(id, clazz.getName(), InterfaceType.LOCALBEAN));
                        clazz = clazz.getSuperclass();
                    }
                }
                String internalName2 = "openejb/Deployment/" + JndiBuilder.format(id, beanClass.getName(), InterfaceType.BUSINESS_LOCALBEAN_HOME);
                this.bind(internalName2, (Reference)((Object)ref3), bindings, beanInfo, beanClass);
                String name3 = strategy.getName(beanClass, DEFAULT_NAME_KEY, JndiNameStrategy.Interface.LOCALBEAN);
                this.bind("openejb/local/" + name3, (Reference)((Object)ref3), bindings, beanInfo, beanClass);
                this.bindJava(bean, beanClass, (Reference)((Object)ref3), bindings, beanInfo);
                if (USE_OLD_JNDI_NAMES) {
                    bean.getModuleContext().getAppContext().getBindings().put(name3, (Object)ref3);
                }
                simpleNameRef = ref3;
            }
        }
        catch (NamingException e) {
            throw new OpenEJBRuntimeException("Unable to bind business remote deployment in jndi.", e);
        }
        try {
            for (Class interfce : bean.getBusinessLocalInterfaces()) {
                home = bean.getBusinessLocalHome(interfce);
                ref2 = new BusinessLocalReference((BeanContext.BusinessLocalHome)home);
                this.optionalBind(bindings, (Reference)((Object)ref2), "openejb/Deployment/" + JndiBuilder.format(id, interfce.getName()));
                internalName = "openejb/Deployment/" + JndiBuilder.format(id, interfce.getName(), InterfaceType.BUSINESS_LOCAL);
                this.bind(internalName, (Reference)((Object)ref2), bindings, beanInfo, interfce);
                name2 = strategy.getName(interfce, DEFAULT_NAME_KEY, JndiNameStrategy.Interface.BUSINESS_LOCAL);
                String externalName = "openejb/local/" + name2;
                this.bind(externalName, (Reference)((Object)ref2), bindings, beanInfo, interfce);
                this.bindJava(bean, interfce, (Reference)((Object)ref2), bindings, beanInfo);
                if (USE_OLD_JNDI_NAMES) {
                    bean.getModuleContext().getAppContext().getBindings().put(name2, (Object)ref2);
                }
                if (simpleNameRef != null) continue;
                simpleNameRef = ref2;
            }
        }
        catch (NamingException e) {
            throw new OpenEJBRuntimeException("Unable to bind business local interface for deployment " + id, e);
        }
        try {
            for (Class interfce : bean.getBusinessRemoteInterfaces()) {
                home = bean.getBusinessRemoteHome(interfce);
                ref2 = new BusinessRemoteReference((BeanContext.BusinessRemoteHome)home);
                this.optionalBind(bindings, (Reference)((Object)ref2), "openejb/Deployment/" + JndiBuilder.format(id, interfce.getName(), null));
                internalName = "openejb/Deployment/" + JndiBuilder.format(id, interfce.getName(), InterfaceType.BUSINESS_REMOTE);
                this.bind(internalName, (Reference)((Object)ref2), bindings, beanInfo, interfce);
                name2 = strategy.getName(interfce, DEFAULT_NAME_KEY, JndiNameStrategy.Interface.BUSINESS_REMOTE);
                this.bind("openejb/local/" + name2, (Reference)((Object)ref2), bindings, beanInfo, interfce);
                this.bind("openejb/remote/" + name2, (Reference)((Object)ref2), bindings, beanInfo, interfce);
                this.bind("openejb/remote/" + this.computeGlobalName(bean, interfce), (Reference)((Object)ref2), bindings, beanInfo, interfce);
                this.bindJava(bean, interfce, (Reference)((Object)ref2), bindings, beanInfo);
                if (USE_OLD_JNDI_NAMES) {
                    bean.getModuleContext().getAppContext().getBindings().put(name2, (Object)ref2);
                }
                if (simpleNameRef != null) continue;
                simpleNameRef = ref2;
            }
        }
        catch (NamingException e) {
            throw new OpenEJBRuntimeException("Unable to bind business remote deployment in jndi.", e);
        }
        try {
            Class localHomeInterface = bean.getLocalHomeInterface();
            if (localHomeInterface != null) {
                ref = new ObjectReference(bean.getEJBLocalHome());
                name = strategy.getName(bean.getLocalHomeInterface(), DEFAULT_NAME_KEY, JndiNameStrategy.Interface.LOCAL_HOME);
                this.bind("openejb/local/" + name, (Reference)((Object)ref), bindings, beanInfo, localHomeInterface);
                this.optionalBind(bindings, (Reference)((Object)ref), "openejb/Deployment/" + JndiBuilder.format(id, localHomeInterface.getName(), InterfaceType.EJB_LOCAL_HOME));
                name = "openejb/Deployment/" + JndiBuilder.format(id, bean.getLocalInterface().getName());
                this.bind(name, (Reference)((Object)ref), bindings, beanInfo, localHomeInterface);
                name = "openejb/Deployment/" + JndiBuilder.format(id, bean.getLocalInterface().getName(), InterfaceType.EJB_LOCAL);
                this.bind(name, (Reference)((Object)ref), bindings, beanInfo, localHomeInterface);
                this.bindJava(bean, localHomeInterface, (Reference)((Object)ref), bindings, beanInfo);
                if (simpleNameRef == null) {
                    simpleNameRef = ref;
                }
            }
        }
        catch (NamingException e) {
            throw new OpenEJBRuntimeException("Unable to bind local home interface for deployment " + id, e);
        }
        try {
            Class homeInterface = bean.getHomeInterface();
            if (homeInterface != null) {
                ref = new ObjectReference(bean.getEJBHome());
                name = strategy.getName(homeInterface, DEFAULT_NAME_KEY, JndiNameStrategy.Interface.REMOTE_HOME);
                this.bind("openejb/local/" + name, (Reference)((Object)ref), bindings, beanInfo, homeInterface);
                this.bind("openejb/remote/" + name, (Reference)((Object)ref), bindings, beanInfo, homeInterface);
                this.optionalBind(bindings, (Reference)((Object)ref), "openejb/Deployment/" + JndiBuilder.format(id, homeInterface.getName(), InterfaceType.EJB_HOME));
                name = "openejb/Deployment/" + JndiBuilder.format(id, bean.getRemoteInterface().getName());
                this.bind(name, (Reference)((Object)ref), bindings, beanInfo, homeInterface);
                name = "openejb/Deployment/" + JndiBuilder.format(id, bean.getRemoteInterface().getName(), InterfaceType.EJB_OBJECT);
                this.bind(name, (Reference)((Object)ref), bindings, beanInfo, homeInterface);
                this.bindJava(bean, homeInterface, (Reference)((Object)ref), bindings, beanInfo);
                if (simpleNameRef == null) {
                    simpleNameRef = ref;
                }
            }
        }
        catch (NamingException e) {
            throw new OpenEJBRuntimeException("Unable to bind remote home interface for deployment " + id, e);
        }
        try {
            if (simpleNameRef != null) {
                this.bindJava(bean, null, (Reference)((Object)simpleNameRef), bindings, beanInfo);
            }
        }
        catch (NamingException e) {
            throw new OpenEJBRuntimeException("Unable to bind simple java:global name in jndi", e);
        }
        try {
            if (MessageListener.class.equals((Object)bean.getMdbInterface())) {
                String destinationId = bean.getDestinationId();
                String jndiName = "openejb/Resource/" + destinationId;
                IntraVmJndiReference reference = new IntraVmJndiReference(jndiName);
                String deploymentId = id.toString();
                this.bind("openejb/local/" + deploymentId, (Reference)((Object)reference), bindings, beanInfo, MessageListener.class);
                this.bind("openejb/remote/" + deploymentId, (Reference)((Object)reference), bindings, beanInfo, MessageListener.class);
            }
        }
        catch (NamingException e) {
            throw new OpenEJBRuntimeException("Unable to bind mdb destination in jndi.", e);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private void optionalBind(Bindings bindings, Reference ref, String name) throws NamingException {
        try {
            this.openejbContext.bind(name, (Object)ref);
            logger.debug("bound ejb at name: " + name + ", ref: " + ref);
            bindings.add(name);
        }
        catch (NamingException okIfBindFails) {
            logger.debug("failed to bind ejb at name: " + name + ", ref: " + ref);
        }
    }

    public static String format(Object deploymentId, String interfaceClassName) {
        return JndiBuilder.format((String)deploymentId, interfaceClassName, null);
    }

    public static String format(Object deploymentId, String interfaceClassName, InterfaceType interfaceType) {
        return JndiBuilder.format((String)deploymentId, interfaceClassName, interfaceType);
    }

    public static String format(String deploymentId, String interfaceClassName, InterfaceType interfaceType) {
        return deploymentId + "/" + interfaceClassName + (interfaceType == null ? "" : "!" + interfaceType.getSpecName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bind(String name, Reference ref, Bindings bindings, EnterpriseBeanInfo beanInfo, Class intrface) throws NamingException {
        if (name.startsWith("openejb/local/") || name.startsWith("openejb/remote/") || name.startsWith("openejb/localbean/") || name.startsWith("openejb/global/")) {
            String externalName = name.replaceFirst("openejb/[^/]+/", "");
            if (bindings.contains(name)) {
                if (!name.startsWith("openejb/local/")) return;
                logger.debug("Duplicate: Jndi(name=" + externalName + ")");
                return;
            }
            try {
                this.openejbContext.bind(name, (Object)ref);
                bindings.add(name);
                if (beanInfo.jndiNames.contains(externalName)) return;
                beanInfo.jndiNames.add(externalName);
                JndiNameInfo nameInfo = new JndiNameInfo();
                nameInfo.intrface = intrface == null ? null : intrface.getName();
                nameInfo.name = externalName;
                beanInfo.jndiNamess.add(nameInfo);
                if (this.embeddedEjbContainerApi || beanInfo instanceof ManagedBeanInfo && ((ManagedBeanInfo)beanInfo).hidden) return;
                logger.info("Jndi(name=" + externalName + ") --> Ejb(deployment-id=" + beanInfo.ejbDeploymentId + ")");
                return;
            }
            catch (NameAlreadyBoundException e) {
                BeanContext deployment = this.findNameOwner(name);
                if (deployment != null) {
                    logger.error("Jndi(name=" + externalName + ") cannot be bound to Ejb(deployment-id=" + beanInfo.ejbDeploymentId + ").  Name already taken by Ejb(deployment-id=" + deployment.getDeploymentID() + ")");
                } else {
                    logger.error("Jndi(name=" + externalName + ") cannot be bound to Ejb(deployment-id=" + beanInfo.ejbDeploymentId + ").  Name already taken by another object in the system.");
                }
                if (!this.failOnCollision) return;
                throw new NameAlreadyBoundException(externalName);
            }
        }
        try {
            this.openejbContext.bind(name, (Object)ref);
            logger.debug("bound ejb at name: " + name + ", ref: " + ref);
            bindings.add(name);
            return;
        }
        catch (NameAlreadyBoundException e) {
            logger.error("Jndi name could not be bound; it may be taken by another ejb.  Jndi(name=" + name + ")");
            throw new NameAlreadyBoundException(name);
        }
    }

    private String computeGlobalName(BeanContext cdi, Class<?> intrface) {
        ModuleContext module = cdi.getModuleContext();
        AppContext application = module.getAppContext();
        String appName = application.isStandaloneModule() ? "" : application.getId() + "/";
        String moduleName = this.moduleName(cdi);
        String beanName = cdi.getEjbName();
        if (intrface != null) {
            beanName = beanName + "!" + intrface.getName();
        }
        return "global/" + appName + moduleName + beanName;
    }

    private String moduleName(BeanContext cdi) {
        String moduleName = cdi.getModuleName() + "/";
        if (moduleName.startsWith("ear-scoped-cdi-beans_")) {
            moduleName = moduleName.substring("ear-scoped-cdi-beans_".length());
        }
        return moduleName;
    }

    private void bindJava(BeanContext cdi, Class intrface, Reference ref, Bindings bindings, EnterpriseBeanInfo beanInfo) throws NamingException {
        ModuleContext module = cdi.getModuleContext();
        AppContext application = module.getAppContext();
        Context moduleContext = module.getModuleJndiContext();
        Context appContext = application.getAppJndiContext();
        Context globalContext = application.getGlobalJndiContext();
        String appName = application.isStandaloneModule() ? "" : application.getId() + "/";
        String moduleName = this.moduleName(cdi);
        if (moduleName.startsWith("/")) {
            moduleName = moduleName.substring(1);
        }
        String beanName = cdi.getEjbName();
        if (intrface != null) {
            beanName = beanName + "!" + intrface.getName();
        }
        String globalName = "global/" + appName + moduleName + beanName;
        try {
            if (!(!this.embeddedEjbContainerApi || beanInfo instanceof ManagedBeanInfo && ((ManagedBeanInfo)beanInfo).hidden)) {
                logger.info(String.format("Jndi(name=\"java:%s\")", globalName));
            }
            globalContext.bind(globalName, (Object)ref);
            application.getBindings().put(globalName, ref);
            this.bind("openejb/global/" + globalName, ref, bindings, beanInfo, intrface);
        }
        catch (NameAlreadyBoundException e) {
            return;
        }
        appContext.bind("app/" + moduleName + beanName, (Object)ref);
        application.getBindings().put("app/" + moduleName + beanName, ref);
        String moduleJndi = "module/" + beanName;
        moduleContext.bind(moduleJndi, (Object)ref);
        ContextualEjbLookup contextual = (ContextualEjbLookup)((Object)ContextualEjbLookup.class.cast(application.getBindings().get(moduleJndi)));
        if (contextual == null) {
            HashMap<BeanContext, Object> potentials = new HashMap<BeanContext, Object>();
            contextual = new ContextualEjbLookup(potentials, ref);
            application.getBindings().put(moduleJndi, (Object)contextual);
        }
        contextual.potentials.put(cdi, ref);
    }

    private BeanContext findNameOwner(String name) {
        ContainerSystem containerSystem = SystemInstance.get().getComponent(ContainerSystem.class);
        for (BeanContext beanContext : containerSystem.deployments()) {
            Bindings bindings = beanContext.get(Bindings.class);
            if (bindings == null || !bindings.getBindings().contains(name)) continue;
            return beanContext;
        }
        return null;
    }

    public static class ContextualEjbLookup
    extends org.apache.openejb.core.ivm.naming.Reference {
        private final Map<BeanContext, Object> potentials;
        private final Object defaultValue;

        public ContextualEjbLookup(Map<BeanContext, Object> potentials, Object defaultValue) {
            this.potentials = potentials;
            this.defaultValue = defaultValue;
        }

        @Override
        public Object getObject() throws NamingException {
            if (this.potentials.size() == 1) {
                return this.unwrap(this.defaultValue);
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                for (Map.Entry<BeanContext, Object> o : this.potentials.entrySet()) {
                    if (!loader.equals(o.getKey().getClassLoader())) continue;
                    return this.unwrap(o.getValue());
                }
            }
            return this.unwrap(this.defaultValue);
        }

        private Object unwrap(Object value) throws NamingException {
            if (org.apache.openejb.core.ivm.naming.Reference.class.isInstance(value)) {
                return ((org.apache.openejb.core.ivm.naming.Reference)((Object)org.apache.openejb.core.ivm.naming.Reference.class.cast(value))).getObject();
            }
            return value;
        }
    }

    public static class RemoteInterfaceComparator
    implements Comparator<Class> {
        @Override
        public int compare(Class a, Class b) {
            boolean bIsRmote;
            boolean aIsRmote = Remote.class.isAssignableFrom(a);
            if (aIsRmote == (bIsRmote = Remote.class.isAssignableFrom(b))) {
                return 0;
            }
            return aIsRmote ? 1 : -1;
        }
    }

    protected static final class Bindings {
        private final List<String> bindings = new ArrayList<String>();

        protected Bindings() {
        }

        public List<String> getBindings() {
            return this.bindings;
        }

        public boolean add(String o) {
            return this.bindings.add(o);
        }

        public boolean contains(String o) {
            return this.bindings.contains(o);
        }
    }

    public static class LegacyAddedSuffixStrategy
    implements JndiNameStrategy {
        private BeanContext beanContext;

        @Override
        public void begin(BeanContext beanContext) {
            this.beanContext = beanContext;
        }

        @Override
        public void end() {
        }

        @Override
        public String getName(Class interfce, String key, JndiNameStrategy.Interface type) {
            String id = String.valueOf(this.beanContext.getDeploymentID());
            if (id.charAt(0) == '/') {
                id = id.substring(1);
            }
            switch (type) {
                case REMOTE_HOME: {
                    return id;
                }
                case LOCAL_HOME: {
                    return id + "Local";
                }
                case BUSINESS_LOCAL: {
                    return id + "BusinessLocal";
                }
                case BUSINESS_REMOTE: {
                    return id + "BusinessRemote";
                }
            }
            return id;
        }

        @Override
        public Map<String, String> getNames(Class interfce, JndiNameStrategy.Interface type) {
            HashMap<String, String> names = new HashMap<String, String>();
            names.put("", this.getName(interfce, JndiBuilder.DEFAULT_NAME_KEY, type));
            return names;
        }
    }

    public static class TemplatedStrategy
    implements JndiNameStrategy {
        private static final String JNDINAME_FORMAT = "openejb.jndiname.format";
        private static final String KEYS = "default,local,global,app";
        private final StringTemplate template;
        private final HashMap<String, EnterpriseBeanInfo> beanInfos;
        private BeanContext bean;
        private HashMap<String, Map<String, StringTemplate>> templates;
        private String format;
        private Map<String, String> appContext;
        private HashMap<String, String> beanContext;

        public TemplatedStrategy(EjbJarInfo ejbJarInfo, Map<String, BeanContext> deployments) {
            Options options = new Options(ejbJarInfo.properties, SystemInstance.get().getOptions());
            this.format = options.get(JNDINAME_FORMAT, "{deploymentId}{interfaceType.annotationName}");
            int index = this.format.indexOf(58);
            if (index > -1) {
                logger.error("Illegal openejb.jndiname.format contains a colon ':'.  Everything before the colon will be removed, '" + this.format + "' ");
                this.format = this.format.substring(index + 1);
            }
            this.template = new StringTemplate(this.format);
            this.beanInfos = new HashMap();
            for (EnterpriseBeanInfo beanInfo : ejbJarInfo.enterpriseBeans) {
                this.beanInfos.put(beanInfo.ejbDeploymentId, beanInfo);
            }
            Iterator<BeanContext> it = deployments.values().iterator();
            if (!it.hasNext()) {
                return;
            }
            ModuleContext moduleContext = it.next().getModuleContext();
            this.appContext = new HashMap<String, String>();
            this.putAll(this.appContext, SystemInstance.get().getProperties());
            this.putAll(this.appContext, moduleContext.getAppContext().getProperties());
            this.putAll(this.appContext, moduleContext.getProperties());
            this.appContext.put("appName", moduleContext.getAppContext().getId());
            this.appContext.put("appId", moduleContext.getAppContext().getId());
            this.appContext.put("moduleName", moduleContext.getId());
            this.appContext.put("moduleId", moduleContext.getId());
        }

        private void putAll(Map<String, String> map, Properties properties) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                if (!(e.getValue() instanceof String) || !(e.getKey() instanceof String)) continue;
                map.put((String)e.getKey(), (String)e.getValue());
            }
        }

        private Map<String, StringTemplate> addTemplate(Map<String, StringTemplate> map, String key, StringTemplate template) {
            Map<String, StringTemplate> m = map;
            if (m == null) {
                m = new TreeMap<String, StringTemplate>();
            }
            m.put(key, template);
            return m;
        }

        @Override
        public void begin(BeanContext bean) {
            this.bean = bean;
            EnterpriseBeanInfo beanInfo = this.beanInfos.get(bean.getDeploymentID());
            this.templates = new HashMap();
            this.templates.put("", this.addTemplate(null, JndiBuilder.DEFAULT_NAME_KEY, this.template));
            for (JndiNameInfo nameInfo : beanInfo.jndiNamess) {
                String intrface = nameInfo.intrface;
                if (intrface == null) {
                    intrface = "";
                }
                this.templates.put(intrface, this.addTemplate(this.templates.get(intrface), TemplatedStrategy.getType(nameInfo.name), new StringTemplate(nameInfo.name)));
            }
            beanInfo.jndiNames.clear();
            beanInfo.jndiNamess.clear();
            this.beanContext = new HashMap<String, String>(this.appContext);
            this.putAll(this.beanContext, bean.getProperties());
            this.beanContext.put("ejbType", bean.getComponentType().name());
            this.beanContext.put("ejbClass", bean.getBeanClass().getName());
            this.beanContext.put("ejbClass.simpleName", bean.getBeanClass().getSimpleName());
            this.beanContext.put("ejbClass.packageName", Classes.packageName(bean.getBeanClass()));
            this.beanContext.put("ejbName", bean.getEjbName());
            this.beanContext.put("deploymentId", bean.getDeploymentID().toString());
        }

        private static String getType(String name) {
            int end;
            int start = 0;
            if (name.charAt(0) == '/') {
                start = 1;
            }
            if ((end = name.substring(start).indexOf(47)) < 0) {
                return JndiBuilder.DEFAULT_NAME_KEY;
            }
            return name.substring(start, end);
        }

        @Override
        public void end() {
        }

        @Override
        public String getName(Class interfce, String key, JndiNameStrategy.Interface type) {
            Map<String, StringTemplate> template = this.templates.get(interfce.getName());
            if (template == null) {
                template = this.templates.get(type.getAnnotationName());
            }
            if (template == null) {
                template = this.templates.get("");
            }
            HashMap<String, String> contextData = new HashMap<String, String>(this.beanContext);
            contextData.put("interfaceType", type.getAnnotationName());
            contextData.put("interfaceType.annotationName", type.getAnnotationName());
            contextData.put("interfaceType.annotationNameLC", type.getAnnotationName().toLowerCase());
            contextData.put("interfaceType.xmlName", type.getXmlName());
            contextData.put("interfaceType.xmlNameCc", type.getXmlNameCc());
            contextData.put("interfaceType.openejbLegacyName", type.getOpenejbLegacy());
            contextData.put("interfaceClass", interfce.getName());
            contextData.put("interfaceClass.simpleName", interfce.getSimpleName());
            contextData.put("interfaceClass.packageName", Classes.packageName(interfce));
            StringTemplate stringTemplate = null;
            stringTemplate = template.containsKey(key) ? template.get(key) : template.get(JndiBuilder.DEFAULT_NAME_KEY);
            if (stringTemplate == null) {
                stringTemplate = template.values().iterator().next();
            }
            return stringTemplate.apply(contextData);
        }

        @Override
        public Map<String, String> getNames(Class interfce, JndiNameStrategy.Interface type) {
            HashMap<String, String> names = new HashMap<String, String>();
            for (String key : KEYS.split(",")) {
                names.put(key, this.getName(interfce, key, type));
            }
            return names;
        }
    }

    public static interface JndiNameStrategy {
        public void begin(BeanContext var1);

        public String getName(Class var1, String var2, Interface var3);

        public Map<String, String> getNames(Class var1, Interface var2);

        public void end();

        public static enum Interface {
            REMOTE_HOME(InterfaceType.EJB_HOME, "RemoteHome", "home", ""),
            LOCAL_HOME(InterfaceType.EJB_LOCAL_HOME, "LocalHome", "local-home", "Local"),
            BUSINESS_LOCAL(InterfaceType.BUSINESS_LOCAL, "Local", "business-local", "BusinessLocal"),
            LOCALBEAN(InterfaceType.LOCALBEAN, "LocalBean", "localbean", "LocalBean"),
            BUSINESS_REMOTE(InterfaceType.BUSINESS_REMOTE, "Remote", "business-remote", "BusinessRemote"),
            SERVICE_ENDPOINT(InterfaceType.SERVICE_ENDPOINT, "Endpoint", "service-endpoint", "ServiceEndpoint");

            private final InterfaceType type;
            private final String annotatedName;
            private final String xmlName;
            private final String xmlNameCc;
            private final String openejbLegacy;

            private Interface(InterfaceType type, String annotatedName, String xmlName, String openejbLegacy) {
                this.type = type;
                this.annotatedName = annotatedName;
                this.xmlName = xmlName;
                this.xmlNameCc = Strings.camelCase(xmlName);
                this.openejbLegacy = openejbLegacy;
            }

            public InterfaceType getType() {
                return this.type;
            }

            public String getAnnotationName() {
                return this.annotatedName;
            }

            public String getXmlName() {
                return this.xmlName;
            }

            public String getXmlNameCc() {
                return this.xmlNameCc;
            }

            public String getOpenejbLegacy() {
                return this.openejbLegacy;
            }
        }
    }
}

