/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.staxutils.DepthExceededStaxException;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Provider
@Produces(value={"application/xml", "application/*+xml", "text/xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml", "text/html"})
public class SourceProvider<T>
extends AbstractConfigurableProvider
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    private static final String PREFERRED_FORMAT = "source-preferred-format";
    private static final Logger LOG = LogUtils.getL7dLogger(SourceProvider.class);
    @Context
    private MessageContext context;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return Source.class.isAssignableFrom(type) || Node.class.isAssignableFrom(type);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return Source.class.isAssignableFrom(type) || XMLSource.class.isAssignableFrom(type) || Document.class.isAssignableFrom(type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T readFrom(Class<T> source, Type genericType, Annotation[] annotations, MediaType m, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        String s;
        Class<Object> theSource = source;
        if (theSource == Source.class && ("sax".equalsIgnoreCase(s = this.getPreferredSource()) || "cxf.stax".equalsIgnoreCase(s))) {
            theSource = SAXSource.class;
        }
        try {
            if (DOMSource.class.isAssignableFrom(theSource) || Document.class.isAssignableFrom(theSource)) {
                boolean docRequired = Document.class.isAssignableFrom(theSource);
                XMLStreamReader reader = this.getReader(is);
                try {
                    Document doc = StaxUtils.read((XMLStreamReader)reader);
                    T t = source.cast(docRequired ? doc : new DOMSource(doc));
                    return t;
                }
                catch (DepthExceededStaxException e) {
                    throw ExceptionUtils.toWebApplicationException(null, JAXRSUtils.toResponse(413));
                }
                catch (XMLStreamException e) {
                    if (e.getMessage() == null) throw ExceptionUtils.toBadRequestException(e, null);
                    if (!e.getMessage().startsWith("Maximum Number")) throw ExceptionUtils.toBadRequestException(e, null);
                    throw ExceptionUtils.toWebApplicationException(null, JAXRSUtils.toResponse(413));
                }
                catch (Exception e) {
                    IOException ioex = new IOException("Problem creating a Source object");
                    ioex.setStackTrace(e.getStackTrace());
                    throw ioex;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException xMLStreamException) {}
                }
            }
            if (SAXSource.class.isAssignableFrom(theSource)) return source.cast(new StaxSource(this.getReader(is)));
            if (StaxSource.class.isAssignableFrom(theSource)) {
                return source.cast(new StaxSource(this.getReader(is)));
            }
            if (StreamSource.class.isAssignableFrom(theSource)) return source.cast(new StreamSource(this.getRealStream(is)));
            if (Source.class.isAssignableFrom(theSource)) {
                return source.cast(new StreamSource(this.getRealStream(is)));
            }
            if (!XMLSource.class.isAssignableFrom(theSource)) throw new IOException("Unrecognized source");
            return source.cast(new XMLSource(this.getRealStream(is)));
        }
        catch (ClassCastException e) {
            String msg = "Unsupported class: " + source.getName();
            LOG.warning(msg);
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
    }

    protected XMLStreamReader getReader(InputStream is) {
        XMLStreamReader reader = this.getReaderFromMessage();
        if (reader == null) {
            reader = StaxUtils.createXMLStreamReader((InputStream)is);
        }
        return this.configureReaderRestrictions(reader);
    }

    protected XMLStreamReader configureReaderRestrictions(XMLStreamReader reader) {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        if (message != null) {
            try {
                return StaxUtils.configureReader((XMLStreamReader)reader, (Message)message);
            }
            catch (XMLStreamException ex) {
                throw ExceptionUtils.toInternalServerErrorException(ex, null);
            }
        }
        return reader;
    }

    protected InputStream getRealStream(InputStream is) throws IOException {
        XMLStreamReader reader = this.getReaderFromMessage();
        return reader == null ? is : this.getStreamFromReader(reader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getStreamFromReader(XMLStreamReader input) throws IOException {
        try (CachedOutputStream out = new CachedOutputStream();){
            StaxUtils.copy((XMLStreamReader)input, (OutputStream)out);
            InputStream inputStream = out.getInputStream();
            return inputStream;
        }
        catch (XMLStreamException ex) {
            throw new IOException("XMLStreamException:" + ex.getMessage());
        }
    }

    protected XMLStreamReader getReaderFromMessage() {
        MessageContext mc = this.getContext();
        if (mc != null) {
            return mc.getContent(XMLStreamReader.class);
        }
        return null;
    }

    public void writeTo(T source, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        String encoding = HttpUtils.getSetEncoding(mt, headers, StandardCharsets.UTF_8.name());
        XMLStreamReader reader = source instanceof Source ? StaxUtils.createXMLStreamReader((Source)((Source)source)) : (source instanceof Document ? StaxUtils.createXMLStreamReader((Document)((Document)source)) : StaxUtils.createXMLStreamReader((Source)new DOMSource((Node)source)));
        XMLStreamWriter writer = StaxUtils.createXMLStreamWriter((OutputStream)os, (String)encoding);
        try {
            StaxUtils.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
        }
        catch (XMLStreamException e) {
            throw ExceptionUtils.toInternalServerErrorException(e, null);
        }
        finally {
            try {
                reader.close();
            }
            catch (XMLStreamException xMLStreamException) {}
            try {
                writer.flush();
                writer.close();
            }
            catch (XMLStreamException xMLStreamException) {}
        }
    }

    public long getSize(T source, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    protected String getPreferredSource() {
        MessageContext mc = this.getContext();
        String source = null;
        if (mc != null) {
            source = (String)mc.getContextualProperty(PREFERRED_FORMAT);
        }
        return source != null ? source : "sax";
    }

    protected MessageContext getContext() {
        return this.context;
    }
}

