/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse.client;

import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.sse.InboundSseEvent;
import jakarta.ws.rs.sse.SseEventSource;
import java.security.AccessController;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.sse.client.InboundSseEventListener;
import org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;

public class SseEventSourceImpl
implements SseEventSource {
    private static final Logger LOG = LogUtils.getL7dLogger(SseEventSourceImpl.class);
    private final WebTarget target;
    private final Collection<InboundSseEventListener> listeners = new CopyOnWriteArrayList<InboundSseEventListener>();
    private final AtomicReference<SseSourceState> state = new AtomicReference<SseSourceState>(SseSourceState.CLOSED);
    private volatile ScheduledExecutorService executor;
    private volatile boolean managedExecutor = true;
    private volatile InboundSseEventProcessor processor;
    private volatile TimeUnit unit;
    private volatile long delay;

    SseEventSourceImpl(WebTarget target, long delay, TimeUnit unit) {
        this.target = target;
        this.delay = delay;
        this.unit = unit;
    }

    public void register(Consumer<InboundSseEvent> onEvent) {
        this.listeners.add(new InboundSseEventListenerImpl(onEvent));
    }

    public void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError) {
        this.listeners.add(new InboundSseEventListenerImpl(onEvent, onError));
    }

    public void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError, Runnable onComplete) {
        this.listeners.add(new InboundSseEventListenerImpl(onEvent, onError, onComplete));
    }

    public void open() {
        Object lastEventId;
        if (!this.state.compareAndSet(SseSourceState.CLOSED, SseSourceState.CONNECTING)) {
            throw new IllegalStateException("The SseEventSource is already in " + (Object)((Object)this.state.get()) + " state");
        }
        Configuration configuration = this.target.getConfiguration();
        if (this.executor == null) {
            this.executor = (ScheduledExecutorService)configuration.getProperty("scheduledExecutorService");
            if (this.executor == null) {
                this.executor = Executors.newSingleThreadScheduledExecutor();
                this.managedExecutor = false;
            }
        }
        this.connect((lastEventId = configuration.getProperty("Last-Event-ID")) != null ? lastEventId.toString() : null);
    }

    private void connect(String lastEventId) {
        InboundSseEventListenerDelegate delegate = new InboundSseEventListenerDelegate(lastEventId);
        Response response = null;
        try {
            int status;
            Invocation.Builder builder = this.target.request(new String[]{"text/event-stream"});
            if (lastEventId != null) {
                builder.header("Last-Event-ID", (Object)lastEventId);
            }
            if ((status = (response = builder.get()).getStatus()) == 204) {
                LOG.fine("SSE endpoint " + this.target.getUri() + " returns no data, disconnecting");
                this.state.set(SseSourceState.CLOSED);
                response.close();
                return;
            }
            if (status != 304 && status >= 300) {
                LOG.fine("SSE connection to " + this.target.getUri() + " returns " + status);
                throw ExceptionUtils.toWebApplicationException((Response)response);
            }
            if (this.state.get() == SseSourceState.CLOSED) {
                LOG.fine("SSE connection to " + this.target.getUri() + " has been closed already");
                response.close();
                return;
            }
            Endpoint endpoint = WebClient.getConfig((Object)this.target).getEndpoint();
            if (this.processor == null || this.processor.isClosed()) {
                LOG.fine("Creating new instance of SSE event processor ...");
                this.processor = new InboundSseEventProcessor(endpoint, delegate);
            }
            this.processor.run(response);
            LOG.fine("SSE event processor has been started ...");
            if (!this.state.compareAndSet(SseSourceState.CONNECTING, SseSourceState.OPEN)) {
                throw new IllegalStateException("The SseEventSource is already in " + (Object)((Object)this.state.get()) + " state");
            }
            LOG.fine("Successfuly opened SSE connection to " + this.target.getUri());
        }
        catch (Exception ex) {
            if (this.processor != null) {
                this.processor.close(1L, TimeUnit.SECONDS);
                this.processor = null;
            }
            if (response != null) {
                response.close();
            }
            LOG.fine("Failed to open SSE connection to " + this.target.getUri() + ". " + ex.getMessage());
            delegate.onError(ex);
        }
    }

    public boolean isOpen() {
        return this.state.get() == SseSourceState.OPEN;
    }

    public boolean close(long timeout, TimeUnit tunit) {
        if (this.state.get() == SseSourceState.CLOSED) {
            return true;
        }
        if (this.state.compareAndSet(SseSourceState.CONNECTING, SseSourceState.CLOSED)) {
            LOG.fine("The SseEventSource was not connected, closing anyway");
        } else if (!this.state.compareAndSet(SseSourceState.OPEN, SseSourceState.CLOSED)) {
            throw new IllegalStateException("The SseEventSource is not opened, but in " + (Object)((Object)this.state.get()) + " state");
        }
        if (this.executor != null && !this.managedExecutor) {
            AccessController.doPrivileged(() -> {
                this.executor.shutdown();
                return null;
            });
            this.executor = null;
            this.managedExecutor = true;
        }
        if (this.processor == null) {
            return true;
        }
        return this.processor.close(timeout, tunit);
    }

    private void scheduleReconnect(long tdelay, TimeUnit tunit, String lastEventId) {
        if (tdelay < 0L || this.executor == null) {
            return;
        }
        if (this.state.get() == SseSourceState.CLOSED) {
            return;
        }
        if (this.state.get() != SseSourceState.CONNECTING) {
            LOG.fine("The SseEventSource is still opened, moving it to connecting state");
            if (!this.state.compareAndSet(SseSourceState.OPEN, SseSourceState.CONNECTING)) {
                throw new IllegalStateException("The SseEventSource is not opened, but in " + (Object)((Object)this.state.get()) + " state, unable to reconnect");
            }
        }
        this.executor.schedule(() -> {
            if (this.state.get() == SseSourceState.CONNECTING) {
                LOG.fine("Reestablishing SSE connection to " + this.target.getUri());
                this.connect(lastEventId);
            }
        }, tdelay, tunit);
        LOG.fine("The reconnection attempt to " + this.target.getUri() + " is scheduled in " + tunit.toMillis(tdelay) + "ms");
    }

    private static enum SseSourceState {
        CONNECTING,
        OPEN,
        CLOSED;

    }

    private class InboundSseEventListenerImpl
    implements InboundSseEventListener {
        private final Consumer<InboundSseEvent> onEvent;
        private final Consumer<Throwable> onError;
        private final Runnable onComplete;

        InboundSseEventListenerImpl(Consumer<InboundSseEvent> e) {
            this(e, ex -> {}, () -> {});
        }

        InboundSseEventListenerImpl(Consumer<InboundSseEvent> e, Consumer<Throwable> t) {
            this(e, t, () -> {});
        }

        InboundSseEventListenerImpl(Consumer<InboundSseEvent> e, Consumer<Throwable> t, Runnable c) {
            this.onEvent = e;
            this.onError = t;
            this.onComplete = c;
        }

        @Override
        public void onNext(InboundSseEvent event) {
            this.onEvent.accept(event);
        }

        @Override
        public void onError(Throwable ex) {
            this.onError.accept(ex);
        }

        @Override
        public void onComplete() {
            this.onComplete.run();
        }
    }

    private class InboundSseEventListenerDelegate
    implements InboundSseEventListener {
        private String lastEventId;

        InboundSseEventListenerDelegate(String lastEventId) {
            this.lastEventId = lastEventId;
        }

        @Override
        public void onNext(InboundSseEvent event) {
            this.lastEventId = event.getId();
            SseEventSourceImpl.this.listeners.forEach(listener -> listener.onNext(event));
            if (event.isReconnectDelaySet()) {
                SseEventSourceImpl.this.unit = TimeUnit.MILLISECONDS;
                SseEventSourceImpl.this.delay = event.getReconnectDelay();
            }
        }

        @Override
        public void onError(Throwable ex) {
            SseEventSourceImpl.this.listeners.forEach(listener -> listener.onError(ex));
            if (SseEventSourceImpl.this.delay >= 0L && SseEventSourceImpl.this.unit != null) {
                SseEventSourceImpl.this.scheduleReconnect(SseEventSourceImpl.this.delay, SseEventSourceImpl.this.unit, this.lastEventId);
            }
        }

        @Override
        public void onComplete() {
            SseEventSourceImpl.this.listeners.forEach(InboundSseEventListener::onComplete);
            if (SseEventSourceImpl.this.delay >= 0L && SseEventSourceImpl.this.unit != null) {
                SseEventSourceImpl.this.scheduleReconnect(SseEventSourceImpl.this.delay, SseEventSourceImpl.this.unit, this.lastEventId);
            }
        }
    }
}

