/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.openapi.jaxrs;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.geronimo.microprofile.openapi.cdi.GeronimoOpenAPIExtension;
import org.eclipse.microprofile.openapi.models.OpenAPI;

@Provider
@Dependent
@PreMatching
@Priority(value=5000)
public class OpenAPIFilter
implements ContainerRequestFilter {
    private static final Annotation[] NO_ANNOTATION = new Annotation[0];
    @Inject
    private GeronimoOpenAPIExtension extension;
    @Context
    private Providers providers;
    private OpenAPI openApi;
    private MediaType defaultMediaType;

    @PostConstruct
    private void init() {
        this.defaultMediaType = this.defaultMediaType == null ? this.extension.getDefaultMediaType() : this.defaultMediaType;
    }

    public void filter(ContainerRequestContext rc) {
        if (!"GET".equals(rc.getRequest().getMethod())) {
            return;
        }
        String path = rc.getUriInfo().getPath();
        if ("openapi".equals(path)) {
            List mediaTypes = rc.getAcceptableMediaTypes();
            rc.abortWith(Response.ok((Object)this.openApi).type(this.selectType(mediaTypes)).build());
        }
        if ("openapi.json".equals(path)) {
            rc.abortWith(Response.ok((Object)this.openApi).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        if ("openapi.yml".equals(path) || "openapi.yaml".equals(path)) {
            rc.abortWith(Response.ok((Object)this.openApi).type("text/vnd.yaml").build());
        }
    }

    private MediaType selectType(List<MediaType> mediaTypes) {
        if (mediaTypes.contains(MediaType.APPLICATION_JSON_TYPE)) {
            return MediaType.APPLICATION_JSON_TYPE;
        }
        if (mediaTypes.isEmpty()) {
            return this.defaultMediaType;
        }
        return mediaTypes.stream().filter((? super T it) -> !MediaType.WILDCARD_TYPE.equals(it)).findFirst().filter((? super T it) -> this.providers.getMessageBodyReader(OpenAPI.class, OpenAPI.class, NO_ANNOTATION, it) != null).orElse(this.defaultMediaType);
    }

    @Context
    public void setApplication(Application application) {
        this.openApi = this.extension.getOrCreateOpenAPI(application);
    }

    public void setDefaultMediaType(MediaType defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }
}

