/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb;

import jakarta.ejb.ApplicationException;
import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBLocalHome;
import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EJBObject;
import jakarta.ejb.EntityBean;
import jakarta.ejb.Handle;
import jakarta.ejb.Lock;
import jakarta.ejb.LockType;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.SessionBean;
import jakarta.ejb.TimedObject;
import jakarta.ejb.Timer;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.SynchronizationType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.naming.Context;
import org.apache.openejb.BeanType;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentContext;
import org.apache.openejb.Injection;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.MethodContext;
import org.apache.openejb.ModuleContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.SystemException;
import org.apache.openejb.assembler.classic.ProxyInterfaceResolver;
import org.apache.openejb.cdi.CdiEjbBean;
import org.apache.openejb.cdi.ConstructorInjectionBean;
import org.apache.openejb.cdi.CurrentCreationalContext;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.InstanceContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.cmp.KeyGenerator;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorInstance;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.ivm.ContextHandler;
import org.apache.openejb.core.ivm.EjbHomeProxyHandler;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.transaction.TransactionPolicyFactory;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.Index;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.proxy.DynamicProxyImplFactory;
import org.apache.openejb.util.proxy.LocalBeanProxyFactory;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.component.CdiInterceptorBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.context.creational.DependentCreationalContext;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.intercept.DecoratorHandler;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.portable.InjectionTargetImpl;
import org.apache.webbeans.proxy.InterceptorDecoratorProxyFactory;
import org.apache.webbeans.proxy.InterceptorHandler;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.xbean.recipe.ConstructionException;

public class BeanContext
extends DeploymentContext {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, BeanContext.class);
    public static final String USER_INTERCEPTOR_KEY = "org.apache.openejb.default.system.interceptors";
    public static final String USER_INTERCEPTOR_SEPARATOR = ",| |;";
    private static final Field DEPENDENTS_OBJECTS;
    private ConstructorInjectionBean<Object> constructorInjectionBean;
    private final boolean passivable;
    private final ModuleContext moduleContext;
    private final Context jndiContext;
    private Object containerData;
    private boolean destroyed;
    private final Class beanClass;
    private final List<Class> businessLocals = new ArrayList<Class>();
    private final List<Class> businessRemotes = new ArrayList<Class>();
    private Class serviceEndpointInterface;
    private Method ejbTimeout;
    private EjbTimerService ejbTimerService;
    private boolean isBeanManagedTransaction;
    private boolean isBeanManagedConcurrency;
    private Container container;
    private String ejbName;
    private String runAs;
    private String runAsUser;
    private final BeanType componentType;
    private boolean hidden;
    private final Map<Method, Method> methodMap = new HashMap<Method, Method>();
    private final Map<Method, MethodContext> methodContextMap = new HashMap<Method, MethodContext>();
    private final Map<String, ViewContext> viewContextMap = new HashMap<String, ViewContext>();
    private TransactionPolicyFactory transactionPolicyFactory;
    private final List<InterceptorData> callbackInterceptors = new ArrayList<InterceptorData>();
    private final List<InterceptorData> beanCallbackInterceptors = new ArrayList<InterceptorData>();
    private final Set<InterceptorData> instanceScopedInterceptors = new HashSet<InterceptorData>();
    private final List<InterceptorInstance> systemInterceptors = new ArrayList<InterceptorInstance>();
    private final List<InterceptorInstance> userInterceptors = new ArrayList<InterceptorInstance>();
    private final List<Injection> injections = new ArrayList<Injection>();
    private final Map<Class, InterfaceType> interfaces = new HashMap<Class, InterfaceType>();
    private final Map<Class, ExceptionType> exceptions = new ConcurrentHashMap<Class, ExceptionType>();
    private final boolean localbean;
    private Duration accessTimeout;
    private final Set<Class<?>> asynchronousClasses = new HashSet();
    private final Set<String> asynchronousMethodSignatures = new HashSet<String>();
    private Class<?> proxyClass;
    private Mdb mdb;
    private Singleton singleton;
    private Stateful stateful;
    private Cmp cmp;
    private LegacyView legacyView;
    private final Map<String, String> securityRoleReferences = new HashMap<String, String>();
    private final Map<Method, Boolean> removeExceptionPolicy = new HashMap<Method, Boolean>();
    private final Set<InterceptorData> cdiInterceptors = new LinkedHashSet<InterceptorData>();

    public boolean isDynamicallyImplemented() {
        return this.proxyClass != null;
    }

    public void mergeOWBAndOpenEJBInfo() {
        InterceptorData data;
        InterceptorData interceptorData;
        CdiEjbBean cdiEjbBean = this.get(CdiEjbBean.class);
        if (cdiEjbBean == null) {
            return;
        }
        InjectionTargetImpl injectionTarget = (InjectionTargetImpl)InjectionTargetImpl.class.cast(this.get(CdiEjbBean.class).getInjectionTarget());
        InterceptorResolutionService.BeanInterceptorInfo info = injectionTarget.getInterceptorInfo();
        if (info == null) {
            return;
        }
        Collection postConstructInterceptors = (Collection)Collection.class.cast(Reflections.get(injectionTarget, "postConstructInterceptors"));
        Collection preDestroyInterceptors = (Collection)Collection.class.cast(Reflections.get(injectionTarget, "preDestroyInterceptors"));
        if (postConstructInterceptors != null) {
            for (Interceptor interceptor : postConstructInterceptors) {
                if (this.isEjbInterceptor(interceptor)) continue;
                interceptorData = this.createInterceptorData(interceptor);
                this.instanceScopedInterceptors.add(interceptorData);
                this.cdiInterceptors.add(interceptorData);
            }
        }
        if (preDestroyInterceptors != null) {
            for (Interceptor interceptor : preDestroyInterceptors) {
                if (this.isEjbInterceptor(interceptor) || postConstructInterceptors.contains(interceptor)) continue;
                interceptorData = this.createInterceptorData(interceptor);
                this.instanceScopedInterceptors.add(interceptorData);
                this.cdiInterceptors.add(interceptorData);
            }
        }
        for (Map.Entry entry : info.getBusinessMethodsInfo().entrySet()) {
            Interceptor[] interceptors = ((InterceptorResolutionService.BusinessMethodInterceptorInfo)entry.getValue()).getCdiInterceptors();
            if (interceptors == null) continue;
            for (Interceptor i : interceptors) {
                if (postConstructInterceptors.contains(i) || preDestroyInterceptors.contains(i)) continue;
                data = this.createInterceptorData(i);
                this.addCdiMethodInterceptor((Method)entry.getKey(), data);
            }
            ((InterceptorResolutionService.BusinessMethodInterceptorInfo)entry.getValue()).setEjbInterceptors(new ArrayList());
            ((InterceptorResolutionService.BusinessMethodInterceptorInfo)entry.getValue()).setCdiInterceptors(new ArrayList());
        }
        if (info.getSelfInterceptorBean() != null) {
            try {
                Field field = InterceptorResolutionService.BeanInterceptorInfo.class.getDeclaredField("selfInterceptorBean");
                field.setAccessible(true);
                field.set(info, null);
            }
            catch (Exception field) {
                // empty catch block
            }
        }
        ((Map)Map.class.cast(Reflections.get(injectionTarget, "methodInterceptors"))).clear();
        BeanContext.clear((Collection)Collection.class.cast(postConstructInterceptors));
        BeanContext.clear((Collection)Collection.class.cast(preDestroyInterceptors));
        BeanContext.clear((Collection)Collection.class.cast(Reflections.get(injectionTarget, "postConstructMethods")));
        BeanContext.clear((Collection)Collection.class.cast(Reflections.get(injectionTarget, "preDestroyMethods")));
        BeanContext.clear((Collection)Collection.class.cast(Reflections.get(info, "ejbInterceptors")));
        BeanContext.clear((Collection)Collection.class.cast(Reflections.get(info, "cdiInterceptors")));
        Method timeout = this.getEjbTimeout();
        if (timeout != null) {
            AnnotatedType annotatedType = cdiEjbBean.getAnnotatedType();
            AnnotationManager annotationManager = this.getWebBeansContext().getAnnotationManager();
            HashSet annotations = new HashSet(annotationManager.getInterceptorAnnotations(annotatedType.getAnnotations()));
            Set methods = annotatedType.getMethods();
            for (AnnotatedMethod m : methods) {
                if (!timeout.equals(m.getJavaMember())) continue;
                annotations.addAll(annotationManager.getInterceptorAnnotations(m.getAnnotations()));
                break;
            }
            if (!annotations.isEmpty()) {
                for (Interceptor timeoutInterceptor : this.getWebBeansContext().getBeanManagerImpl().resolveInterceptors(InterceptionType.AROUND_TIMEOUT, AnnotationUtil.asArray(annotations))) {
                    if (this.isEjbInterceptor(timeoutInterceptor)) continue;
                    data = this.createInterceptorData(timeoutInterceptor);
                    this.addCdiMethodInterceptor(timeout, data);
                }
            }
        }
    }

    private boolean isEjbInterceptor(Interceptor<?> pc) {
        Set interceptorBindings = pc.getInterceptorBindings();
        return interceptorBindings == null || interceptorBindings.isEmpty();
    }

    private InterceptorData createInterceptorData(Interceptor<?> i) {
        InterceptorData data;
        if (CdiInterceptorBean.class.isInstance(i)) {
            CdiInterceptorBean cdiInterceptorBean = (CdiInterceptorBean)CdiInterceptorBean.class.cast(i);
            data = new InterceptorData(cdiInterceptorBean);
        } else {
            data = InterceptorData.scan(i.getBeanClass());
        }
        return data;
    }

    private static void clear(Collection<?> c) {
        if (c != null) {
            c.clear();
        }
    }

    public Class getInterface(InterfaceType interfaceType) {
        switch (interfaceType) {
            case EJB_HOME: {
                return this.getHomeInterface();
            }
            case EJB_OBJECT: {
                return this.getRemoteInterface();
            }
            case EJB_LOCAL_HOME: {
                return this.getLocalHomeInterface();
            }
            case EJB_LOCAL: {
                return this.getLocalInterface();
            }
            case BUSINESS_LOCAL: {
                return this.getBusinessLocalInterface();
            }
            case BUSINESS_REMOTE: {
                return this.getBusinessRemoteInterface();
            }
            case TIMEOUT: {
                return Timeout.class;
            }
            case BUSINESS_REMOTE_HOME: {
                return BusinessRemoteHome.class;
            }
            case BUSINESS_LOCAL_HOME: {
                return BusinessLocalHome.class;
            }
            case SERVICE_ENDPOINT: {
                return this.getServiceEndpointInterface();
            }
            case LOCALBEAN: {
                return this.getBeanClass();
            }
            case BUSINESS_LOCALBEAN_HOME: {
                return BusinessLocalBeanHome.class;
            }
        }
        throw new IllegalStateException("Unexpected enum constant: " + (Object)((Object)interfaceType));
    }

    public List<Class> getInterfaces(InterfaceType interfaceType) {
        switch (interfaceType) {
            case BUSINESS_REMOTE: {
                return this.getBusinessRemoteInterfaces();
            }
            case BUSINESS_LOCAL: {
                return this.getBusinessLocalInterfaces();
            }
        }
        ArrayList<Class> interfaces = new ArrayList<Class>();
        interfaces.add(this.getInterface(interfaceType));
        return interfaces;
    }

    public InterfaceType getInterfaceType(Class clazz) {
        InterfaceType type = this.interfaces.get(clazz);
        if (type != null) {
            return type;
        }
        if (EJBLocalHome.class.isAssignableFrom(clazz)) {
            return InterfaceType.EJB_LOCAL_HOME;
        }
        if (EJBLocalObject.class.isAssignableFrom(clazz)) {
            return InterfaceType.EJB_LOCAL;
        }
        if (EJBHome.class.isAssignableFrom(clazz)) {
            return InterfaceType.EJB_HOME;
        }
        if (EJBObject.class.isAssignableFrom(clazz)) {
            return InterfaceType.EJB_OBJECT;
        }
        for (Map.Entry<Class, InterfaceType> entry : this.interfaces.entrySet()) {
            if (!entry.getKey().getName().equals(clazz.getName())) continue;
            return entry.getValue();
        }
        return null;
    }

    private BeanContext(String id, Context jndiContext, ModuleContext moduleContext, BeanType componentType, boolean localBean, Class beanClass, boolean passivable) {
        super(id, moduleContext.getOptions());
        if (beanClass == null) {
            throw new NullPointerException("beanClass input parameter is null");
        }
        this.moduleContext = moduleContext;
        this.jndiContext = new ContextHandler(jndiContext);
        this.localbean = localBean;
        this.componentType = componentType;
        this.beanClass = beanClass;
        this.passivable = passivable;
        String interceptors = SystemInstance.get().getProperties().getProperty(USER_INTERCEPTOR_KEY);
        if (interceptors != null) {
            String[] interceptorArray = interceptors.split(USER_INTERCEPTOR_SEPARATOR);
            ClassLoader classLoader = moduleContext.getClassLoader();
            for (String interceptor : interceptorArray) {
                Object interceptorObject;
                if (interceptor == null || interceptor.isEmpty()) continue;
                try {
                    Class<?> clazz = classLoader.loadClass(interceptor);
                    interceptorObject = clazz.newInstance();
                }
                catch (Exception e) {
                    logger.warning("interceptor " + interceptor + " not found, are you sure the container can load it?");
                    continue;
                }
                this.addUserInterceptor(interceptorObject);
            }
        }
    }

    public BeanContext(String id, Context jndiContext, ModuleContext moduleContext, Class beanClass, Class homeInterface, Class remoteInterface, Class localHomeInterface, Class localInterface, Class proxy, Class serviceEndpointInterface, List<Class> businessLocals, List<Class> businessRemotes, Class pkClass, BeanType componentType, boolean localBean, boolean passivable) throws SystemException {
        this(id, jndiContext, moduleContext, componentType, localBean, beanClass, passivable);
        this.proxyClass = proxy;
        if (homeInterface != null) {
            this.getLegacyView().homeInterface = homeInterface;
        }
        if (localInterface != null) {
            this.getLegacyView().localInterface = localInterface;
        }
        if (localHomeInterface != null) {
            this.getLegacyView().localHomeInterface = localHomeInterface;
        }
        if (remoteInterface != null) {
            this.getLegacyView().remoteInterface = remoteInterface;
        }
        if (businessLocals != null) {
            this.businessLocals.addAll(businessLocals);
        }
        if (businessRemotes != null) {
            this.businessRemotes.addAll(businessRemotes);
        }
        if (pkClass != null) {
            this.getCmp().pkClass = pkClass;
        }
        this.serviceEndpointInterface = serviceEndpointInterface;
        if (TimedObject.class.isAssignableFrom(beanClass)) {
            try {
                this.ejbTimeout = beanClass.getMethod("ejbTimeout", Timer.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
        this.addInterface(this.getServiceEndpointInterface(), InterfaceType.SERVICE_ENDPOINT);
        this.addInterface(EJBHome.class, InterfaceType.EJB_HOME);
        this.addInterface(EJBObject.class, InterfaceType.EJB_OBJECT);
        this.addInterface(EJBLocalHome.class, InterfaceType.EJB_LOCAL_HOME);
        this.addInterface(EJBLocalObject.class, InterfaceType.EJB_LOCAL);
        this.addInterface(this.getHomeInterface(), InterfaceType.EJB_HOME);
        this.addInterface(this.getRemoteInterface(), InterfaceType.EJB_OBJECT);
        this.addInterface(this.getLocalHomeInterface(), InterfaceType.EJB_LOCAL_HOME);
        this.addInterface(this.getLocalInterface(), InterfaceType.EJB_LOCAL);
        this.addInterface(BusinessRemoteHome.class, InterfaceType.BUSINESS_REMOTE_HOME);
        for (Class businessRemote : this.businessRemotes) {
            this.addInterface(businessRemote, InterfaceType.BUSINESS_REMOTE);
        }
        this.addInterface(BusinessLocalHome.class, InterfaceType.BUSINESS_LOCAL_HOME);
        for (Class businessLocal : this.businessLocals) {
            this.addInterface(businessLocal, InterfaceType.BUSINESS_LOCAL);
        }
        if (localBean) {
            this.addInterface(beanClass, InterfaceType.LOCALBEAN);
        }
        this.initDefaultLock();
    }

    private LegacyView getLegacyView() {
        if (this.legacyView == null) {
            this.legacyView = new LegacyView();
        }
        return this.legacyView;
    }

    private Mdb getMdb() {
        if (this.mdb == null) {
            this.mdb = new Mdb();
        }
        return this.mdb;
    }

    private Singleton getSingleton() {
        if (this.singleton == null) {
            this.singleton = new Singleton();
        }
        return this.singleton;
    }

    private Stateful getStateful() {
        if (this.stateful == null) {
            this.stateful = new Stateful();
        }
        return this.stateful;
    }

    private Cmp getCmp() {
        if (this.cmp == null) {
            this.cmp = new Cmp();
        }
        return this.cmp;
    }

    private void addInterface(Class interfce, InterfaceType type) {
        if (interfce == null) {
            return;
        }
        this.interfaces.put(interfce, type);
        for (Class<?> clazz : interfce.getInterfaces()) {
            this.addInterface(clazz, type);
        }
    }

    public void addApplicationException(Class exception, boolean rollback, boolean inherited) {
        if (inherited) {
            if (rollback) {
                this.exceptions.put(exception, ExceptionType.APPLICATION_ROLLBACK);
            } else {
                this.exceptions.put(exception, ExceptionType.APPLICATION);
            }
        } else if (rollback) {
            this.exceptions.put(exception, ExceptionType.APPLICATION_ROLLBACK_NOT_INHERITED);
        } else {
            this.exceptions.put(exception, ExceptionType.APPLICATION_NOT_INHERITED);
        }
    }

    public ExceptionType getExceptionType(Throwable e) {
        if (!(e instanceof Exception)) {
            return ExceptionType.SYSTEM;
        }
        boolean inherited = false;
        for (Class<?> exceptionClass = e.getClass(); exceptionClass != Object.class; exceptionClass = exceptionClass.getSuperclass()) {
            ExceptionType type = this.exceptions.get(exceptionClass);
            if (type == ExceptionType.APPLICATION || type == ExceptionType.APPLICATION_ROLLBACK) {
                return type;
            }
            if (type != null) {
                if (inherited) {
                    return ExceptionType.SYSTEM;
                }
                if (type == ExceptionType.APPLICATION_NOT_INHERITED) {
                    return ExceptionType.APPLICATION;
                }
                return ExceptionType.APPLICATION_ROLLBACK;
            }
            inherited = true;
        }
        Class<?> eClass = e.getClass();
        ApplicationException applicationException = eClass.getAnnotation(ApplicationException.class);
        if (applicationException != null) {
            this.addApplicationException(eClass, applicationException.rollback(), applicationException.inherited());
            return this.getExceptionType(e);
        }
        if (e instanceof RuntimeException) {
            return ExceptionType.SYSTEM;
        }
        return ExceptionType.APPLICATION;
    }

    public BeanContext(String id, Context jndiContext, ModuleContext moduleContext, Class beanClass, Class mdbInterface, Map<String, String> activationProperties) throws SystemException {
        this(id, jndiContext, moduleContext, BeanType.MESSAGE_DRIVEN, false, beanClass, false);
        this.getMdb().mdbInterface = mdbInterface;
        this.getMdb().activationProperties.putAll(activationProperties);
        if (TimedObject.class.isAssignableFrom(beanClass)) {
            try {
                this.ejbTimeout = beanClass.getMethod("ejbTimeout", Timer.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
        this.initDefaultLock();
        this.createMethodMap();
    }

    private void initDefaultLock() {
        if (!BeanType.SINGLETON.equals((Object)this.componentType)) {
            return;
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.addAll(this.businessRemotes);
        classes.addAll(this.businessLocals);
        classes.add(this.beanClass);
        for (Class c : classes) {
            Lock lock = null;
            try {
                lock = c.getAnnotation(Lock.class);
                this.getSingleton().lockType = lock.value();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Declared Lock for " + c.getName() + " is " + this.getSingleton().lockType);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Throwable e) {
                logger.warning("Failed to determine from: " + lock);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Default Lock for " + this.beanClass.getName() + " is " + this.getSingleton().lockType);
        }
    }

    public Object getContainerData() {
        return this.containerData;
    }

    public void setContainerData(Object containerData) {
        this.containerData = containerData;
    }

    public ClassLoader getClassLoader() {
        return this.moduleContext.getClassLoader();
    }

    public Context getJndiContext() {
        return this.jndiContext;
    }

    public ModuleContext getModuleContext() {
        return this.moduleContext;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    public List<Injection> getInjections() {
        return this.injections;
    }

    public Index<EntityManagerFactory, EntityManagerConfiguration> getExtendedEntityManagerFactories() {
        return this.getStateful().extendedEntityManagerFactories;
    }

    public void setExtendedEntityManagerFactories(Index<EntityManagerFactory, EntityManagerConfiguration> extendedEntityManagerFactories) {
        this.getStateful().extendedEntityManagerFactories = extendedEntityManagerFactories;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public BeanType getComponentType() {
        return this.componentType;
    }

    public LockType getConcurrencyAttribute(Method beanMethod) {
        return this.getMethodContext(beanMethod).getLockType();
    }

    public LockType getLockType() {
        return this.getSingleton().lockType;
    }

    public TransactionType getTransactionType(Method method) {
        return this.getTransactionType(method, null);
    }

    public TransactionType getTransactionType(Method method, InterfaceType interfaceType) {
        MethodContext methodContext = null;
        if (interfaceType != null) {
            methodContext = this.getViewMethodContext(method, interfaceType.getSpecName());
        }
        if (methodContext == null) {
            methodContext = this.methodContextMap.get(method);
        }
        if (methodContext == null) {
            Method beanMethod = this.getMatchingBeanMethod(method);
            methodContext = this.getMethodContext(beanMethod);
        }
        return methodContext.getTransactionType();
    }

    public TransactionType getTransactionType() {
        return this.isBeanManagedTransaction ? TransactionType.BeanManaged : TransactionType.Required;
    }

    public TransactionPolicyFactory getTransactionPolicyFactory() {
        return this.transactionPolicyFactory;
    }

    public void setTransactionPolicyFactory(TransactionPolicyFactory transactionPolicyFactory) {
        this.transactionPolicyFactory = transactionPolicyFactory;
    }

    public Container getContainer() {
        return this.container;
    }

    public Object getDeploymentID() {
        return this.getId();
    }

    public boolean isBeanManagedTransaction() {
        return this.isBeanManagedTransaction;
    }

    public boolean isBeanManagedConcurrency() {
        return this.isBeanManagedConcurrency;
    }

    public Class getHomeInterface() {
        return this.legacyView == null ? null : this.getLegacyView().homeInterface;
    }

    public Class getRemoteInterface() {
        return this.legacyView == null ? null : this.getLegacyView().remoteInterface;
    }

    public Class getLocalHomeInterface() {
        return this.legacyView == null ? null : this.getLegacyView().localHomeInterface;
    }

    public Class getLocalInterface() {
        return this.legacyView == null ? null : this.getLegacyView().localInterface;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public Class getBusinessLocalInterface() {
        return this.businessLocals.size() > 0 ? this.businessLocals.get(0) : null;
    }

    public Class getBusinessRemoteInterface() {
        return this.businessRemotes.size() > 0 ? this.businessRemotes.get(0) : null;
    }

    public List<Class> getBusinessLocalInterfaces() {
        return this.businessLocals;
    }

    public List<Class> getBusinessRemoteInterfaces() {
        return this.businessRemotes;
    }

    public Class getMdbInterface() {
        return this.mdb == null ? null : this.getMdb().mdbInterface;
    }

    public Class getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public Map<String, String> getActivationProperties() {
        return this.getMdb().activationProperties;
    }

    public Class getPrimaryKeyClass() {
        return this.cmp == null ? null : this.cmp.pkClass;
    }

    public EJBHome getEJBHome() {
        if (this.getHomeInterface() == null) {
            throw new IllegalStateException("This component has no home interface: " + this.getDeploymentID());
        }
        if (this.getLegacyView().ejbHomeRef == null) {
            this.getLegacyView().ejbHomeRef = (EJBHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.EJB_HOME);
        }
        return this.getLegacyView().ejbHomeRef;
    }

    public EJBLocalHome getEJBLocalHome() {
        if (this.getLocalHomeInterface() == null) {
            throw new IllegalStateException("This component has no local home interface: " + this.getDeploymentID());
        }
        if (this.getLegacyView().ejbLocalHomeRef == null) {
            this.getLegacyView().ejbLocalHomeRef = (EJBLocalHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.EJB_LOCAL_HOME);
        }
        return this.getLegacyView().ejbLocalHomeRef;
    }

    public BusinessLocalHome getBusinessLocalHome() {
        return this.getBusinessLocalHome(this.getBusinessLocalInterfaces(), null);
    }

    public BusinessLocalBeanHome getBusinessLocalBeanHome() {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        interfaces.add(this.beanClass);
        return (BusinessLocalBeanHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.BUSINESS_LOCALBEAN_HOME, interfaces, this.beanClass);
    }

    public BusinessLocalHome getBusinessLocalHome(Class mainInterface) {
        List<Class> localInterfaces = this.getBusinessLocalInterfaces();
        List<Class> interfaces = ProxyInterfaceResolver.getInterfaces(this.getBeanClass(), mainInterface, localInterfaces);
        return this.getBusinessLocalHome(interfaces, mainInterface);
    }

    public BusinessLocalHome getBusinessLocalHome(List<Class> interfaces, Class mainInterface) {
        if (this.getBusinessLocalInterfaces().size() == 0) {
            throw new IllegalStateException("This component has no business local interfaces: " + this.getDeploymentID());
        }
        if (interfaces.size() == 0) {
            throw new IllegalArgumentException("No interface classes were specified");
        }
        for (Class clazz : interfaces) {
            if (this.getBusinessLocalInterfaces().contains(clazz) || this.getBusinessRemoteInterfaces().contains(clazz)) continue;
            throw new IllegalArgumentException("Not a business interface of this bean:" + clazz.getName());
        }
        return (BusinessLocalHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.BUSINESS_LOCAL_HOME, interfaces, mainInterface);
    }

    public BusinessRemoteHome getBusinessRemoteHome() {
        return this.getBusinessRemoteHome(this.getBusinessRemoteInterfaces(), null);
    }

    public BusinessRemoteHome getBusinessRemoteHome(Class mainInterface) {
        List<Class> remoteInterfaces = this.getBusinessRemoteInterfaces();
        List<Class> interfaces = ProxyInterfaceResolver.getInterfaces(this.getBeanClass(), mainInterface, remoteInterfaces);
        return this.getBusinessRemoteHome(interfaces, mainInterface);
    }

    public BusinessRemoteHome getBusinessRemoteHome(List<Class> interfaces, Class mainInterface) {
        if (this.getBusinessRemoteInterfaces().size() == 0) {
            throw new IllegalStateException("This component has no business remote interfaces: " + this.getDeploymentID());
        }
        if (interfaces.size() == 0) {
            throw new IllegalArgumentException("No interface classes were specified");
        }
        for (Class clazz : interfaces) {
            if (this.getBusinessRemoteInterfaces().contains(clazz)) continue;
            throw new IllegalArgumentException("Not a business interface of this bean:" + clazz.getName());
        }
        return (BusinessRemoteHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.BUSINESS_REMOTE_HOME, interfaces, mainInterface);
    }

    public String getDestinationId() {
        return this.getMdb().destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.getMdb().destinationId = destinationId;
    }

    public void setBeanManagedTransaction(boolean value) {
        this.isBeanManagedTransaction = value;
    }

    public void setBeanManagedConcurrency(boolean beanManagedConcurrency) {
        this.isBeanManagedConcurrency = beanManagedConcurrency;
    }

    public Context getJndiEnc() {
        return this.jndiContext;
    }

    public boolean isReentrant() {
        return this.getCmp().isReentrant;
    }

    public void setIsReentrant(boolean reentrant) {
        this.getCmp().isReentrant = reentrant;
    }

    public Method getMatchingBeanMethod(Method interfaceMethod) {
        Method method = this.methodMap.get(interfaceMethod);
        return method == null ? interfaceMethod : method;
    }

    public MethodContext getMethodContext(Method method) {
        MethodContext methodContext = this.methodContextMap.get(method);
        if (methodContext == null) {
            methodContext = new MethodContext(this, method);
            this.methodContextMap.put(method, methodContext);
        }
        return methodContext;
    }

    public Iterator<Map.Entry<Method, MethodContext>> iteratorMethodContext() {
        return this.methodContextMap.entrySet().iterator();
    }

    public void setMethodConcurrencyAttribute(Method method, LockType concurrencyAttribute) {
        this.getMethodContext(method).setLockType(concurrencyAttribute);
    }

    public void setMethodTransactionAttribute(Method method, TransactionType transactionType) throws OpenEJBException {
        this.setMethodTransactionAttribute(method, transactionType, null);
    }

    public void setMethodTransactionAttribute(Method method, TransactionType transactionType, String view) throws OpenEJBException {
        if (view == null) {
            this.getMethodContext(method).setTransactionType(transactionType);
        } else {
            this.initViewMethodContext(method, view).setTransactionType(transactionType);
        }
    }

    public List<Method> getRemoveMethods() {
        return this.getStateful().removeMethods;
    }

    public void setRetainIfExeption(Method removeMethod, boolean retain) {
        if (this.getRemoveMethods().contains(removeMethod)) {
            this.removeExceptionPolicy.put(removeMethod, retain);
        }
    }

    public boolean retainIfExeption(Method removeMethod) {
        Boolean retain = this.removeExceptionPolicy.get(removeMethod);
        return retain != null && retain != false;
    }

    public Set<InterceptorData> getInstanceScopedInterceptors() {
        return this.instanceScopedInterceptors;
    }

    public void addSystemInterceptor(Object interceptor) {
        this.systemInterceptors.add(new InterceptorInstance(interceptor));
    }

    public void addFirstSystemInterceptor(Object interceptor) {
        this.systemInterceptors.add(0, new InterceptorInstance(interceptor));
    }

    public void addUserInterceptor(Object interceptor) {
        this.userInterceptors.add(new InterceptorInstance(interceptor));
    }

    public List<InterceptorInstance> getUserAndSystemInterceptors() {
        ArrayList<InterceptorInstance> interceptors = new ArrayList<InterceptorInstance>(this.systemInterceptors);
        interceptors.addAll(this.userInterceptors);
        return interceptors;
    }

    public List<InterceptorData> getCallbackInterceptors() {
        List<InterceptorData> datas = this.getInterceptorData();
        datas.addAll(this.callbackInterceptors);
        datas.addAll(this.cdiInterceptors);
        datas.addAll(this.beanCallbackInterceptors);
        return datas;
    }

    public void setCallbackInterceptors(List<InterceptorData> callbackInterceptors) {
        this.beanCallbackInterceptors.clear();
        this.callbackInterceptors.clear();
        for (InterceptorData data : callbackInterceptors) {
            if (data.getInterceptorClass().isAssignableFrom(this.getManagedClass())) {
                this.beanCallbackInterceptors.add(data);
                continue;
            }
            this.callbackInterceptors.add(data);
        }
        this.instanceScopedInterceptors.addAll(callbackInterceptors);
    }

    public List<InterceptorData> getCdiInterceptors() {
        return new ArrayList<InterceptorData>(this.cdiInterceptors);
    }

    public void setCdiInterceptors(List<InterceptorData> cdiInterceptors) {
        this.cdiInterceptors.clear();
        this.cdiInterceptors.addAll(cdiInterceptors);
        this.instanceScopedInterceptors.addAll(cdiInterceptors);
    }

    public List<InterceptorData> getMethodInterceptors(Method method) {
        return this.getMethodContext(method).getInterceptors();
    }

    public List<InterceptorData> getInterceptorData() {
        ArrayList<InterceptorData> datas = new ArrayList<InterceptorData>(this.getUserAndSystemInterceptors().size());
        for (InterceptorInstance instance : this.getUserAndSystemInterceptors()) {
            datas.add(instance.getData());
        }
        return datas;
    }

    public void addCdiMethodInterceptor(Method method, InterceptorData interceptor) {
        this.getMethodContext(method).addCdiInterceptor(interceptor);
        this.instanceScopedInterceptors.add(interceptor);
    }

    public void setMethodInterceptors(Method method, List<InterceptorData> interceptors) {
        this.getMethodContext(method).setInterceptors(interceptors);
        this.instanceScopedInterceptors.addAll(interceptors);
    }

    public void createMethodMap() throws SystemException {
        if (this.getRemoteInterface() != null) {
            this.mapObjectInterface(this.getLegacyView().remoteInterface);
            this.mapHomeInterface(this.getLegacyView().homeInterface);
        }
        if (this.getLocalInterface() != null) {
            this.mapObjectInterface(this.getLegacyView().localInterface);
        }
        if (this.getLocalHomeInterface() != null) {
            this.mapHomeInterface(this.getLegacyView().localHomeInterface);
        }
        if (this.serviceEndpointInterface != null) {
            this.mapObjectInterface(this.serviceEndpointInterface);
        }
        for (Class clazz : this.businessLocals) {
            this.mapObjectInterface(clazz);
        }
        for (Class clazz : this.businessRemotes) {
            this.mapObjectInterface(clazz);
        }
        if (this.componentType == BeanType.MESSAGE_DRIVEN && MessageDrivenBean.class.isAssignableFrom(this.beanClass)) {
            try {
                this.getLegacyView().createMethod = this.beanClass.getMethod("ejbCreate", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        try {
            Method beanMethod;
            if (this.componentType == BeanType.STATEFUL || this.componentType == BeanType.MANAGED) {
                beanMethod = null;
                if (SessionBean.class.isAssignableFrom(this.beanClass)) {
                    beanMethod = SessionBean.class.getDeclaredMethod("ejbRemove", new Class[0]);
                } else {
                    for (Method method : this.getRemoveMethods()) {
                        if (method.getParameterTypes().length != 0) continue;
                        beanMethod = method;
                        break;
                    }
                    if (beanMethod == null && (this.getHomeInterface() != null || this.getLocalHomeInterface() != null)) {
                        throw new IllegalStateException("Bean class has no @Remove methods to match EJBObject.remove() or EJBLocalObject.remove().  A no-arg remove method must be added: beanClass=" + this.beanClass.getName());
                    }
                }
                Method method = EJBHome.class.getDeclaredMethod("remove", Handle.class);
                this.mapMethods(method, beanMethod);
                Method method2 = EJBHome.class.getDeclaredMethod("remove", Object.class);
                this.mapMethods(method2, beanMethod);
                Method method3 = EJBObject.class.getDeclaredMethod("remove", new Class[0]);
                this.mapMethods(method3, beanMethod);
                Method method4 = EJBLocalObject.class.getDeclaredMethod("remove", new Class[0]);
                this.mapMethods(method4, beanMethod);
            } else if (this.componentType == BeanType.BMP_ENTITY || this.componentType == BeanType.CMP_ENTITY) {
                beanMethod = EntityBean.class.getDeclaredMethod("ejbRemove", new Class[0]);
                Method method = EJBHome.class.getDeclaredMethod("remove", Handle.class);
                this.mapMethods(method, beanMethod);
                Method method5 = EJBHome.class.getDeclaredMethod("remove", Object.class);
                this.mapMethods(method5, beanMethod);
                Method method6 = EJBObject.class.getDeclaredMethod("remove", new Class[0]);
                this.mapMethods(method6, beanMethod);
                Method method7 = EJBLocalObject.class.getDeclaredMethod("remove", new Class[0]);
                this.mapMethods(method7, beanMethod);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new SystemException(nsme);
        }
        if (this.mdb != null && this.mdb.mdbInterface != null) {
            this.mapObjectInterface(this.getMdb().mdbInterface);
        }
    }

    private void mapHomeInterface(Class intrface) {
        Method[] homeMethods;
        for (Method method : homeMethods = intrface.getMethods()) {
            Class<?> owner = method.getDeclaringClass();
            if (owner == EJBHome.class || owner == EJBLocalHome.class) continue;
            try {
                String beanMethodName;
                Method beanMethod = null;
                if (method.getName().startsWith("create")) {
                    StringBuilder ejbCreateName = new StringBuilder(method.getName());
                    ejbCreateName.replace(0, 1, "ejbC");
                    beanMethod = this.beanClass.getMethod(ejbCreateName.toString(), method.getParameterTypes());
                    this.getLegacyView().createMethod = beanMethod;
                    if (this.componentType == BeanType.BMP_ENTITY || this.componentType == BeanType.CMP_ENTITY) {
                        ejbCreateName.insert(3, "Post");
                        Class clazz = this.beanClass;
                        if (this.getCmp().cmpImplClass != null) {
                            clazz = this.getCmp().cmpImplClass;
                        }
                        Method postCreateMethod = clazz.getMethod(ejbCreateName.toString(), method.getParameterTypes());
                        this.getCmp().postCreateMethodMap.put(this.getLegacyView().createMethod, postCreateMethod);
                    }
                } else if (method.getName().startsWith("find")) {
                    if (this.componentType == BeanType.BMP_ENTITY) {
                        beanMethodName = "ejbF" + method.getName().substring(1);
                        beanMethod = this.beanClass.getMethod(beanMethodName, method.getParameterTypes());
                    }
                } else {
                    beanMethodName = "ejbHome" + method.getName().substring(0, 1).toUpperCase() + method.getName().substring(1);
                    beanMethod = this.beanClass.getMethod(beanMethodName, method.getParameterTypes());
                }
                if (beanMethod == null) continue;
                this.mapMethods(method, beanMethod);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public void mapMethods(Method interfaceMethod, Method beanMethod) {
        this.methodMap.put(interfaceMethod, beanMethod);
    }

    private void mapObjectInterface(Class intrface) {
        Method[] interfaceMethods;
        if (intrface == BusinessLocalHome.class || intrface == BusinessRemoteHome.class || intrface == ServiceEndpoint.class) {
            return;
        }
        for (Method method : interfaceMethods = intrface.getMethods()) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == EJBObject.class || declaringClass == EJBLocalObject.class) continue;
            try {
                Method beanMethod = this.beanClass.getMethod(method.getName(), method.getParameterTypes());
                this.mapMethods(method, beanMethod);
            }
            catch (NoSuchMethodException nsme) {
                throw new OpenEJBRuntimeException("Invalid method [" + method + "]. Not declared by " + this.beanClass.getName() + " class");
            }
        }
    }

    public List<Class> getObjectInterface(Class homeInterface) {
        if (BusinessLocalHome.class.isAssignableFrom(homeInterface)) {
            return this.getBusinessLocalInterfaces();
        }
        if (BusinessRemoteHome.class.isAssignableFrom(homeInterface)) {
            return this.getBusinessRemoteInterfaces();
        }
        if (EJBLocalHome.class.isAssignableFrom(homeInterface)) {
            ArrayList<Class> classes = new ArrayList<Class>();
            classes.add(this.getLocalInterface());
            return classes;
        }
        if (EJBHome.class.isAssignableFrom(homeInterface)) {
            ArrayList<Class> classes = new ArrayList<Class>();
            classes.add(this.getRemoteInterface());
            return classes;
        }
        throw new IllegalArgumentException("Cannot determine object interface for " + homeInterface);
    }

    public Method getCreateMethod() {
        return this.getLegacyView().createMethod;
    }

    public Method getMatchingPostCreateMethod(Method createMethod) {
        return (Method)this.getCmp().postCreateMethodMap.get(createMethod);
    }

    public boolean isAsynchronous(Method method) {
        Method matchingBeanMethod = this.getMatchingBeanMethod(method);
        Class<?> returnType = matchingBeanMethod.getReturnType();
        if (returnType != Void.TYPE && returnType != Future.class) {
            return false;
        }
        if (this.asynchronousClasses.contains(matchingBeanMethod.getDeclaringClass())) {
            return true;
        }
        MethodContext methodContext = this.methodContextMap.get(matchingBeanMethod);
        return methodContext != null && methodContext.isAsynchronous();
    }

    public boolean isCmp2() {
        return this.getCmp().cmp2;
    }

    public void setCmp2(boolean cmp2) {
        this.getCmp().cmp2 = cmp2;
    }

    public String getPrimaryKeyField() {
        return this.getCmp().primaryKeyField;
    }

    public void setPrimaryKeyField(String primaryKeyField) {
        this.getCmp().primaryKeyField = primaryKeyField;
    }

    public KeyGenerator getKeyGenerator() {
        return this.getCmp().keyGenerator;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.getCmp().keyGenerator = keyGenerator;
    }

    public void setRemoteQueryResults(String methodSignature) {
        this.getCmp().remoteQueryResults.add(methodSignature);
    }

    public boolean isRemoteQueryResults(String methodSignature) {
        return this.getCmp().remoteQueryResults.contains(methodSignature);
    }

    public Class getCmpImplClass() {
        return this.getCmp().cmpImplClass;
    }

    public void setCmpImplClass(Class cmpImplClass) {
        this.getCmp().cmpImplClass = cmpImplClass;
    }

    public String getAbstractSchemaName() {
        return this.getCmp().abstractSchemaName;
    }

    public void setAbstractSchemaName(String abstractSchemaName) {
        this.getCmp().abstractSchemaName = abstractSchemaName;
    }

    public Method getEjbTimeout() {
        return this.ejbTimeout;
    }

    public void setEjbTimeout(Method ejbTimeout) {
        this.ejbTimeout = ejbTimeout;
    }

    public EjbTimerService getEjbTimerService() {
        return this.ejbTimerService;
    }

    public void setEjbTimerService(EjbTimerService ejbTimerService) {
        this.ejbTimerService = ejbTimerService;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public String getModuleID() {
        return this.getModuleContext().getModuleURI().toString();
    }

    public String getModuleName() {
        return this.getModuleContext().getId();
    }

    public String getRunAs() {
        return this.runAs;
    }

    public String getRunAsUser() {
        return this.runAsUser;
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public void setRunAs(String runAs) {
        this.runAs = runAs;
        if (this.runAsUser == null) {
            this.runAsUser = runAs;
        }
    }

    public void setRunAsUser(String runAsUser) {
        if (runAsUser != null) {
            this.runAsUser = runAsUser;
        }
    }

    public String toString() {
        return "BeanContext(id=" + this.getDeploymentID() + ")";
    }

    public boolean isLoadOnStartup() {
        return this.getSingleton().loadOnStartup;
    }

    public void setLoadOnStartup(boolean loadOnStartup) {
        this.getSingleton().loadOnStartup = loadOnStartup;
    }

    public Set<String> getDependsOn() {
        return this.getSingleton().dependsOn;
    }

    public boolean isSessionSynchronized() {
        return !this.isBeanManagedTransaction();
    }

    public boolean isLocalbean() {
        return this.localbean;
    }

    public Class getBusinessLocalBeanInterface() {
        if (this.isLocalbean()) {
            return this.beanClass;
        }
        return null;
    }

    public Duration getAccessTimeout(Method beanMethod) {
        return this.getMethodContext(beanMethod).getAccessTimeout();
    }

    public Duration getAccessTimeout() {
        return this.accessTimeout;
    }

    public void setAccessTimeout(Duration accessTimeout) {
        this.accessTimeout = accessTimeout;
    }

    public Duration getStatefulTimeout() {
        return this.getStateful().statefulTimeout;
    }

    public void setStatefulTimeout(Duration statefulTimeout) {
        this.getStateful().statefulTimeout = statefulTimeout;
    }

    public Class<Object> getManagedClass() {
        if (this.isDynamicallyImplemented()) {
            return this.getProxyClass();
        }
        return this.beanClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InstanceContext newInstance() throws Exception {
        boolean dynamicallyImplemented = this.isDynamicallyImplemented();
        WebBeansContext webBeansContext = this.getWebBeansContext();
        if (dynamicallyImplemented && !InvocationHandler.class.isAssignableFrom(this.getProxyClass())) {
            throw new OpenEJBException("proxy class can only be InvocationHandler");
        }
        ThreadContext callContext = new ThreadContext(this, null, Operation.INJECTION);
        ThreadContext oldContext = ThreadContext.enter(callContext);
        try {
            InterceptorResolutionService.BeanInterceptorInfo interceptorInfo;
            Class proxyClass;
            TransactionType transactionType;
            InterceptorStack postConstruct;
            LinkedHashMap<String, Object> interceptorInstances;
            Object beanInstance;
            CdiEjbBean cdiEjbBean;
            CreationalContextImpl creationalContext;
            block47: {
                block46: {
                    InjectionProcessor<Object> injectionProcessor;
                    Context ctx = this.getJndiEnc();
                    Class beanClass = this.getBeanClass();
                    CurrentCreationalContext currentCreationalContext = this.get(CurrentCreationalContext.class);
                    creationalContext = currentCreationalContext != null ? currentCreationalContext.get() : null;
                    cdiEjbBean = this.get(CdiEjbBean.class);
                    if (!CreationalContextImpl.class.isInstance(creationalContext) && webBeansContext != null) {
                        creationalContext = creationalContext == null ? webBeansContext.getCreationalContextFactory().getCreationalContext((Contextual)cdiEjbBean) : webBeansContext.getCreationalContextFactory().wrappedCreationalContext((CreationalContext)creationalContext, (Contextual)cdiEjbBean);
                    }
                    Object rootInstance = cdiEjbBean != null && !dynamicallyImplemented && CdiEjbBean.EjbInjectionTargetImpl.class.isInstance(cdiEjbBean.getInjectionTarget()) ? ((CdiEjbBean.EjbInjectionTargetImpl)((Object)CdiEjbBean.EjbInjectionTargetImpl.class.cast(cdiEjbBean.getInjectionTarget()))).createNewPojo(creationalContext) : this.getManagedClass().newInstance();
                    if (!dynamicallyImplemented) {
                        injectionProcessor = new InjectionProcessor<Object>(rootInstance, this.getInjections(), InjectionProcessor.unwrap(ctx));
                        beanInstance = injectionProcessor.createInstance();
                        this.inject((Object)beanInstance, (CreationalContext)creationalContext);
                    } else {
                        ArrayList<Injection> newInjections = new ArrayList<Injection>();
                        for (Injection injection : this.getInjections()) {
                            if (beanClass.equals(injection.getTarget())) {
                                Injection updated = new Injection(injection.getJndiName(), injection.getName(), this.proxyClass);
                                newInjections.add(updated);
                                continue;
                            }
                            newInjections.add(injection);
                        }
                        this.injections.clear();
                        this.injections.addAll(newInjections);
                        injectionProcessor = new InjectionProcessor<Object>(rootInstance, this.injections, InjectionProcessor.unwrap(ctx));
                        InvocationHandler handler = (InvocationHandler)injectionProcessor.createInstance();
                        beanInstance = DynamicProxyImplFactory.newProxy(this, handler);
                        this.inject((Object)handler, (CreationalContext)creationalContext);
                    }
                    interceptorInstances = new LinkedHashMap<String, Object>();
                    for (InterceptorInstance interceptorInstance : this.getUserAndSystemInterceptors()) {
                        Class clazz = interceptorInstance.getData().getInterceptorClass();
                        interceptorInstances.put(clazz.getName(), interceptorInstance.getInterceptor());
                    }
                    Collection<DependentCreationalContext<?>> createdDependents = this.getDependents((CreationalContext<Object>)creationalContext);
                    for (InterceptorData interceptorData : this.getInstanceScopedInterceptors()) {
                        void var18_22;
                        if (interceptorData.getInterceptorClass().equals(beanClass)) continue;
                        Class clazz = interceptorData.getInterceptorClass();
                        if (webBeansContext != null) {
                            Object preInstantiated = null;
                            if (createdDependents != null) {
                                for (DependentCreationalContext<?> dependentCreationalContext : createdDependents) {
                                    if (!clazz.isInstance(dependentCreationalContext.getInstance())) continue;
                                    preInstantiated = dependentCreationalContext.getInstance();
                                    break;
                                }
                            }
                            if (preInstantiated != null) {
                                Object object = preInstantiated;
                            } else {
                                ConstructorInjectionBean interceptorConstructor = interceptorData.get(ConstructorInjectionBean.class);
                                if (interceptorConstructor == null) {
                                    BeanContext beanContext = this;
                                    synchronized (beanContext) {
                                        interceptorConstructor = interceptorData.get(ConstructorInjectionBean.class);
                                        if (interceptorConstructor == null) {
                                            interceptorConstructor = new ConstructorInjectionBean(webBeansContext, clazz, webBeansContext.getAnnotatedElementFactory().newAnnotatedType(clazz));
                                            interceptorData.set(ConstructorInjectionBean.class, interceptorConstructor);
                                        }
                                    }
                                }
                                CreationalContextImpl creationalContextImpl = creationalContext;
                                Object oldDelegate = creationalContextImpl.putDelegate(beanInstance);
                                Bean oldBean = creationalContextImpl.putBean((Bean)cdiEjbBean);
                                Contextual oldContextual = creationalContextImpl.putContextual((Contextual)(interceptorData.getCdiInterceptorBean() != null ? interceptorData.getCdiInterceptorBean() : interceptorConstructor));
                                try {
                                    Object object = interceptorConstructor.create((CreationalContext)creationalContext);
                                }
                                finally {
                                    creationalContextImpl.putBean(oldBean);
                                    creationalContextImpl.putContextual(oldContextual);
                                    creationalContextImpl.putDelegate(oldDelegate);
                                }
                            }
                        } else {
                            Object t = clazz.newInstance();
                        }
                        InjectionProcessor<void> interceptorInjector = new InjectionProcessor<void>(var18_22, this.getInjections(), InjectionProcessor.unwrap(ctx));
                        try {
                            void interceptorInstance = interceptorInjector.createInstance();
                            if (webBeansContext != null) {
                                try {
                                    OWBInjector.inject((BeanManager)webBeansContext.getBeanManagerImpl(), (Object)interceptorInstance, (CreationalContext)creationalContext);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            interceptorInstances.put(clazz.getName(), interceptorInstance);
                        }
                        catch (ConstructionException e) {
                            throw new Exception("Failed to create interceptor: " + clazz.getName(), e);
                        }
                    }
                    interceptorInstances.put(beanClass.getName(), beanInstance);
                    callContext.setCurrentOperation(Operation.POST_CONSTRUCT);
                    List<InterceptorData> list = this.getCallbackInterceptors();
                    postConstruct = new InterceptorStack(beanInstance, null, Operation.POST_CONSTRUCT, list, interceptorInstances);
                    if (this.componentType != BeanType.SINGLETON && this.componentType != BeanType.STATEFUL) break block46;
                    Set<Method> set = list.get(list.size() - 1).getPostConstruct();
                    if (set.isEmpty()) {
                        transactionType = TransactionType.RequiresNew;
                        break block47;
                    } else {
                        transactionType = this.getTransactionType(set.iterator().next());
                        if (transactionType == TransactionType.Required) {
                            transactionType = TransactionType.RequiresNew;
                        }
                    }
                    break block47;
                }
                transactionType = this.isBeanManagedTransaction() ? TransactionType.BeanManaged : TransactionType.NotSupported;
            }
            TransactionPolicy transactionPolicy = EjbTransactionUtil.createTransactionPolicy(transactionType, callContext);
            try {
                if (cdiEjbBean != null) {
                    cdiEjbBean.getInjectionTarget().postConstruct(beanInstance);
                }
                postConstruct.invoke(new Object[0]);
            }
            catch (Throwable e) {
                EjbTransactionUtil.handleSystemException(transactionPolicy, e, callContext);
            }
            finally {
                EjbTransactionUtil.afterInvoke(transactionPolicy, callContext);
            }
            if (cdiEjbBean != null && (proxyClass = (Class)Class.class.cast(Reflections.get(cdiEjbBean.getInjectionTarget(), "proxyClass"))) != null && (interceptorInfo = cdiEjbBean.getBeanContext().get(InterceptorResolutionService.BeanInterceptorInfo.class)).getDecorators() != null && !interceptorInfo.getDecorators().isEmpty()) {
                InterceptorDecoratorProxyFactory interceptorDecoratorProxyFactory = webBeansContext.getInterceptorDecoratorProxyFactory();
                Object instance = beanInstance;
                List decorators = interceptorInfo.getDecorators();
                HashMap<Decorator, Object> instances = new HashMap<Decorator, Object>();
                for (int i = decorators.size(); i > 0; --i) {
                    Decorator decorator = (Decorator)decorators.get(i - 1);
                    CreationalContextImpl cc = creationalContext;
                    Object oldDelegate = cc.putDelegate(beanInstance);
                    Bean oldBean = cc.putBean((Bean)cdiEjbBean);
                    Contextual oldContextual = cc.putContextual((Contextual)decorator);
                    Object decoratorInstance = null;
                    try {
                        decoratorInstance = decorator.create((CreationalContext)CreationalContext.class.cast(creationalContext));
                    }
                    finally {
                        cc.putBean(oldBean);
                        cc.putContextual(oldContextual);
                        cc.putDelegate(oldDelegate);
                    }
                    instances.put(decorator, decoratorInstance);
                    beanInstance = interceptorDecoratorProxyFactory.createProxyInstance(proxyClass, instance, (InterceptorHandler)new DecoratorHandler(interceptorInfo, decorators, instances, i - 1, instance, cdiEjbBean.getId()));
                }
            }
            InstanceContext instanceContext = new InstanceContext(this, beanInstance, interceptorInstances, (CreationalContext)creationalContext);
            return instanceContext;
        }
        finally {
            ThreadContext.exit(oldContext);
        }
    }

    private Collection<DependentCreationalContext<?>> getDependents(CreationalContext<Object> creationalContext) {
        try {
            return (Collection)Collection.class.cast(DEPENDENTS_OBJECTS.get(creationalContext));
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConstructorInjectionBean<Object> createConstructorInjectionBean(WebBeansContext webBeansContext) {
        if (this.constructorInjectionBean != null) {
            return this.constructorInjectionBean;
        }
        BeanContext beanContext = this;
        synchronized (beanContext) {
            if (this.constructorInjectionBean == null) {
                this.constructorInjectionBean = new ConstructorInjectionBean<Object>(webBeansContext, this.getManagedClass(), webBeansContext.getAnnotatedElementFactory().newAnnotatedType(this.getManagedClass()));
            }
        }
        return this.constructorInjectionBean;
    }

    public <T> void inject(T instance, CreationalContext<T> ctx) {
        WebBeansContext webBeansContext = this.getWebBeansContext();
        if (webBeansContext == null) {
            return;
        }
        InjectionTargetBean beanDefinition = (InjectionTargetBean)this.get(CdiEjbBean.class);
        if (beanDefinition == null) {
            beanDefinition = (InjectionTargetBean)InjectionTargetBean.class.cast(this.createConstructorInjectionBean(webBeansContext));
        }
        if (!(ctx instanceof CreationalContextImpl)) {
            ctx = webBeansContext.getCreationalContextFactory().wrappedCreationalContext(ctx, (Contextual)beanDefinition);
        }
        beanDefinition.getInjectionTarget().inject(instance, ctx);
    }

    public WebBeansContext getWebBeansContext() {
        CdiEjbBean bean = this.get(CdiEjbBean.class);
        if (bean != null) {
            return bean.getWebBeansContext();
        }
        return this.moduleContext.getAppContext().getWebBeansContext();
    }

    public Set<Class<?>> getAsynchronousClasses() {
        return this.asynchronousClasses;
    }

    public Set<String> getAsynchronousMethodSignatures() {
        return this.asynchronousMethodSignatures;
    }

    public void createAsynchronousMethodSet() {
        for (Map.Entry<Method, MethodContext> entry : this.methodContextMap.entrySet()) {
            if (!entry.getValue().isAsynchronous()) continue;
            this.asynchronousMethodSignatures.add(this.generateMethodSignature(entry.getKey()));
        }
        for (Class clazz : this.asynchronousClasses) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!Modifier.isPublic(method.getModifiers())) continue;
                this.asynchronousMethodSignatures.add(this.generateMethodSignature(method));
            }
        }
    }

    private String generateMethodSignature(Method method) {
        StringBuilder buffer = new StringBuilder(method.getName());
        for (Class<?> parameterType : method.getParameterTypes()) {
            buffer.append(parameterType.getName());
        }
        return buffer.toString();
    }

    private MethodContext getViewMethodContext(Method method, String view) {
        ViewContext viewContext = this.viewContextMap.get(view);
        return viewContext == null ? null : viewContext.getMethodContext(method);
    }

    private MethodContext initViewMethodContext(Method method, String view) {
        ViewContext viewContext = this.viewContextMap.get(view);
        if (viewContext == null) {
            viewContext = new ViewContext();
            this.viewContextMap.put(view, viewContext);
        }
        return viewContext.initMethodContext(method);
    }

    public Class<?> getProxyClass() {
        return this.proxyClass;
    }

    public boolean isCdiCompatible() {
        return this.componentType.isCdiCompatible() && !Comp.class.equals((Object)this.beanClass);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isPassivatingScope() {
        CdiEjbBean bean = this.get(CdiEjbBean.class);
        if (bean == null) {
            return true;
        }
        if (ConversationScoped.class == bean.getScope()) {
            try {
                return !bean.getWebBeansContext().getConversationManager().getConversationBeanReference().isTransient();
            }
            catch (RuntimeException re) {
                return false;
            }
        }
        return true;
    }

    public boolean isPassivable() {
        return this.componentType == BeanType.STATEFUL && this.passivable;
    }

    public void stop() {
        if (this.ejbTimerService != null) {
            this.ejbTimerService.stop();
        }
    }

    public void addSecurityRoleReference(String roleName, String roleLink) {
        this.securityRoleReferences.put(roleName, roleLink);
    }

    public String getSecurityRoleReference(String roleName) {
        String roleLink = this.securityRoleReferences.get(roleName);
        return roleLink != null ? roleLink : roleName;
    }

    static {
        try {
            DEPENDENTS_OBJECTS = CreationalContextImpl.class.getDeclaredField("dependentObjects");
            DEPENDENTS_OBJECTS.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Invalid OpenWebBeans version", e);
        }
    }

    public static class EntityManagerConfiguration {
        private final Map properties;
        private final SynchronizationType synchronizationType;

        public EntityManagerConfiguration(Map properties, SynchronizationType synchronizationType) {
            this.properties = properties;
            this.synchronizationType = synchronizationType;
        }

        public Map getProperties() {
            return this.properties;
        }

        public SynchronizationType getSynchronizationType() {
            return this.synchronizationType;
        }
    }

    public static final class ProxyClass {
        private final Class<?> proxy;

        public ProxyClass(BeanContext beanContext, Class<?>[] interfaces) {
            Class clazz;
            try {
                clazz = LocalBeanProxyFactory.createProxy(beanContext.getBeanClass(), beanContext.getClassLoader(), interfaces);
            }
            catch (Throwable e) {
                logger.debug(beanContext.getBeanClass().getName() + " is not proxiable", e);
                clazz = null;
            }
            this.proxy = clazz;
        }

        public Class<?> getProxy() {
            return this.proxy;
        }
    }

    private static class LegacyView {
        private EJBHome ejbHomeRef;
        private EJBLocalHome ejbLocalHomeRef;
        private Class homeInterface;
        private Class remoteInterface;
        private Class localHomeInterface;
        private Class localInterface;
        private Method createMethod;

        private LegacyView() {
        }
    }

    private static class Stateful {
        private Index<EntityManagerFactory, EntityManagerConfiguration> extendedEntityManagerFactories;
        private Duration statefulTimeout;
        private final List<Method> removeMethods = new ArrayList<Method>();

        private Stateful() {
        }
    }

    private static class Singleton {
        private LockType lockType = LockType.WRITE;
        private boolean loadOnStartup;
        private final Set<String> dependsOn = new LinkedHashSet<String>();

        private Singleton() {
        }
    }

    private static class Mdb {
        private String destinationId;
        private final Map<String, String> activationProperties = new HashMap<String, String>();
        private Class mdbInterface;

        private Mdb() {
        }
    }

    private static class Cmp {
        private boolean cmp2;
        private KeyGenerator keyGenerator;
        private String primaryKeyField;
        private Class cmpImplClass;
        private String abstractSchemaName;
        private Class pkClass;
        private final Set<String> remoteQueryResults = new TreeSet<String>();
        private boolean isReentrant;
        private final Map<Method, Method> postCreateMethodMap = new HashMap<Method, Method>();

        private Cmp() {
        }
    }

    public class ViewContext {
        private final Map<Method, MethodContext> methodContextMap = new HashMap<Method, MethodContext>();

        public MethodContext getMethodContext(Method method) {
            return this.methodContextMap.get(method);
        }

        public MethodContext initMethodContext(Method method) {
            MethodContext methodContext = this.methodContextMap.get(method);
            if (methodContext != null) {
                return methodContext;
            }
            methodContext = new MethodContext(BeanContext.this, method);
            this.methodContextMap.put(method, methodContext);
            return methodContext;
        }
    }

    public static class Comp {
        public static String openejbCompName(String module) {
            return module + "." + Comp.class.getSimpleName();
        }
    }

    public static interface Timeout {
    }

    public static interface ServiceEndpoint {
    }

    public static interface Removable {
        public void $$remove();
    }

    public static interface BusinessRemoteHome
    extends EJBHome {
        public Object create();
    }

    public static interface BusinessLocalBeanHome
    extends EJBLocalHome {
        public Object create();
    }

    public static interface BusinessLocalHome
    extends EJBLocalHome {
        public Object create();
    }
}

