/*
 * Decompiled with CFR 0.152.
 */
package jakarta.json.stream;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;

public final class JsonCollectors {
    private JsonCollectors() {
    }

    public static Collector<JsonValue, JsonArrayBuilder, JsonArray> toJsonArray() {
        return Collector.of(Json::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::addAll, JsonArrayBuilder::build, new Collector.Characteristics[0]);
    }

    public static Collector<Map.Entry<String, JsonValue>, JsonObjectBuilder, JsonObject> toJsonObject() {
        return Collector.of(Json::createObjectBuilder, JsonCollectors::addEntry, JsonObjectBuilder::addAll, JsonObjectBuilder::build, new Collector.Characteristics[0]);
    }

    public static Collector<JsonValue, JsonObjectBuilder, JsonObject> toJsonObject(Function<JsonValue, String> keyMapper, Function<JsonValue, JsonValue> valueMapper) {
        return Collector.of(Json::createObjectBuilder, (b, v) -> b.add((String)keyMapper.apply((JsonValue)v), (JsonValue)valueMapper.apply((JsonValue)v)), JsonObjectBuilder::addAll, JsonObjectBuilder::build, new Collector.Characteristics[0]);
    }

    public static <T extends JsonArrayBuilder> Collector<JsonValue, Map<String, T>, JsonObject> groupingBy(Function<JsonValue, String> classifier, Collector<JsonValue, T, JsonArray> downstream) {
        return Collector.of(HashMap::new, (map, value) -> JsonCollectors.accumulator(map, value, classifier, downstream), JsonCollectors::combiner, m -> JsonCollectors.finisher(m, downstream.finisher()), new Collector.Characteristics[0]);
    }

    public static Collector<JsonValue, Map<String, JsonArrayBuilder>, JsonObject> groupingBy(Function<JsonValue, String> classifier) {
        return JsonCollectors.groupingBy(classifier, JsonCollectors.toJsonArray());
    }

    private static void addEntry(JsonObjectBuilder objectBuilder, Map.Entry<String, JsonValue> entry) {
        objectBuilder.add(entry.getKey(), entry.getValue());
    }

    private static <T extends JsonArrayBuilder> void accumulator(Map<String, T> map, JsonValue value, Function<JsonValue, String> classifier, Collector<JsonValue, T, JsonArray> downstream) {
        String key = classifier.apply(value);
        JsonArrayBuilder arrayBuilder = map.computeIfAbsent(key, k -> (JsonArrayBuilder)downstream.supplier().get());
        downstream.accumulator().accept(arrayBuilder, value);
    }

    private static <T extends JsonArrayBuilder> Map<String, T> combiner(Map<String, T> target, Map<String, T> source) {
        target.putAll(source);
        return target;
    }

    private static <T extends JsonArrayBuilder> JsonObject finisher(Map<String, T> arrayBuilders, Function<T, JsonArray> downstream) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        arrayBuilders.forEach((key, value) -> builder.add((String)key, (JsonValue)downstream.apply(value)));
        return builder.build();
    }
}

