/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.microprofile.zipkin;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.util.logging.Logger;
import org.apache.geronimo.microprofile.opentracing.config.GeronimoOpenTracingConfig;
import org.apache.geronimo.microprofile.opentracing.microprofile.zipkin.ZipkinSpan;

@ApplicationScoped
public class ZipkinLogger {
    private final Logger spanLogger = Logger.getLogger("org.apache.geronimo.opentracing.zipkin");
    @Inject
    private GeronimoOpenTracingConfig config;
    private Jsonb jsonb;
    private boolean wrapAsList;

    @PostConstruct
    private void init() {
        this.jsonb = JsonbBuilder.create();
        this.wrapAsList = Boolean.parseBoolean(this.config.read("span.converter.zipkin.logger.wrapAsList", "true"));
    }

    @PreDestroy
    private void destroy() {
        try {
            this.jsonb.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onZipkinSpan(@Observes ZipkinSpan zipkinSpan) {
        String json = this.jsonb.toJson((Object)zipkinSpan);
        this.spanLogger.info(this.wrapAsList ? '[' + json + ']' : json);
    }
}

