/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.microprofile.zipkin;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.geronimo.microprofile.opentracing.config.GeronimoOpenTracingConfig;
import org.apache.geronimo.microprofile.opentracing.impl.FinishedSpan;
import org.apache.geronimo.microprofile.opentracing.impl.IdGenerator;
import org.apache.geronimo.microprofile.opentracing.impl.SpanImpl;
import org.apache.geronimo.microprofile.opentracing.microprofile.zipkin.ZipkinSpan;

@ApplicationScoped
public class ZipkinConverter {
    @Inject
    private Event<ZipkinSpan> zipkinSpanEvent;
    @Inject
    private GeronimoOpenTracingConfig config;
    @Inject
    private IdGenerator idGenerator;
    private String serviceName;

    @PostConstruct
    private void init() {
        this.serviceName = this.config.read("zipkin.serviceName", this.getHostName() + "_" + this.getPid());
    }

    public void onSpan(@Observes FinishedSpan finishedSpan) {
        Span from = finishedSpan.getSpan();
        if (!SpanImpl.class.isInstance(from)) {
            throw new IllegalStateException("Unsupported span type: " + from + ", maybe check your configuration");
        }
        this.zipkinSpanEvent.fire((Object)this.toZipkin((SpanImpl)SpanImpl.class.cast(from)));
    }

    private String getPid() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    private String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "server";
        }
    }

    private ZipkinSpan toZipkin(SpanImpl span) {
        ZipkinSpan.ZipkinEndpoint endpoint = this.toEndpoint(span);
        ZipkinSpan zipkin = new ZipkinSpan();
        if (this.idGenerator.isCounter()) {
            zipkin.setParentId(this.asLong(span.getParentId()));
            zipkin.setTraceId(this.asLong(span.getTraceId()));
            zipkin.setId(this.asLong(span.getId()));
        } else {
            zipkin.setParentId(span.getParentId());
            zipkin.setTraceId(span.getTraceId());
            zipkin.setId(span.getId());
        }
        zipkin.setName(span.getName());
        zipkin.setKind(Optional.ofNullable(span.getKind()).map(s -> s.toUpperCase(Locale.ROOT)).orElse(null));
        zipkin.setTimestamp(span.getTimestamp());
        zipkin.setDuration(span.getDuration());
        zipkin.setAnnotations(this.toAnnotations(span));
        zipkin.setBinaryAnnotations(this.toBinaryAnnotations(span.getTags()));
        zipkin.setTags(span.getTags().entrySet().stream().filter(e -> !Tags.SPAN_KIND.getKey().equalsIgnoreCase((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue()))));
        if ("client".equals(String.valueOf(span.getTags().get(Tags.SPAN_KIND.getKey())))) {
            zipkin.setRemoteEndpoint(endpoint);
        } else {
            zipkin.setLocalEndpoint(endpoint);
        }
        return zipkin;
    }

    private long asLong(Object value) {
        if (value == null) {
            return 0L;
        }
        if (Long.class.isInstance(value)) {
            return (Long)Long.class.cast(value);
        }
        return Long.valueOf(String.valueOf(value));
    }

    private ZipkinSpan.ZipkinEndpoint toEndpoint(SpanImpl span) {
        Map<String, Object> tags = span.getTags();
        switch (String.valueOf(tags.get(Tags.SPAN_KIND.getKey()))) {
            case "client": {
                String ipv4 = (String)tags.get(Tags.PEER_HOST_IPV4.getKey());
                String ipv6 = (String)tags.get(Tags.PEER_HOST_IPV6.getKey());
                if (ipv4 == null && ipv6 == null && tags.containsKey(Tags.PEER_HOSTNAME.getKey())) {
                    try {
                        String hostAddress = InetAddress.getByName(tags.get(Tags.PEER_HOSTNAME.getKey()).toString()).getHostAddress();
                        if (hostAddress.contains("::")) {
                            ipv6 = hostAddress;
                        } else {
                            ipv4 = hostAddress;
                        }
                    }
                    catch (UnknownHostException hostAddress) {
                        // empty catch block
                    }
                }
                Integer port = (Integer)tags.get(Tags.PEER_PORT.getKey());
                ZipkinSpan.ZipkinEndpoint endpoint = new ZipkinSpan.ZipkinEndpoint();
                endpoint.setServiceName(this.serviceName);
                endpoint.setIpv4(ipv4);
                endpoint.setIpv6(ipv6);
                endpoint.setPort(port == null ? 0 : port);
                return endpoint;
            }
            case "server": {
                String url = (String)tags.get(Tags.HTTP_URL.getKey());
                String ipv4 = null;
                String ipv6 = null;
                Integer port = null;
                if (url != null) {
                    try {
                        String hostAddress;
                        URL asUrl = new URL(url);
                        port = asUrl.getPort();
                        String host = asUrl.getHost();
                        String string = hostAddress = host.contains(":") ? host : InetAddress.getByName(host).getHostAddress();
                        if (hostAddress.contains("::")) {
                            ipv6 = hostAddress;
                        } else {
                            ipv4 = hostAddress;
                        }
                    }
                    catch (MalformedURLException | UnknownHostException asUrl) {
                        // empty catch block
                    }
                }
                ZipkinSpan.ZipkinEndpoint endpoint = new ZipkinSpan.ZipkinEndpoint();
                endpoint.setServiceName(this.serviceName);
                endpoint.setIpv4(ipv4);
                endpoint.setIpv6(ipv6);
                endpoint.setPort(port == null ? 0 : port);
                return endpoint;
            }
        }
        return null;
    }

    private List<ZipkinSpan.ZipkinAnnotation> toAnnotations(SpanImpl span) {
        Map<String, Object> tags = span.getTags();
        ArrayList<ZipkinSpan.ZipkinAnnotation> annotations = new ArrayList<ZipkinSpan.ZipkinAnnotation>(2);
        switch (String.valueOf(tags.get(Tags.SPAN_KIND.getKey()))) {
            case "client": {
                ZipkinSpan.ZipkinAnnotation clientSend = new ZipkinSpan.ZipkinAnnotation();
                clientSend.setValue("cs");
                clientSend.setTimestamp(span.getTimestamp());
                annotations.add(clientSend);
                ZipkinSpan.ZipkinAnnotation clientReceived = new ZipkinSpan.ZipkinAnnotation();
                clientReceived.setValue("cr");
                clientReceived.setTimestamp(span.getTimestamp() + span.getDuration());
                annotations.add(clientReceived);
                return annotations;
            }
            case "server": {
                ZipkinSpan.ZipkinAnnotation serverReceived = new ZipkinSpan.ZipkinAnnotation();
                serverReceived.setValue("sr");
                serverReceived.setTimestamp(span.getTimestamp());
                annotations.add(serverReceived);
                ZipkinSpan.ZipkinAnnotation serverSend = new ZipkinSpan.ZipkinAnnotation();
                serverSend.setValue("ss");
                serverSend.setTimestamp(span.getTimestamp() + span.getDuration());
                annotations.add(serverSend);
                return annotations;
            }
        }
        return Collections.emptyList();
    }

    private List<ZipkinSpan.ZipkinBinaryAnnotation> toBinaryAnnotations(Map<String, Object> tags) {
        return tags.entrySet().stream().map(tag -> {
            ZipkinSpan.ZipkinBinaryAnnotation annotations = new ZipkinSpan.ZipkinBinaryAnnotation();
            annotations.setType(this.findAnnotationType(tag.getValue()));
            annotations.setKey((String)tag.getKey());
            annotations.setValue(tag.getValue());
            return annotations;
        }).collect(Collectors.toList());
    }

    private int findAnnotationType(Object value) {
        if (String.class.isInstance(value)) {
            return 6;
        }
        if (Double.class.isInstance(value)) {
            return 5;
        }
        if (Long.class.isInstance(value)) {
            return 4;
        }
        if (Integer.class.isInstance(value)) {
            return 3;
        }
        if (Short.class.isInstance(value)) {
            return 2;
        }
        if (Byte.class.isInstance(value)) {
            return 1;
        }
        return 6;
    }
}

