/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.microprofile.server;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import jakarta.inject.Inject;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.geronimo.microprofile.opentracing.config.GeronimoOpenTracingConfig;
import org.apache.geronimo.microprofile.opentracing.impl.ScopeManagerImpl;
import org.apache.geronimo.microprofile.opentracing.impl.ServletHeaderTextMap;

public class OpenTracingFilter
implements Filter {
    @Inject
    private Tracer tracer;
    @Inject
    private GeronimoOpenTracingConfig config;
    @Inject
    private ScopeManagerImpl manager;
    private Collection<Predicate<String>> forcedUrls;
    private List<Predicate<String>> skipUrls;
    private boolean skipDefaultTags;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.skipDefaultTags = Boolean.parseBoolean(this.config.read("filter.forcedTracing.skipDefaultTags", "false"));
        this.forcedUrls = Optional.ofNullable(this.config.read("filter.forcedTracing.urls", null)).map(String::trim).filter(v -> !v.isEmpty()).map(v -> this.toMatchingPredicates((String)v, "forcedTracing")).orElse(null);
        this.skipUrls = Optional.ofNullable(this.config.read("filter.skippedTracing.urls", null)).map(String::trim).filter(v -> !v.isEmpty()).map(v -> this.toMatchingPredicates((String)v, "skippedTracing")).orElse(null);
    }

    private List<Predicate<String>> toMatchingPredicates(String v, String keyMarker) {
        Function<String, Predicate> matcherFactory;
        String matchingType;
        switch (matchingType = this.config.read("filter." + keyMarker + ".matcherType", "prefix")) {
            case "regex": {
                matcherFactory = from -> {
                    Pattern compiled = Pattern.compile(from);
                    return url -> compiled.matcher((CharSequence)url).matches();
                };
                break;
            }
            default: {
                matcherFactory = from -> url -> url.startsWith((String)from);
            }
        }
        return Stream.of(v.split(",")).map(String::trim).filter(it -> !it.isEmpty()).map(matcherFactory).collect(Collectors.toList());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String matching;
        HttpServletRequest req;
        if (!HttpServletRequest.class.isInstance(request)) {
            chain.doFilter(request, response);
            return;
        }
        if (this.forcedUrls != null && !this.forcedUrls.isEmpty()) {
            req = (HttpServletRequest)HttpServletRequest.class.cast(request);
            matching = req.getRequestURI().substring(req.getContextPath().length());
            if (this.forcedUrls.stream().anyMatch(p -> p.test(matching))) {
                Tracer.SpanBuilder builder = this.tracer.buildSpan(this.buildServletOperationName(req));
                builder.withTag(Tags.SPAN_KIND.getKey(), "server");
                builder.withTag("component", "servlet");
                Optional.ofNullable(Optional.ofNullable(this.tracer.activeSpan()).map(Span::context).orElseGet(() -> this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new ServletHeaderTextMap(req, (HttpServletResponse)HttpServletResponse.class.cast(response))))).ifPresent(arg_0 -> ((Tracer.SpanBuilder)builder).asChildOf(arg_0));
                Scope scope2 = builder.startActive(true);
                Span span = scope2.span();
                if (!this.skipDefaultTags) {
                    Tags.HTTP_METHOD.set(span, req.getMethod());
                    Tags.HTTP_URL.set(span, req.getRequestURL().toString());
                }
                request.setAttribute(OpenTracingFilter.class.getName(), (Object)scope2);
            }
        }
        if (this.skipUrls != null && !this.skipUrls.isEmpty()) {
            req = (HttpServletRequest)HttpServletRequest.class.cast(request);
            matching = req.getRequestURI().substring(req.getContextPath().length());
            if (this.forcedUrls.stream().anyMatch(p -> p.test(matching))) {
                chain.doFilter(request, response);
                return;
            }
        }
        try {
            chain.doFilter(request, response);
        }
        catch (Exception ex) {
            this.getCurrentScope(request).ifPresent(scope -> {
                int status = ((HttpServletResponse)HttpServletResponse.class.cast(response)).getStatus();
                Span span = scope.span();
                Tags.HTTP_STATUS.set(span, Integer.valueOf(status == 200 ? 500 : status));
                Tags.ERROR.set(span, Boolean.valueOf(true));
                span.log((Map)new HashMap<String, Object>(){
                    {
                        this.put("event", Tags.ERROR.getKey());
                        this.put("event.object", ex);
                    }
                });
            });
            throw ex;
        }
        finally {
            this.getCurrentScope(request).ifPresent(scope -> {
                if (request.isAsyncStarted()) {
                    request.getAsyncContext().addListener(new AsyncListener((Scope)scope){
                        final /* synthetic */ Scope val$scope;
                        {
                            this.val$scope = scope;
                        }

                        public void onComplete(AsyncEvent event) {
                            this.val$scope.close();
                        }

                        public void onTimeout(AsyncEvent event) {
                        }

                        public void onError(AsyncEvent event) {
                        }

                        public void onStartAsync(AsyncEvent event) {
                        }
                    });
                    this.manager.clear();
                } else {
                    scope.close();
                }
            });
        }
    }

    private Optional<Scope> getCurrentScope(ServletRequest request) {
        return Optional.ofNullable(Optional.ofNullable(request.getAttribute(OpenTracingFilter.class.getName())).orElseGet(() -> this.tracer.scopeManager().active())).map(Scope.class::cast);
    }

    protected String buildServletOperationName(HttpServletRequest req) {
        return req.getMethod() + ":" + req.getRequestURL();
    }
}

