/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.cdi;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResult;
import org.apache.commons.jcs.jcache.cdi.CDIJCacheHelper;
import org.apache.commons.jcs.jcache.cdi.CachePutInterceptor;
import org.apache.commons.jcs.jcache.cdi.CacheRemoveAllInterceptor;
import org.apache.commons.jcs.jcache.cdi.CacheRemoveInterceptor;
import org.apache.commons.jcs.jcache.cdi.CacheResultInterceptor;

public class MakeJCacheCDIInterceptorFriendly
implements Extension {
    private static final AtomicInteger id = new AtomicInteger();
    private static final boolean USE_ID = !Boolean.getBoolean("org.apache.commons.jcs.cdi.skip-id");
    private boolean needHelper = true;

    protected void discoverInterceptorBindings(@Observes BeforeBeanDiscovery beforeBeanDiscoveryEvent, BeanManager bm) {
        bm.createAnnotatedType(CDIJCacheHelper.class);
        for (Class interceptor : Arrays.asList(CachePutInterceptor.class, CacheRemoveInterceptor.class, CacheRemoveAllInterceptor.class, CacheResultInterceptor.class)) {
            beforeBeanDiscoveryEvent.addAnnotatedType(bm.createAnnotatedType(interceptor));
        }
        for (Class interceptor : Arrays.asList(CachePut.class, CacheRemove.class, CacheRemoveAll.class, CacheResult.class)) {
            beforeBeanDiscoveryEvent.addInterceptorBinding(interceptor, new Annotation[0]);
        }
    }

    protected void addHelper(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager bm) {
        if (!this.needHelper) {
            return;
        }
        AnnotatedType annotatedType = bm.createAnnotatedType(CDIJCacheHelper.class);
        InjectionTarget injectionTarget = bm.createInjectionTarget(annotatedType);
        HelperBean bean = new HelperBean((AnnotatedType<CDIJCacheHelper>)annotatedType, (InjectionTarget<CDIJCacheHelper>)injectionTarget, this.findIdSuffix());
        afterBeanDiscovery.addBean((Bean)bean);
    }

    protected void vetoScannedCDIJCacheHelperQualifiers(@Observes ProcessAnnotatedType<CDIJCacheHelper> pat) {
        if (!this.needHelper) {
            pat.veto();
        }
        this.needHelper = false;
    }

    private String findIdSuffix() {
        if (USE_ID) {
            return "lib" + id.incrementAndGet();
        }
        return "default";
    }

    public static class HelperBean
    implements Bean<CDIJCacheHelper>,
    PassivationCapable {
        private final AnnotatedType<CDIJCacheHelper> at;
        private final InjectionTarget<CDIJCacheHelper> it;
        private final HashSet<Annotation> qualifiers;
        private final String id;

        public HelperBean(AnnotatedType<CDIJCacheHelper> annotatedType, InjectionTarget<CDIJCacheHelper> injectionTarget, String id) {
            this.at = annotatedType;
            this.it = injectionTarget;
            this.id = "JCS#CDIHelper#" + id;
            this.qualifiers = new HashSet();
            this.qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
            this.qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.it.getInjectionPoints();
        }

        public Class<?> getBeanClass() {
            return this.at.getJavaClass();
        }

        public boolean isNullable() {
            return false;
        }

        public Set<Type> getTypes() {
            return this.at.getTypeClosure();
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }

        public String getName() {
            return null;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return false;
        }

        public CDIJCacheHelper create(CreationalContext<CDIJCacheHelper> context) {
            CDIJCacheHelper produce = (CDIJCacheHelper)this.it.produce(context);
            this.it.inject((Object)produce, context);
            this.it.postConstruct((Object)produce);
            return produce;
        }

        public void destroy(CDIJCacheHelper instance, CreationalContext<CDIJCacheHelper> context) {
            this.it.preDestroy((Object)instance);
            this.it.dispose((Object)instance);
            context.release();
        }

        public String getId() {
            return this.id;
        }
    }
}

