/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.cdi;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.cache.Cache;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.GeneratedCacheKey;
import org.apache.commons.jcs.jcache.cdi.CDIJCacheHelper;
import org.apache.commons.jcs.jcache.cdi.CacheKeyInvocationContextImpl;

@CacheResult
@Interceptor
@Priority(value=1000)
public class CacheResultInterceptor
implements Serializable {
    @Inject
    private CDIJCacheHelper helper;

    @AroundInvoke
    public Object cache(InvocationContext ic) throws Throwable {
        Object result;
        CacheDefaults defaults = this.helper.findDefaults(ic);
        Method method = ic.getMethod();
        CacheResult cacheResult = method.getAnnotation(CacheResult.class);
        String cacheName = this.helper.defaultName(method, defaults, cacheResult.cacheName());
        CacheKeyInvocationContextImpl<CacheResult> context = new CacheKeyInvocationContextImpl<CacheResult>(ic, cacheResult, cacheName, this.helper.keyParameterIndexes(method));
        CacheResolverFactory cacheResolverFactory = this.helper.cacheResolverFactoryFor(defaults, cacheResult.cacheResolverFactory());
        CacheResolver cacheResolver = cacheResolverFactory.getCacheResolver(context);
        Cache cache = cacheResolver.resolveCache(context);
        GeneratedCacheKey cacheKey = this.helper.cacheKeyGeneratorFor(defaults, cacheResult.cacheKeyGenerator()).generateCacheKey(context);
        Cache exceptionCache = null;
        if (!cacheResult.skipGet()) {
            Object exception;
            result = cache.get((Object)cacheKey);
            if (result != null) {
                return result;
            }
            if (!cacheResult.exceptionCacheName().isEmpty() && (exception = (exceptionCache = cacheResolverFactory.getExceptionCacheResolver(context).resolveCache(context)).get((Object)cacheKey)) != null) {
                throw (Throwable)Throwable.class.cast(exception);
            }
        }
        try {
            result = ic.proceed();
            if (result != null) {
                cache.put((Object)cacheKey, result);
            }
            return result;
        }
        catch (Throwable t) {
            if (this.helper.isIncluded(t.getClass(), cacheResult.cachedExceptions(), cacheResult.nonCachedExceptions())) {
                if (exceptionCache == null) {
                    exceptionCache = cacheResolverFactory.getExceptionCacheResolver(context).resolveCache(context);
                }
                exceptionCache.put((Object)cacheKey, (Object)t);
            }
            throw t;
        }
    }
}

