/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.stream.JsonParser;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.johnzon.core.AbstractJsonFactory;
import org.apache.johnzon.core.JsonParserFactoryImpl;
import org.apache.johnzon.core.JsonReaderImpl;

class JsonReaderFactoryImpl
extends AbstractJsonFactory
implements JsonReaderFactory {
    static final Collection<String> SUPPORTED_CONFIG_KEYS = Arrays.asList(new String[0]);
    private final JsonParserFactoryImpl parserFactory;

    JsonReaderFactoryImpl(Map<String, ?> config) {
        super(config, SUPPORTED_CONFIG_KEYS, JsonParserFactoryImpl.SUPPORTED_CONFIG_KEYS);
        this.parserFactory = new JsonParserFactoryImpl(this.internalConfig);
    }

    public JsonReader createReader(Reader reader) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(reader), this.parserFactory.getValueBufferProvider());
    }

    public JsonReader createReader(InputStream in) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(in), this.parserFactory.getValueBufferProvider());
    }

    public JsonReader createReader(InputStream in, Charset charset) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(in, charset), this.parserFactory.getValueBufferProvider());
    }

    public JsonReader createReader(JsonParser parser) {
        return new JsonReaderImpl(parser, this.parserFactory.getValueBufferProvider());
    }

    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }
}

