/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.cdi;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.cache.Cache;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CacheRemoveAll;
import org.apache.commons.jcs.jcache.cdi.CDIJCacheHelper;
import org.apache.commons.jcs.jcache.cdi.CacheKeyInvocationContextImpl;

@CacheRemoveAll
@Interceptor
@Priority(value=1000)
public class CacheRemoveAllInterceptor
implements Serializable {
    @Inject
    private CDIJCacheHelper helper;

    @AroundInvoke
    public Object cache(InvocationContext ic) throws Throwable {
        Object result;
        CacheDefaults defaults = this.helper.findDefaults(ic);
        Method method = ic.getMethod();
        CacheRemoveAll cacheRemoveAll = method.getAnnotation(CacheRemoveAll.class);
        String cacheName = this.helper.defaultName(method, defaults, cacheRemoveAll.cacheName());
        boolean afterInvocation = cacheRemoveAll.afterInvocation();
        CacheKeyInvocationContextImpl<CacheRemoveAll> context = new CacheKeyInvocationContextImpl<CacheRemoveAll>(ic, cacheRemoveAll, cacheName, this.helper.keyParameterIndexes(method));
        if (!afterInvocation) {
            this.removeAll(context, defaults, cacheRemoveAll);
        }
        try {
            result = ic.proceed();
        }
        catch (Throwable t) {
            if (afterInvocation && this.helper.isIncluded(t.getClass(), cacheRemoveAll.evictFor(), cacheRemoveAll.noEvictFor())) {
                this.removeAll(context, defaults, cacheRemoveAll);
            }
            throw t;
        }
        if (afterInvocation) {
            this.removeAll(context, defaults, cacheRemoveAll);
        }
        return result;
    }

    private void removeAll(CacheKeyInvocationContext<CacheRemoveAll> context, CacheDefaults defaults, CacheRemoveAll cacheRemoveAll) {
        Cache cache = this.helper.cacheResolverFactoryFor(defaults, cacheRemoveAll.cacheResolverFactory()).getCacheResolver(context).resolveCache(context);
        cache.removeAll();
    }
}

