/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.http.server;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.commons.jcs.auxiliary.remote.http.server.RemoteHttpCacheServerAttributes;
import org.apache.commons.jcs.auxiliary.remote.http.server.RemoteHttpCacheService;
import org.apache.commons.jcs.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.commons.jcs.auxiliary.remote.value.RemoteCacheResponse;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.jcs.utils.config.PropertySetter;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteHttpCacheServlet
extends HttpServlet {
    private static final long serialVersionUID = 8752849397531933346L;
    private static final Log log = LogFactory.getLog(RemoteHttpCacheServlet.class);
    private static CompositeCacheManager cacheMgr;
    private static ICacheServiceNonLocal<Serializable, Serializable> remoteCacheService;
    private final StandardSerializer serializer = new StandardSerializer();
    private int serviceCalls = 0;
    private final int logInterval = 100;

    public void init(ServletConfig config) throws ServletException {
        try {
            cacheMgr = CompositeCacheManager.getInstance();
        }
        catch (CacheException e) {
            throw new ServletException((Throwable)e);
        }
        remoteCacheService = this.createRemoteHttpCacheService(cacheMgr);
        super.init(config);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.incrementServiceCallCount();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Servicing a request. " + request));
        }
        RemoteCacheRequest<Serializable, Serializable> remoteRequest = this.readRequest(request);
        RemoteCacheResponse<Object> cacheResponse = this.processRequest(remoteRequest);
        this.writeResponse(response, cacheResponse);
    }

    protected RemoteCacheRequest<Serializable, Serializable> readRequest(HttpServletRequest request) {
        RemoteCacheRequest<Serializable, Serializable> remoteRequest = null;
        try {
            ServletInputStream inputStream = request.getInputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)"After getting input stream and before reading it");
            }
            remoteRequest = this.readRequestFromStream((InputStream)inputStream);
        }
        catch (Exception e) {
            log.error((Object)"Could not get a RemoteHttpCacheRequest object from the input stream.", (Throwable)e);
        }
        return remoteRequest;
    }

    protected RemoteCacheRequest<Serializable, Serializable> readRequestFromStream(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStreamClassLoaderAware ois = new ObjectInputStreamClassLoaderAware(inputStream, null);
        RemoteCacheRequest remoteRequest = (RemoteCacheRequest)ois.readObject();
        ois.close();
        return remoteRequest;
    }

    protected void writeResponse(HttpServletResponse response, RemoteCacheResponse<Object> cacheResponse) {
        try {
            response.setContentType("application/octet-stream");
            byte[] responseAsByteAray = this.serializer.serialize(cacheResponse);
            response.setContentLength(responseAsByteAray.length);
            ServletOutputStream outputStream = response.getOutputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Opened output stream.  Response size: " + responseAsByteAray.length));
            }
            outputStream.write(responseAsByteAray);
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            log.error((Object)("Problem writing response. " + cacheResponse), (Throwable)e);
        }
    }

    protected RemoteCacheResponse<Object> processRequest(RemoteCacheRequest<Serializable, Serializable> request) {
        RemoteCacheResponse<Object> response = new RemoteCacheResponse<Object>();
        if (request == null) {
            String message = "The request is null. Cannot process";
            log.warn((Object)message);
            response.setSuccess(false);
            response.setErrorMessage(message);
        } else {
            try {
                switch (request.getRequestType()) {
                    case GET: {
                        ICacheElement<Serializable, Serializable> element = remoteCacheService.get(request.getCacheName(), request.getKey(), request.getRequesterId());
                        response.setPayload(element);
                        break;
                    }
                    case GET_MULTIPLE: {
                        Map<Serializable, ICacheElement<Serializable, Serializable>> elementMap = remoteCacheService.getMultiple(request.getCacheName(), request.getKeySet(), request.getRequesterId());
                        if (elementMap != null) {
                            HashMap<Serializable, ICacheElement<Serializable, Serializable>> map = new HashMap<Serializable, ICacheElement<Serializable, Serializable>>();
                            map.putAll(elementMap);
                            response.setPayload(map);
                        }
                        break;
                    }
                    case GET_MATCHING: {
                        Map<Serializable, ICacheElement<Serializable, Serializable>> elementMapMatching = remoteCacheService.getMatching(request.getCacheName(), request.getPattern(), request.getRequesterId());
                        if (elementMapMatching != null) {
                            HashMap<Serializable, ICacheElement<Serializable, Serializable>> map = new HashMap<Serializable, ICacheElement<Serializable, Serializable>>();
                            map.putAll(elementMapMatching);
                            response.setPayload(map);
                        }
                        break;
                    }
                    case REMOVE: {
                        remoteCacheService.remove(request.getCacheName(), request.getKey(), request.getRequesterId());
                        break;
                    }
                    case REMOVE_ALL: {
                        remoteCacheService.removeAll(request.getCacheName(), request.getRequesterId());
                        break;
                    }
                    case UPDATE: {
                        remoteCacheService.update(request.getCacheElement(), request.getRequesterId());
                        break;
                    }
                    case ALIVE_CHECK: 
                    case DISPOSE: {
                        response.setSuccess(true);
                        break;
                    }
                    case GET_KEYSET: {
                        Set<Serializable> keys = remoteCacheService.getKeySet(request.getCacheName());
                        response.setPayload(keys);
                        break;
                    }
                    default: {
                        String message = "Unknown event type.  Cannot process " + request;
                        log.warn((Object)message);
                        response.setSuccess(false);
                        response.setErrorMessage(message);
                        break;
                    }
                }
            }
            catch (IOException e) {
                String message = "Problem processing request. " + request + " Error: " + e.getMessage();
                log.error((Object)message, (Throwable)e);
                response.setSuccess(false);
                response.setErrorMessage(message);
            }
        }
        return response;
    }

    protected <K, V> RemoteHttpCacheService<K, V> createRemoteHttpCacheService(ICompositeCacheManager cacheManager) {
        Properties props = cacheManager.getConfigurationProperties();
        ICacheEventLogger cacheEventLogger = this.configureCacheEventLogger(props);
        RemoteHttpCacheServerAttributes attributes = this.configureRemoteHttpCacheServerAttributes(props);
        RemoteHttpCacheService service = new RemoteHttpCacheService(cacheManager, attributes, cacheEventLogger);
        if (log.isInfoEnabled()) {
            log.info((Object)("Created new RemoteHttpCacheService " + service));
        }
        return service;
    }

    protected ICacheEventLogger configureCacheEventLogger(Properties props) {
        ICacheEventLogger cacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(props, "jcs.remotehttpcache");
        return cacheEventLogger;
    }

    protected RemoteHttpCacheServerAttributes configureRemoteHttpCacheServerAttributes(Properties prop) {
        RemoteHttpCacheServerAttributes rcsa = new RemoteHttpCacheServerAttributes();
        PropertySetter.setProperties(rcsa, prop, "jcs.remotehttpcache.serverattributes.");
        return rcsa;
    }

    protected void setRemoteCacheService(ICacheServiceNonLocal<Serializable, Serializable> rcs) {
        remoteCacheService = rcs;
    }

    private void incrementServiceCallCount() {
        ++this.serviceCalls;
        if (log.isInfoEnabled() && this.serviceCalls % 100 == 0) {
            log.info((Object)("serviceCalls = " + this.serviceCalls));
        }
    }

    public void destroy() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Servlet Destroyed, shutting down JCS.");
        }
        cacheMgr.shutDown();
    }

    public String getServletInfo() {
        return "RemoteHttpCacheServlet";
    }
}

