/*
 * Decompiled with CFR 0.152.
 */
package jakarta.enterprise.concurrent;

import jakarta.enterprise.concurrent.ManageableThread;
import jakarta.enterprise.concurrent.ManagedTask;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class ManagedExecutors {
    public static final String NULL_TASK_ERROR_MSG = "Task cannot be null";

    public static boolean isCurrentThreadShutdown() {
        Thread currThread = Thread.currentThread();
        return currThread instanceof ManageableThread && ((ManageableThread)ManageableThread.class.cast(currThread)).isShutdown();
    }

    public static Runnable managedTask(Runnable task, ManagedTaskListener taskListener) throws IllegalArgumentException {
        return ManagedExecutors.managedTask(task, null, taskListener);
    }

    public static Runnable managedTask(Runnable task, Map<String, String> executionProperties, ManagedTaskListener taskListener) throws IllegalArgumentException {
        if (task == null) {
            throw new IllegalArgumentException(NULL_TASK_ERROR_MSG);
        }
        return new RunnableAdapter(task, executionProperties, taskListener);
    }

    public static <V> Callable<V> managedTask(Callable<V> task, ManagedTaskListener taskListener) throws IllegalArgumentException {
        return ManagedExecutors.managedTask(task, null, taskListener);
    }

    public static <V> Callable<V> managedTask(Callable<V> task, Map<String, String> executionProperties, ManagedTaskListener taskListener) throws IllegalArgumentException {
        if (task == null) {
            throw new IllegalArgumentException(NULL_TASK_ERROR_MSG);
        }
        return new CallableAdapter<V>(task, executionProperties, taskListener);
    }

    private ManagedExecutors() {
    }

    private static class Adapter
    implements ManagedTask {
        protected final ManagedTaskListener taskListener;
        protected final Map<String, String> executionProperties;
        protected final ManagedTask managedTask;

        public Adapter(ManagedTaskListener taskListener, Map<String, String> executionProperties, ManagedTask managedTask) {
            this.taskListener = taskListener;
            this.managedTask = managedTask;
            this.executionProperties = Adapter.initExecutionProperties(managedTask == null ? null : managedTask.getExecutionProperties(), executionProperties);
        }

        @Override
        public ManagedTaskListener getManagedTaskListener() {
            if (this.taskListener != null) {
                return this.taskListener;
            }
            if (this.managedTask != null) {
                return this.managedTask.getManagedTaskListener();
            }
            return null;
        }

        @Override
        public Map<String, String> getExecutionProperties() {
            if (this.executionProperties != null) {
                return this.executionProperties;
            }
            return null;
        }

        private static Map<String, String> initExecutionProperties(Map<String, String> base, Map<String, String> override) {
            if (base == null && override == null) {
                return null;
            }
            HashMap<String, String> props = new HashMap<String, String>();
            if (base != null) {
                props.putAll(base);
            }
            if (override != null) {
                props.putAll(override);
            }
            return props;
        }
    }

    private static final class CallableAdapter<V>
    extends Adapter
    implements Callable<V> {
        private final Callable<V> task;

        public CallableAdapter(Callable<V> task, Map<String, String> executionProperties, ManagedTaskListener taskListener) {
            super(taskListener, executionProperties, ManagedTask.class.isInstance(task) ? (ManagedTask)ManagedTask.class.cast(task) : null);
            this.task = task;
        }

        @Override
        public V call() throws Exception {
            return this.task.call();
        }
    }

    private static final class RunnableAdapter
    extends Adapter
    implements Runnable {
        private final Runnable task;

        public RunnableAdapter(Runnable task, Map<String, String> executionProperties, ManagedTaskListener taskListener) {
            super(taskListener, executionProperties, ManagedTask.class.isInstance(task) ? (ManagedTask)ManagedTask.class.cast(task) : null);
            this.task = task;
        }

        @Override
        public void run() {
            this.task.run();
        }
    }
}

