/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectStreamField;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.rmi.impl.AnyFieldDescriptor;
import org.apache.yoko.rmi.impl.BooleanFieldDescriptor;
import org.apache.yoko.rmi.impl.ByteFieldDescriptor;
import org.apache.yoko.rmi.impl.CharFieldDescriptor;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.CorbaObjectFieldDescriptor;
import org.apache.yoko.rmi.impl.DoubleFieldDescriptor;
import org.apache.yoko.rmi.impl.FloatFieldDescriptor;
import org.apache.yoko.rmi.impl.IntFieldDescriptor;
import org.apache.yoko.rmi.impl.LongFieldDescriptor;
import org.apache.yoko.rmi.impl.ModelElement;
import org.apache.yoko.rmi.impl.ObjectFieldDescriptor;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.apache.yoko.rmi.impl.RemoteFieldDescriptor;
import org.apache.yoko.rmi.impl.ShortFieldDescriptor;
import org.apache.yoko.rmi.impl.StringFieldDescriptor;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueFieldDescriptor;
import org.omg.CORBA.Object;
import org.omg.CORBA.ValueMember;

public abstract class FieldDescriptor
extends ModelElement
implements Comparable {
    static Logger logger = Logger.getLogger(FieldDescriptor.class.getName());
    org.apache.yoko.rmi.util.corba.Field field;
    Class type;
    Class declaringClass;
    boolean isFinal;
    ValueMember valuemember;
    boolean isPublic;

    protected FieldDescriptor(Class owner, Class type, String name, Field f) {
        this.type = type;
        this.setJavaName(name);
        this.setIDLName(name);
        this.declaringClass = owner;
        if (f != null) {
            this.isPublic = Modifier.isPublic(f.getModifiers());
            this.field = new org.apache.yoko.rmi.util.corba.Field(f);
            this.isFinal = Modifier.isFinal(f.getModifiers());
        } else {
            this.isPublic = false;
            this.field = null;
            this.isFinal = false;
        }
    }

    ValueMember getValueMember(TypeRepository rep) {
        if (this.valuemember == null) {
            TypeDescriptor desc = rep.getDescriptor(this.type);
            TypeDescriptor owner = rep.getDescriptor(this.declaringClass);
            this.valuemember = new ValueMember(this.getIDLName(), desc.getRepositoryID(), owner.getRepositoryID(), "1.0", desc.getTypeCode(), null, (short)(this.isPublic ? 1 : 0));
        }
        return this.valuemember;
    }

    public Class getType() {
        return this.type;
    }

    public int compareTo(java.lang.Object other) {
        FieldDescriptor desc = (FieldDescriptor)other;
        if (this.isPrimitive() && !desc.isPrimitive()) {
            return -1;
        }
        if (!this.isPrimitive() && desc.isPrimitive()) {
            return 1;
        }
        return this.getJavaName().compareTo(desc.getJavaName());
    }

    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    abstract void read(ObjectReader var1, java.lang.Object var2) throws IOException;

    abstract void write(ObjectWriter var1, java.lang.Object var2) throws IOException;

    abstract void readFieldIntoMap(ObjectReader var1, Map var2) throws IOException;

    abstract void writeFieldFromMap(ObjectWriter var1, Map var2) throws IOException;

    abstract void copyState(java.lang.Object var1, java.lang.Object var2, CopyState var3);

    static FieldDescriptor get(Field f) {
        return FieldDescriptor.get(f.getDeclaringClass(), f.getType(), f.getName(), f);
    }

    static FieldDescriptor get(Class declaringClass, ObjectStreamField field) {
        Field f = null;
        try {
            f = declaringClass.getDeclaredField(field.getName());
        }
        catch (Exception ex) {
            logger.log(Level.FINER, "Cannot get java field \"" + field.getName() + "\" for class \"" + declaringClass.getName() + "\"" + "\n" + ex, ex);
        }
        return FieldDescriptor.get(declaringClass, field.getType(), field.getName(), f);
    }

    static FieldDescriptor get(Class owner, Class type, String name, Field f) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return new BooleanFieldDescriptor(owner, type, name, f);
            }
            if (type == Byte.TYPE) {
                return new ByteFieldDescriptor(owner, type, name, f);
            }
            if (type == Short.TYPE) {
                return new ShortFieldDescriptor(owner, type, name, f);
            }
            if (type == Character.TYPE) {
                return new CharFieldDescriptor(owner, type, name, f);
            }
            if (type == Integer.TYPE) {
                return new IntFieldDescriptor(owner, type, name, f);
            }
            if (type == Long.TYPE) {
                return new LongFieldDescriptor(owner, type, name, f);
            }
            if (type == Float.TYPE) {
                return new FloatFieldDescriptor(owner, type, name, f);
            }
            if (type == Double.TYPE) {
                return new DoubleFieldDescriptor(owner, type, name, f);
            }
            throw new RuntimeException("unknown field type " + type);
        }
        if (Object.class.isAssignableFrom(type)) {
            return new CorbaObjectFieldDescriptor(owner, type, name, f);
        }
        if (java.lang.Object.class.equals((java.lang.Object)type) || Externalizable.class.equals((java.lang.Object)type) || Serializable.class.equals((java.lang.Object)type)) {
            return new AnyFieldDescriptor(owner, type, name, f);
        }
        if (Remote.class.isAssignableFrom(type) || Remote.class.equals((java.lang.Object)type)) {
            return new RemoteFieldDescriptor(owner, type, name, f);
        }
        if (String.class.equals((java.lang.Object)type)) {
            return new StringFieldDescriptor(owner, type, name, f);
        }
        if (Serializable.class.isAssignableFrom(type)) {
            return new ValueFieldDescriptor(owner, type, name, f);
        }
        if (type.isInterface() && type.getMethods().length > 0) {
            return new ValueFieldDescriptor(owner, type, name, f);
        }
        return new ObjectFieldDescriptor(owner, type, name, f);
    }

    void print(PrintWriter pw, Map recurse, java.lang.Object val) {
        pw.print(this.getJavaName());
        pw.print("=");
        try {
            java.lang.Object obj = this.field.get(val);
            if (obj == null) {
                pw.print("null");
            } else {
                TypeDescriptor desc = this.getTypeRepository().getDescriptor(obj.getClass());
                desc.print(pw, recurse, obj);
            }
        }
        catch (IllegalAccessException ex) {
            // empty catch block
        }
    }
}

