/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.impl;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.geronimo.microprofile.opentracing.config.GeronimoOpenTracingConfig;
import org.apache.geronimo.microprofile.opentracing.impl.FinishedSpan;
import org.apache.geronimo.microprofile.opentracing.impl.IdGenerator;
import org.apache.geronimo.microprofile.opentracing.impl.JaxRsHeaderTextMap;
import org.apache.geronimo.microprofile.opentracing.impl.ServletHeaderTextMap;
import org.apache.geronimo.microprofile.opentracing.impl.SpanBuilderImpl;
import org.apache.geronimo.microprofile.opentracing.impl.SpanContextImpl;
import org.apache.geronimo.microprofile.opentracing.impl.SpanImpl;

@ApplicationScoped
public class GeronimoTracer
implements Tracer {
    @Inject
    private ScopeManager scopeManager;
    @Inject
    private IdGenerator idGenerator;
    @Inject
    private Event<FinishedSpan> finishedSpanEvent;
    @Inject
    private GeronimoOpenTracingConfig config;
    private String parentSpanIdHeader;
    private String spanIdHeader;
    private String traceIdHeader;
    private String baggageHeaderPrefix;

    @PostConstruct
    private void init() {
        this.parentSpanIdHeader = this.config.read("propagation.headers.parentSpanId", "X-B3-ParentSpanId");
        this.spanIdHeader = this.config.read("propagation.headers.spanId", "X-B3-SpanId");
        this.traceIdHeader = this.config.read("propagation.headers.traceId", "X-B3-TraceId");
        this.baggageHeaderPrefix = this.config.read("propagation.headers.baggagePrefix", "baggage-");
    }

    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    public Span activeSpan() {
        return Optional.ofNullable(this.scopeManager.active()).map(Scope::span).orElse(null);
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new SpanBuilderImpl(this, span -> this.finishedSpanEvent.fire((Object)new FinishedSpan(this.processNewSpan((SpanImpl)span))), operationName, this.idGenerator);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        if (!TextMap.class.isInstance(carrier)) {
            throw new IllegalArgumentException("Only TextMap are supported");
        }
        TextMap textMap = (TextMap)TextMap.class.cast(carrier);
        SpanContextImpl context = (SpanContextImpl)SpanContextImpl.class.cast(spanContext);
        textMap.put(this.traceIdHeader, String.valueOf(context.getTraceId()));
        textMap.put(this.spanIdHeader, String.valueOf(context.getSpanId()));
        context.getBaggageItems().forEach((k, v) -> textMap.put(this.baggageHeaderPrefix + k, v));
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        if (JaxRsHeaderTextMap.class.isInstance(carrier)) {
            MultivaluedMap<String, ?> map = ((JaxRsHeaderTextMap)JaxRsHeaderTextMap.class.cast(carrier)).getMap();
            String traceid = (String)map.getFirst((Object)this.traceIdHeader);
            String spanid = (String)map.getFirst((Object)this.spanIdHeader);
            String parentspanid = (String)map.getFirst((Object)this.parentSpanIdHeader);
            if (traceid != null && spanid != null) {
                return this.newContext(traceid, parentspanid, spanid, map.keySet().stream().filter(it -> it.startsWith(this.baggageHeaderPrefix)).collect(Collectors.toMap(Function.identity(), k -> String.valueOf(map.getFirst(k)))));
            }
            return null;
        }
        if (ServletHeaderTextMap.class.isInstance(carrier)) {
            HttpServletRequest req = ((ServletHeaderTextMap)ServletHeaderTextMap.class.cast(carrier)).getRequest();
            String traceid = req.getHeader(this.traceIdHeader);
            String spanid = req.getHeader(this.spanIdHeader);
            String parentspanid = req.getHeader(this.parentSpanIdHeader);
            if (traceid != null && spanid != null) {
                return this.newContext(traceid, parentspanid, spanid, Collections.list(req.getHeaderNames()).stream().filter(it -> it.startsWith(this.baggageHeaderPrefix)).collect(Collectors.toMap(Function.identity(), k -> String.valueOf(req.getHeader(k)))));
            }
            return null;
        }
        if (!TextMap.class.isInstance(carrier)) {
            throw new IllegalArgumentException("Only TextMap are supported");
        }
        Iterator textMap = ((TextMap)TextMap.class.cast(carrier)).iterator();
        String traceId = null;
        String spanId = null;
        String parentSpanId = null;
        HashMap<String, String> baggages = new HashMap<String, String>();
        while (textMap.hasNext()) {
            Map.Entry next = (Map.Entry)textMap.next();
            if (((String)next.getKey()).startsWith(this.baggageHeaderPrefix)) {
                baggages.put((String)next.getKey(), (String)next.getValue());
                continue;
            }
            if (this.spanIdHeader.equals(next.getKey())) {
                spanId = (String)next.getValue();
                continue;
            }
            if (this.traceIdHeader.equals(next.getKey())) {
                traceId = (String)next.getValue();
                continue;
            }
            if (!this.parentSpanIdHeader.equals(next.getKey())) continue;
            parentSpanId = (String)next.getValue();
        }
        if (traceId != null && spanId != null) {
            return this.newContext(traceId, parentSpanId, spanId, baggages);
        }
        return null;
    }

    protected Span processNewSpan(SpanImpl span) {
        return span;
    }

    protected SpanContextImpl newContext(Object traceId, Object parentSpanId, Object spanId, Map<String, String> baggages) {
        return new SpanContextImpl(traceId, parentSpanId, spanId, baggages);
    }
}

