/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt;

import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.apache.catalina.connector.Request;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.OpenEJBSecurityListener;
import org.apache.tomee.catalina.TomcatSecurityService;
import org.apache.tomee.microprofile.jwt.JWTLogCategories;
import org.apache.tomee.microprofile.jwt.ParseException;
import org.apache.tomee.microprofile.jwt.bval.ValidationInterceptor;
import org.apache.tomee.microprofile.jwt.config.JWTAuthConfiguration;
import org.apache.tomee.microprofile.jwt.config.JWTAuthConfigurationProperties;
import org.apache.tomee.microprofile.jwt.principal.JWTCallerPrincipal;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;

public class MPJWTFilter
implements Filter {
    private static final Logger VALIDATION = Logger.getInstance((LogCategory)JWTLogCategories.VALIDATION, MPJWTFilter.class);
    @Inject
    private Instance<JWTAuthConfiguration> authContextInfo;
    @Inject
    private JWTAuthConfigurationProperties jwtAuthConfigurationProperties;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Optional<JWTAuthConfiguration> authContextInfo = this.getAuthContextInfo();
        if (!authContextInfo.isPresent()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        try {
            MPJWTServletRequestWrapper wrappedRequest = new MPJWTServletRequestWrapper(httpServletRequest, authContextInfo.get());
            chain.doFilter((ServletRequest)wrappedRequest, response);
            Object state = request.getAttribute("MP_JWT_PRE_LOGIN_STATE");
            SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
            if (TomcatSecurityService.class.isInstance(securityService) && state != null) {
                TomcatSecurityService tomcatSecurityService = (TomcatSecurityService)TomcatSecurityService.class.cast(securityService);
                tomcatSecurityService.exitWebApp(state);
            }
        }
        catch (Exception e) {
            if (MPJWTException.class.isInstance(e)) {
                MPJWTException jwtException = (MPJWTException)MPJWTException.class.cast(e);
                ((HttpServletResponse)HttpServletResponse.class.cast(response)).sendError(jwtException.getStatus(), jwtException.getMessage());
            }
            if (MPJWTException.class.isInstance(e.getCause())) {
                MPJWTException jwtException = (MPJWTException)MPJWTException.class.cast(e.getCause());
                ((HttpServletResponse)HttpServletResponse.class.cast(response)).sendError(jwtException.getStatus(), jwtException.getMessage());
            }
            throw e;
        }
    }

    public void destroy() {
    }

    private Optional<JWTAuthConfiguration> getAuthContextInfo() {
        if (!this.authContextInfo.isUnsatisfied()) {
            return Optional.of(this.authContextInfo.get());
        }
        return this.jwtAuthConfigurationProperties.getJWTAuthConfiguration();
    }

    private static Function<HttpServletRequest, JsonWebToken> token(HttpServletRequest httpServletRequest, JWTAuthConfiguration authContextInfo) {
        return new ValidateJSonWebToken(httpServletRequest, authContextInfo)::validate;
    }

    public static class ValidateJSonWebToken {
        private final HttpServletRequest httpServletRequest;
        private final JWTAuthConfiguration jwtAuthConfiguration;
        private JsonWebToken jsonWebToken;

        public ValidateJSonWebToken(HttpServletRequest httpServletRequest, JWTAuthConfiguration authContextInfo) {
            this.httpServletRequest = httpServletRequest;
            this.jwtAuthConfiguration = authContextInfo;
        }

        public JsonWebToken validate(HttpServletRequest request) {
            if (this.jsonWebToken != null) {
                return this.jsonWebToken;
            }
            String headerName = this.jwtAuthConfiguration.getHeaderName();
            String authorizationHeader = this.httpServletRequest.getHeader(headerName);
            if (authorizationHeader == null || authorizationHeader.isEmpty()) {
                throw new MissingAuthorizationHeaderException();
            }
            String headerScheme = (this.jwtAuthConfiguration.getHeaderScheme() + " ").toLowerCase(Locale.ENGLISH);
            if (headerScheme.trim().length() > 0 && !authorizationHeader.toLowerCase(Locale.ENGLISH).startsWith(headerScheme)) {
                throw new BadAuthorizationPrefixException(authorizationHeader);
            }
            String token = authorizationHeader.substring(headerScheme.length());
            try {
                this.jsonWebToken = ValidateJSonWebToken.parse(token, this.jwtAuthConfiguration);
            }
            catch (ParseException e) {
                throw new InvalidTokenException(token, e);
            }
            SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
            if (TomcatSecurityService.class.isInstance(securityService)) {
                TomcatSecurityService tomcatSecurityService = (TomcatSecurityService)TomcatSecurityService.class.cast(securityService);
                Request req = (Request)OpenEJBSecurityListener.requests.get();
                Object state = tomcatSecurityService.enterWebApp(req.getWrapper().getRealm(), (Principal)this.jsonWebToken, req.getWrapper().getRunAs());
                request.setAttribute("MP_JWT_PRE_LOGIN_STATE", state);
            }
            return this.jsonWebToken;
        }

        public static JWTCallerPrincipal parse(String token, JWTAuthConfiguration authContextInfo) throws ParseException {
            JWTCallerPrincipal principal;
            try {
                JwtConsumerBuilder builder = new JwtConsumerBuilder().setRelaxVerificationKeyValidation().setRequireSubject().setSkipDefaultAudienceValidation().setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{"RS256", "RS384", "RS512"}));
                if (!authContextInfo.isAllowNoExpiryClaim()) {
                    builder.setRequireExpirationTime();
                }
                if (authContextInfo.getIssuer() != null) {
                    builder.setExpectedIssuer(authContextInfo.getIssuer());
                }
                if (authContextInfo.getExpGracePeriodSecs() > 0) {
                    builder.setAllowedClockSkewInSeconds(authContextInfo.getExpGracePeriodSecs());
                } else {
                    builder.setEvaluationTime(NumericDate.fromSeconds((long)0L));
                }
                if (authContextInfo.isSingleKey()) {
                    builder.setVerificationKey(authContextInfo.getPublicKey());
                } else {
                    builder.setVerificationKeyResolver((VerificationKeyResolver)new JwksVerificationKeyResolver(authContextInfo.getPublicKeys()));
                }
                JwtConsumer jwtConsumer = builder.build();
                JwtContext jwtContext = jwtConsumer.process(token);
                String type = ((JsonWebStructure)jwtContext.getJoseObjects().get(0)).getHeader("typ");
                jwtConsumer.processContext(jwtContext);
                JwtClaims claimsSet = jwtContext.getJwtClaims();
                String principalName = (String)claimsSet.getClaimValue("upn", String.class);
                if (principalName == null && (principalName = (String)claimsSet.getClaimValue("preferred_username", String.class)) == null) {
                    principalName = claimsSet.getSubject();
                }
                claimsSet.setClaim(Claims.raw_token.name(), (Object)token);
                principal = new JWTCallerPrincipal(token, type, claimsSet, principalName);
            }
            catch (InvalidJwtException e) {
                VALIDATION.warning(e.getMessage());
                throw new ParseException("Failed to verify token", e);
            }
            catch (MalformedClaimException e) {
                VALIDATION.warning(e.getMessage());
                throw new ParseException("Failed to verify token claims", e);
            }
            return principal;
        }
    }

    @Provider
    public static class MPJWTExceptionMapper
    implements ExceptionMapper<MPJWTException> {
        public Response toResponse(MPJWTException exception) {
            return Response.status((int)exception.getStatus()).entity((Object)exception.getMessage()).build();
        }
    }

    private static class InvalidTokenException
    extends MPJWTException {
        private final String token;

        public InvalidTokenException(String token, Throwable cause) {
            super(cause);
            this.token = token;
        }

        @Override
        public int getStatus() {
            return 401;
        }

        @Override
        public String getMessage() {
            return "Invalid or not parsable JWT " + this.token;
        }
    }

    private static class BadAuthorizationPrefixException
    extends MPJWTException {
        private final String authorizationHeader;

        public BadAuthorizationPrefixException(String authorizationHeader) {
            this.authorizationHeader = authorizationHeader;
        }

        @Override
        public int getStatus() {
            return 401;
        }

        @Override
        public String getMessage() {
            return "Authorization header does not use the Bearer prefix. Can't validate header " + this.authorizationHeader;
        }
    }

    private static class MissingAuthorizationHeaderException
    extends MPJWTException {
        private MissingAuthorizationHeaderException() {
        }

        @Override
        public int getStatus() {
            return 401;
        }

        @Override
        public String getMessage() {
            return "No authorization header provided. Can't validate the JWT.";
        }
    }

    private static abstract class MPJWTException
    extends RuntimeException {
        public MPJWTException() {
        }

        public MPJWTException(Throwable cause) {
            super(cause);
        }

        public abstract int getStatus();

        @Override
        public abstract String getMessage();
    }

    public static class MPJWTServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final Function<HttpServletRequest, JsonWebToken> tokenFunction;
        private final HttpServletRequest request;

        public MPJWTServletRequestWrapper(final HttpServletRequest request, JWTAuthConfiguration authContextInfo) {
            super(request);
            this.request = request;
            this.tokenFunction = MPJWTFilter.token(request, authContextInfo);
            Supplier<JsonWebToken> tokenSupplier = () -> this.tokenFunction.apply(request);
            request.setAttribute(JsonWebToken.class.getName(), this.tokenFunction);
            request.setAttribute(ValidationInterceptor.JWT_SUPPLIER, tokenSupplier);
            request.setAttribute("javax.security.auth.subject.callable", (Object)new Callable<Subject>(){

                @Override
                public Subject call() throws Exception {
                    LinkedHashSet<JsonWebToken> principals = new LinkedHashSet<JsonWebToken>();
                    JsonWebToken namePrincipal = (JsonWebToken)tokenFunction.apply(request);
                    principals.add(namePrincipal);
                    principals.addAll(namePrincipal.getGroups().stream().map(role -> () -> role).collect(Collectors.toList()));
                    return new Subject(true, principals, Collections.emptySet(), Collections.emptySet());
                }
            });
        }

        public Principal getUserPrincipal() {
            return (Principal)this.tokenFunction.apply(this.request);
        }

        public boolean isUserInRole(String role) {
            JsonWebToken jsonWebToken = this.tokenFunction.apply(this.request);
            return jsonWebToken.getGroups().contains(role);
        }

        public String getAuthType() {
            return "MP-JWT";
        }
    }
}

