/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.Request;
import org.apache.openejb.client.RequestType;

public class AuthenticationRequest
implements Request {
    private static final long serialVersionUID = 7009531340198948330L;
    private transient String realm;
    private transient String username;
    private transient String credentials;
    private transient ProtocolMetaData metaData;

    public AuthenticationRequest() {
    }

    public AuthenticationRequest(String principal, String credentials) {
        this(null, principal, credentials);
    }

    public AuthenticationRequest(String realm, String principal, String credentials) {
        this.realm = realm;
        this.username = principal;
        this.credentials = credentials;
    }

    @Override
    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.AUTH_REQUEST;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getUsername() {
        return this.username;
    }

    public String getCredentials() {
        return this.credentials;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        this.realm = (String)in.readObject();
        this.username = (String)in.readObject();
        this.credentials = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.realm);
        out.writeObject(this.username);
        out.writeObject(this.credentials);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(null != this.realm ? this.realm : "Unknown realm").append(':');
        sb.append(null != this.username ? this.username : "Unknown user").append(':');
        sb.append(null != this.credentials ? this.credentials : "Unknown credentials");
        return sb.toString();
    }
}

