/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.retry;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.safeguard.impl.annotation.AnnotationFinder;
import org.apache.safeguard.impl.asynchronous.BaseAsynchronousInterceptor;
import org.apache.safeguard.impl.cache.Key;
import org.apache.safeguard.impl.cache.UnwrappedCache;
import org.apache.safeguard.impl.config.ConfigurationMapper;
import org.apache.safeguard.impl.interceptor.IdGeneratorInterceptor;
import org.apache.safeguard.impl.metrics.FaultToleranceMetrics;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

public abstract class BaseRetryInterceptor
implements Serializable {
    @Inject
    private Cache cache;

    @AroundInvoke
    public Object retry(InvocationContext context) throws Exception {
        Model existing;
        Key cacheKey;
        Map<Key, Model> models = this.cache.getModels();
        Model model = models.get(cacheKey = new Key(context, this.cache.getUnwrapped()));
        if (model == null && (existing = models.putIfAbsent(cacheKey, model = this.cache.create(context))) != null) {
            model = existing;
        }
        if (model.disabled) {
            return context.proceed();
        }
        Map contextData = context.getContextData();
        Object id = contextData.get(IdGeneratorInterceptor.class.getName());
        String contextKey = BaseRetryInterceptor.class.getName() + ".context_" + id;
        Context retryContext = (Context)Context.class.cast(contextData.get(contextKey));
        if (retryContext == null) {
            retryContext = new Context(System.nanoTime() + model.maxDuration, model.maxRetries);
            contextData.put(contextKey, retryContext);
        }
        while (retryContext.counter >= 0) {
            try {
                Object proceed = context.proceed();
                if (retryContext.counter == model.maxRetries) {
                    this.executeFinalCounterAction(contextData, model.callsSucceededNotRetried);
                } else {
                    this.executeFinalCounterAction(contextData, model.callsSucceededRetried);
                }
                if (BaseAsynchronousInterceptor.BaseFuture.class.isInstance(proceed)) {
                    Model modelRef = model;
                    contextData.put(BaseAsynchronousInterceptor.BaseFuture.class.getName() + ".errorHandler_" + id, error -> {
                        this.handleException(contextData, contextKey, modelRef, (Exception)error);
                        return (Future)Future.class.cast(context.proceed());
                    });
                }
                return proceed;
            }
            catch (Exception re) {
                retryContext = this.handleException(contextData, contextKey, model, re);
            }
        }
        throw new FaultToleranceException("Inaccessible normally, here for compilation");
    }

    private Context handleException(Map<String, Object> contextData, String contextKey, Model modelRef, Exception error) throws Exception {
        if (CircuitBreakerOpenException.class.isInstance(error)) {
            throw error;
        }
        Context ctx = (Context)Context.class.cast(contextData.get(contextKey));
        if (modelRef.abortOn(error) || --ctx.counter < 0 || System.nanoTime() >= ctx.maxEnd) {
            this.executeFinalCounterAction(contextData, modelRef.callsFailed);
            throw error;
        }
        if (!modelRef.retryOn(error)) {
            throw error;
        }
        modelRef.retries.inc();
        long pause = modelRef.nextPause();
        if (pause > 0L) {
            Thread.sleep(pause);
        }
        return ctx;
    }

    protected abstract void executeFinalCounterAction(Map<String, Object> var1, FaultToleranceMetrics.Counter var2);

    private static class Context {
        private final long maxEnd;
        private int counter;

        private Context(long maxEnd, int maxRetries) {
            this.maxEnd = maxEnd;
            this.counter = maxRetries;
        }
    }

    @ApplicationScoped
    public static class Cache {
        private final Map<Key, Model> models = new ConcurrentHashMap<Key, Model>();
        @Inject
        private UnwrappedCache unwrappedCache;
        @Inject
        private AnnotationFinder finder;
        @Inject
        private ConfigurationMapper configurationMapper;
        @Inject
        private FaultToleranceMetrics metrics;

        public Map<Key, Model> getModels() {
            return this.models;
        }

        public Model create(InvocationContext context) {
            Retry retry = this.finder.findAnnotation(Retry.class, context);
            Retry configuredRetry = this.configurationMapper.map(retry, context.getMethod(), Retry.class);
            String metricsNameBase = "ft." + context.getMethod().getDeclaringClass().getCanonicalName() + "." + context.getMethod().getName() + ".retry.";
            return new Model(!this.configurationMapper.isEnabled(context.getMethod(), Retry.class), configuredRetry, this.metrics.counter(metricsNameBase + "callsSucceededNotRetried.total", "The number of times the method was called and succeeded without retrying"), this.metrics.counter(metricsNameBase + "callsSucceededRetried.total", "The number of times the method was called and succeeded after retrying at least once"), this.metrics.counter(metricsNameBase + "callsFailed.total", "The number of times the method was called and ultimately failed after retrying"), this.metrics.counter(metricsNameBase + "retries.total", "The total number of times the method was retried"));
        }

        public Map<Class<?>, Optional<Class<?>>> getUnwrapped() {
            return this.unwrappedCache.getUnwrappedCache();
        }
    }

    static class Model {
        private final Class<? extends Throwable>[] abortOn;
        private final Class<? extends Throwable>[] retryOn;
        private final long maxDuration;
        private final int maxRetries;
        private final long delay;
        private final long jitter;
        private final FaultToleranceMetrics.Counter callsSucceededNotRetried;
        private final FaultToleranceMetrics.Counter callsSucceededRetried;
        private final FaultToleranceMetrics.Counter callsFailed;
        private final FaultToleranceMetrics.Counter retries;
        private final boolean disabled;

        private Model(boolean disabled, Retry retry, FaultToleranceMetrics.Counter callsSucceededNotRetried, FaultToleranceMetrics.Counter callsSucceededRetried, FaultToleranceMetrics.Counter callsFailed, FaultToleranceMetrics.Counter retries) {
            this.disabled = disabled;
            this.abortOn = retry.abortOn();
            this.retryOn = retry.retryOn();
            this.maxDuration = retry.delayUnit().getDuration().toNanos() * retry.maxDuration();
            this.maxRetries = retry.maxRetries();
            this.delay = retry.delayUnit().getDuration().toNanos() * retry.delay();
            this.jitter = retry.jitterDelayUnit().getDuration().toNanos() * retry.jitter();
            this.callsSucceededNotRetried = callsSucceededNotRetried;
            this.callsSucceededRetried = callsSucceededRetried;
            this.callsFailed = callsFailed;
            this.retries = retries;
            if (this.maxRetries < 0) {
                throw new FaultToleranceDefinitionException("max retries can't be negative");
            }
            if (this.delay < 0L) {
                throw new FaultToleranceDefinitionException("delay can't be negative");
            }
            if (this.maxDuration < 0L) {
                throw new FaultToleranceDefinitionException("max duration can't be negative");
            }
            if (this.jitter < 0L) {
                throw new FaultToleranceDefinitionException("jitter can't be negative");
            }
            if (this.delay > this.maxDuration) {
                throw new FaultToleranceDefinitionException("delay can't be < max duration");
            }
        }

        private boolean abortOn(Exception re) {
            return this.matches(this.abortOn, re);
        }

        private boolean retryOn(Exception re) {
            return this.matches(this.retryOn, re);
        }

        private boolean matches(Class<? extends Throwable>[] list, Exception re) {
            return list.length > 0 && Stream.of(list).anyMatch(it -> it.isInstance(re) || it.isInstance(re.getCause()));
        }

        private long nextPause() {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            return TimeUnit.NANOSECONDS.toMillis(Math.min(this.maxDuration, Math.max(0L, (long)(random.nextBoolean() ? 1 : -1) * this.delay + (this.jitter == 0L ? 0L : random.nextLong(this.jitter)))));
        }
    }
}

