/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.common;

import jakarta.json.bind.annotation.JsonbProperty;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import org.apache.geronimo.microprofile.metrics.common.expdecay.ExponentialMovingAverage;
import org.eclipse.microprofile.metrics.Meter;

public class MeterImpl
implements Meter {
    private static final long REFRESH_INTERVAL = TimeUnit.SECONDS.toNanos(5L);
    private final AtomicLong lastRefresh = new AtomicLong(System.nanoTime());
    private final LongAdder count = new LongAdder();
    private final ExponentialMovingAverage rate15 = ExponentialMovingAverage.forMinutes(15);
    private final ExponentialMovingAverage rate5 = ExponentialMovingAverage.forMinutes(5);
    private final ExponentialMovingAverage rate1 = ExponentialMovingAverage.forMinutes(1);
    private final long initNs = System.nanoTime();
    private final String unit;

    public MeterImpl(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public void mark() {
        this.mark(1L);
    }

    public void mark(long n) {
        this.updateIfNeeded();
        this.count.add(n);
        this.rate1.add(n);
        this.rate5.add(n);
        this.rate15.add(n);
    }

    public long getCount() {
        return this.count.sum();
    }

    @JsonbProperty(value="fifteenMinRate")
    public double getFifteenMinuteRate() {
        this.updateIfNeeded();
        return this.rate15.rate();
    }

    @JsonbProperty(value="fiveMinRate")
    public double getFiveMinuteRate() {
        this.updateIfNeeded();
        return this.rate5.rate();
    }

    @JsonbProperty(value="oneMinRate")
    public double getOneMinuteRate() {
        this.updateIfNeeded();
        return this.rate1.rate();
    }

    public double getMeanRate() {
        long count = this.getCount();
        if (count == 0L) {
            return 0.0;
        }
        long duration = System.nanoTime() - this.initNs;
        if (duration == 0L) {
            return 0.0;
        }
        long seconds = TimeUnit.NANOSECONDS.toSeconds(duration);
        if (seconds == 0L) {
            return 0.0;
        }
        return (double)count * 1.0 / (double)seconds;
    }

    private void updateIfNeeded() {
        long previousRefresh;
        long now = System.nanoTime();
        if (now - (previousRefresh = this.lastRefresh.get()) >= REFRESH_INTERVAL && this.lastRefresh.compareAndSet(previousRefresh, now)) {
            this.lastRefresh.set(now);
            Stream.of(this.rate1, this.rate5, this.rate15).forEach(ExponentialMovingAverage::refresh);
        }
    }
}

