/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse.interceptor;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.sse.SseEventSink;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class SseInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(SseInterceptor.class);

    public SseInterceptor() {
        super("post-logical");
    }

    public SseInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) {
        block12: {
            if (message.get(SseEventSink.class) == null) {
                return;
            }
            if (!this.isRequestor(message) && message.get(SseInterceptor.class) == null) {
                message.put(SseInterceptor.class, (Object)this);
                Exchange exchange = message.getExchange();
                OperationResourceInfo ori = (OperationResourceInfo)exchange.get((Object)OperationResourceInfo.class.getName());
                if (ori != null) {
                    Response.ResponseBuilder builder = Response.ok();
                    HttpServletResponse servletResponse = null;
                    ServerProviderFactory providerFactory = ServerProviderFactory.getInstance((Message)message);
                    Object response = message.get((Object)"HTTP.RESPONSE");
                    if (response instanceof HttpServletResponse) {
                        servletResponse = (HttpServletResponse)response;
                        builder = Response.status((int)servletResponse.getStatus());
                        Map userHeaders = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
                        if (userHeaders != null) {
                            for (Map.Entry<String, List<Object>> entry : userHeaders.entrySet()) {
                                this.addHeader(builder, entry);
                            }
                        }
                        for (String string : servletResponse.getHeaderNames()) {
                            Collection headers = servletResponse.getHeaders(string);
                            this.addHeader(builder, string, headers);
                        }
                    }
                    try {
                        ResponseImpl responseImpl = (ResponseImpl)builder.build();
                        JAXRSUtils.runContainerResponseFilters((ServerProviderFactory)providerFactory, (ResponseImpl)responseImpl, (Message)message, (OperationResourceInfo)ori, (Method)ori.getAnnotatedMethod());
                        if (servletResponse != null) {
                            MultivaluedMap headers = responseImpl.getStringHeaders();
                            servletResponse.setStatus(responseImpl.getStatus());
                            if (headers != null) {
                                for (Map.Entry entry : headers.entrySet()) {
                                    this.setHeader(servletResponse, entry);
                                }
                            }
                        }
                    }
                    catch (Throwable ex) {
                        if (!LOG.isLoggable(Level.FINE)) break block12;
                        LOG.log(Level.FINE, ex.getMessage(), ex);
                    }
                }
            }
        }
    }

    private void addHeader(Response.ResponseBuilder builder, Map.Entry<String, List<Object>> entry) {
        if (entry.getValue() != null) {
            for (Object value : entry.getValue()) {
                builder.header(entry.getKey(), value);
            }
        }
    }

    private void addHeader(Response.ResponseBuilder builder, String header, Collection<String> headers) {
        if (headers != null) {
            for (String value : headers) {
                builder.header(header, (Object)value);
            }
        }
    }

    private void setHeader(HttpServletResponse servletResponse, Map.Entry<String, List<String>> entry) {
        if (entry.getValue() != null) {
            servletResponse.setHeader(entry.getKey(), HttpUtils.getHeaderString(entry.getValue()));
        }
    }
}

