/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;

public final class JoseJaxrsUtils {
    private static final String HTTP_PREFIX = "http.";
    private static final Set<String> DEFAULT_PROTECTED_HTTP_HEADERS = new HashSet<String>(Arrays.asList("Content-Type", "Accept"));

    private JoseJaxrsUtils() {
    }

    public static void protectHttpHeaders(MultivaluedMap<String, Object> httpHeaders, JoseHeaders joseHeaders, Set<String> protectedHttpHeaders) {
        if (protectedHttpHeaders == null) {
            protectedHttpHeaders = DEFAULT_PROTECTED_HTTP_HEADERS;
        }
        for (String headerName : protectedHttpHeaders) {
            List headerValues = (List)httpHeaders.get((Object)headerName);
            if (headerValues == null) continue;
            String joseHeaderValue = JoseJaxrsUtils.getJoseHeaderValue(headerValues);
            String prefixedHeaderName = HTTP_PREFIX + headerName;
            joseHeaders.setHeader(prefixedHeaderName, (Object)joseHeaderValue);
        }
    }

    private static String getJoseHeaderValue(List<? extends Object> headerValues) {
        StringBuilder sb = new StringBuilder();
        for (Object object : headerValues) {
            String[] parts;
            for (String part : parts = object.toString().split(",")) {
                sb.append(part);
            }
        }
        return sb.toString();
    }

    public static void validateHttpHeaders(MultivaluedMap<String, String> httpHeaders, JoseHeaders joseHeaders, Set<String> protectedHttpHeaders) {
        if (protectedHttpHeaders == null) {
            protectedHttpHeaders = DEFAULT_PROTECTED_HTTP_HEADERS;
        }
        HashMap<String, String> joseHttpHeaders = new HashMap<String, String>();
        HashMap<String, String> updatedHttpHeaders = new HashMap<String, String>();
        for (String headerName : protectedHttpHeaders) {
            List headerValues = (List)httpHeaders.get((Object)headerName);
            if (headerValues == null || headerValues.isEmpty() || headerValues.get(0) == null) continue;
            String headerValue = JoseJaxrsUtils.getJoseHeaderValue(headerValues);
            String prefixedHeaderName = HTTP_PREFIX + headerName;
            updatedHttpHeaders.put(prefixedHeaderName, headerValue);
            String joseHeaderValue = joseHeaders.getStringProperty(prefixedHeaderName);
            if (joseHeaderValue == null) continue;
            joseHttpHeaders.put(prefixedHeaderName, joseHeaderValue);
        }
        if (joseHttpHeaders.size() != updatedHttpHeaders.size() || !joseHttpHeaders.entrySet().containsAll(updatedHttpHeaders.entrySet())) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
    }
}

