/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.configsource;

import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.Vetoed;
import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.config.configsource.BaseConfigSource;

@Typed
@Vetoed
public class SystemEnvConfigSource
extends BaseConfigSource {
    private Map<String, String> configValues;
    private Map<String, String> uppercasePosixValues = new HashMap<String, String>();

    public SystemEnvConfigSource() {
        this.configValues = System.getenv();
        this.initOrdinal(300);
        for (Map.Entry<String, String> e : this.configValues.entrySet()) {
            String posixKey;
            String originalKey = e.getKey();
            if (originalKey.equals(posixKey = this.replaceNonPosixEnvChars(originalKey).toUpperCase())) continue;
            this.uppercasePosixValues.put(posixKey, e.getValue());
        }
    }

    public String getName() {
        return "system_env";
    }

    public Map<String, String> getProperties() {
        return this.configValues;
    }

    public String getValue(String key) {
        String val = this.configValues.get(key);
        if (val == null) {
            key = this.replaceNonPosixEnvChars(key);
            val = this.configValues.get(key);
        }
        if (val == null) {
            key = key.toUpperCase();
            val = this.configValues.get(key);
        }
        if (val == null) {
            val = this.uppercasePosixValues.get(key);
        }
        return val;
    }

    private String replaceNonPosixEnvChars(String key) {
        return key.replaceAll("[^A-Za-z0-9]", "_");
    }
}

