/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config;

import jakarta.enterprise.inject.Typed;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.geronimo.config.ConfigImpl;
import org.eclipse.microprofile.config.spi.Converter;

@Typed
public class ConfigValueImpl<T> {
    private static final Logger logger = Logger.getLogger(ConfigValueImpl.class.getName());
    private final ConfigImpl config;
    private String keyOriginal;
    private String keyResolved;
    private Class<?> configEntryType = String.class;
    private String[] lookupChain;
    private boolean evaluateVariables = false;
    private long cacheTimeNs = -1L;
    private volatile long reloadAfter = -1L;
    private long lastReloadedAt = -1L;
    private T lastValue = null;
    private boolean isList;
    private boolean isSet;
    private T defaultValue;
    private boolean withDefault;
    private Converter<T> converter;

    public ConfigValueImpl(ConfigImpl config, String key) {
        this.config = config;
        this.keyOriginal = key;
    }

    public <N> ConfigValueImpl<N> as(Class<N> clazz) {
        this.configEntryType = clazz;
        return this;
    }

    public ConfigValueImpl<List<T>> asList() {
        this.isList = true;
        ConfigValueImpl listTypedResolver = this;
        if (this.defaultValue == null) {
            return listTypedResolver.withDefault(Collections.emptyList());
        }
        return listTypedResolver;
    }

    public ConfigValueImpl<Set<T>> asSet() {
        this.isSet = true;
        ConfigValueImpl listTypedResolver = this;
        if (this.defaultValue == null) {
            return listTypedResolver.withDefault(Collections.emptySet());
        }
        return listTypedResolver;
    }

    public ConfigValueImpl<T> withDefault(T value) {
        this.defaultValue = value;
        this.withDefault = true;
        return this;
    }

    public ConfigValueImpl<T> withStringDefault(String value) {
        if (value == null || value.isEmpty()) {
            throw new RuntimeException("Empty String or null supplied as string-default value for property " + this.keyOriginal);
        }
        value = this.replaceVariables(value);
        this.defaultValue = this.isList ? this.splitAndConvertListValue(value) : this.convert(value);
        this.withDefault = true;
        return this;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public ConfigValueImpl<T> useConverter(Converter<T> converter) {
        this.converter = converter;
        return this;
    }

    public ConfigValueImpl<T> cacheFor(long value, TimeUnit timeUnit) {
        this.cacheTimeNs = timeUnit.toNanos(value);
        return this;
    }

    public ConfigValueImpl<T> evaluateVariables(boolean evaluateVariables) {
        this.evaluateVariables = evaluateVariables;
        return this;
    }

    public ConfigValueImpl<T> withLookupChain(String ... postfixNames) {
        this.lookupChain = postfixNames;
        return this;
    }

    public Optional<T> getOptionalValue() {
        return Optional.ofNullable(this.get());
    }

    public List<T> getValueList() {
        String rawList = (String)this.get(false);
        ArrayList values = new ArrayList();
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < rawList.length(); ++i) {
            char c = rawList.charAt(i);
            if ('\\' == c) {
                if (i == rawList.length()) {
                    throw new IllegalStateException("incorrect escaping of key " + this.keyOriginal + " value: " + rawList);
                }
                char nextChar = rawList.charAt(i + 1);
                if (nextChar == '\\') {
                    sb.append('\\');
                } else if (nextChar == ',') {
                    sb.append(',');
                }
                ++i;
                continue;
            }
            if (',' == c) {
                this.addListValue(values, sb);
                continue;
            }
            sb.append(c);
        }
        this.addListValue(values, sb);
        return values;
    }

    private void addListValue(List<T> values, StringBuilder sb) {
        String val = sb.toString().trim();
        if (!val.isEmpty()) {
            values.add(this.convert(val));
        }
        sb.setLength(0);
    }

    public T get() {
        return this.get(true);
    }

    public T getValue() {
        T val = this.get();
        if (val == null) {
            throw new NoSuchElementException("No config value present for key " + this.keyOriginal);
        }
        return val;
    }

    private T get(boolean convert) {
        Object value;
        long lastCfgChange;
        long now = -1L;
        if (this.cacheTimeNs > 0L && (now = System.nanoTime()) <= this.reloadAfter && (lastCfgChange = this.config.getLastChanged()) < this.lastReloadedAt) {
            return this.lastValue;
        }
        String valueStr = this.resolveStringValue();
        if ((valueStr == null || valueStr.isEmpty()) && this.withDefault) {
            return this.defaultValue;
        }
        if (this.isList || this.isSet) {
            value = this.splitAndConvertListValue(valueStr);
            if (this.isSet) {
                value = new HashSet((List)value);
            }
        } else {
            value = convert ? this.convert(valueStr) : valueStr;
        }
        this.lastValue = value;
        if (this.cacheTimeNs > 0L) {
            this.reloadAfter = now + this.cacheTimeNs;
            this.lastReloadedAt = now;
        }
        return value;
    }

    private String resolveStringValue() {
        String value = null;
        if (this.lookupChain != null) {
            ArrayList<String> postfixVals = new ArrayList<String>();
            for (String postfix : this.lookupChain) {
                if (postfix.startsWith("${") && postfix.length() > 3) {
                    String varName = postfix.substring(2, postfix.length() - 1);
                    String varValue = this.config.getValue(varName);
                    if (varValue == null || varValue.length() <= 0) continue;
                    postfixVals.add(varValue);
                    continue;
                }
                postfixVals.add(postfix);
            }
            for (int mask = (1 << postfixVals.size()) - 1; mask > 0; --mask) {
                StringBuilder sb = new StringBuilder(this.keyOriginal);
                for (int loc = 0; loc < postfixVals.size(); ++loc) {
                    int bitPos = 1 << postfixVals.size() - loc - 1;
                    if ((mask & bitPos) <= 0) continue;
                    sb.append('.').append((String)postfixVals.get(loc));
                }
                value = this.config.getValue(sb.toString());
                if (value == null || value.length() <= 0) continue;
                this.keyResolved = sb.toString();
                break;
            }
        }
        if (value == null) {
            value = this.config.getValue(this.keyOriginal);
            this.keyResolved = this.keyOriginal;
        }
        if (this.evaluateVariables && value != null) {
            value = this.replaceVariables(value);
        }
        return value;
    }

    private String replaceVariables(String value) {
        String varName;
        int endVar;
        int startVar = 0;
        while ((startVar = value.indexOf("${", startVar)) >= 0 && (endVar = value.indexOf("}", startVar)) > 0 && !(varName = value.substring(startVar + 2, endVar)).isEmpty()) {
            String variableValue = this.config.access(varName).evaluateVariables(true).get();
            if (variableValue != null) {
                value = value.replace("${" + varName + "}", variableValue);
            }
            ++startVar;
        }
        return value;
    }

    public String getPropertyName() {
        return this.keyOriginal;
    }

    public String getResolvedPropertyName() {
        return this.keyResolved;
    }

    private T convert(String value) {
        if (this.converter != null) {
            return (T)this.converter.convert(value);
        }
        if (String.class == this.configEntryType) {
            return (T)value;
        }
        return (T)this.config.convert(value, this.configEntryType);
    }

    private T splitAndConvertListValue(String valueStr) {
        if (valueStr == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        StringBuilder currentValue = new StringBuilder();
        int length = valueStr.length();
        for (int i = 0; i < length; ++i) {
            char c = valueStr.charAt(i);
            if (c == '\\') {
                if (i >= length - 1) continue;
                char nextC = valueStr.charAt(i + 1);
                currentValue.append(nextC);
                ++i;
                continue;
            }
            if (c == ',') {
                String trimedVal = currentValue.toString().trim();
                if (trimedVal.length() > 0) {
                    list.add(this.convert(trimedVal));
                }
                currentValue.setLength(0);
                continue;
            }
            currentValue.append(c);
        }
        String trimedVal = currentValue.toString().trim();
        if (trimedVal.length() > 0) {
            list.add(this.convert(trimedVal));
        }
        return (T)list;
    }
}

