/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.common;

import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbTransient;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.geronimo.microprofile.metrics.common.HistogramImpl;
import org.apache.geronimo.microprofile.metrics.common.MeterImpl;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

public class TimerImpl
implements Timer {
    private final Histogram histogram;
    private final Meter meter;

    public TimerImpl(String unit) {
        this.histogram = new HistogramImpl(unit);
        this.meter = new MeterImpl(unit);
    }

    public void update(long duration, TimeUnit unit) {
        if (duration >= 0L) {
            this.histogram.update(unit.toNanos(duration));
            this.meter.mark();
        }
    }

    public <T> T time(Callable<T> event) throws Exception {
        try (Timer.Context context = this.time();){
            T t = event.call();
            return t;
        }
    }

    public void time(Runnable event) {
        try {
            this.time(() -> {
                event.run();
                return null;
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Timer.Context time() {
        return new ContextImpl();
    }

    public long getCount() {
        return this.histogram.getCount();
    }

    @JsonbProperty(value="fifteenMinRate")
    public double getFifteenMinuteRate() {
        return this.meter.getFifteenMinuteRate();
    }

    @JsonbProperty(value="fiveMinRate")
    public double getFiveMinuteRate() {
        return this.meter.getFiveMinuteRate();
    }

    public double getMeanRate() {
        return this.meter.getMeanRate();
    }

    @JsonbProperty(value="oneMinRate")
    public double getOneMinuteRate() {
        return this.meter.getOneMinuteRate();
    }

    @JsonbTransient
    public Snapshot getSnapshot() {
        return this.histogram.getSnapshot();
    }

    public double getP50() {
        return this.getSnapshot().getMedian();
    }

    public double getP75() {
        return this.getSnapshot().get75thPercentile();
    }

    public double getP95() {
        return this.getSnapshot().get95thPercentile();
    }

    public double getP98() {
        return this.getSnapshot().get98thPercentile();
    }

    public double getP99() {
        return this.getSnapshot().get99thPercentile();
    }

    public double getP999() {
        return this.getSnapshot().get999thPercentile();
    }

    public long getMax() {
        return this.getSnapshot().getMax();
    }

    public double getMean() {
        return this.getSnapshot().getMean();
    }

    public long getMin() {
        return this.getSnapshot().getMin();
    }

    public double getStddev() {
        return this.getSnapshot().getStdDev();
    }

    private class ContextImpl
    implements Timer.Context {
        private final long start = System.nanoTime();

        private ContextImpl() {
        }

        public long stop() {
            long duration = System.nanoTime() - this.start;
            TimerImpl.this.update(duration, TimeUnit.NANOSECONDS);
            return duration;
        }

        public void close() {
            this.stop();
        }
    }
}

