/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.cache;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@ApplicationScoped
public class UnwrappedCache {
    private final Map<Class<?>, Optional<Class<?>>> unwrappedCache = new ConcurrentHashMap();

    public Map<Class<?>, Optional<Class<?>>> getUnwrappedCache() {
        return this.unwrappedCache;
    }

    public static final class Tool {
        private Tool() {
        }

        public static Optional<Class<?>> unwrap(Map<Class<?>, Optional<Class<?>>> unwrappedCache, Object instance) {
            if (instance == null) {
                return Optional.empty();
            }
            Class<?> raw = instance.getClass();
            Optional<Class<?>> existing = unwrappedCache.get(raw);
            if (existing != null) {
                return existing;
            }
            Class<?> target = raw;
            while (target.getName().contains("$$")) {
                target = target.getSuperclass();
            }
            if (target == Object.class) {
                return Optional.empty();
            }
            Optional<Class<?>> out = Optional.ofNullable(target);
            unwrappedCache.put(raw, out);
            return out;
        }
    }
}

