/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.cache;

import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.safeguard.impl.cache.UnwrappedCache;

public class Key {
    private final Class<?> declaringClass;
    private final Method method;
    private final int hash;

    public Key(InvocationContext context, Map<Class<?>, Optional<Class<?>>> unwrappedCache) {
        this(UnwrappedCache.Tool.unwrap(unwrappedCache, context.getTarget()).orElseGet(() -> context.getMethod().getDeclaringClass()), context.getMethod());
    }

    public Key(Class<?> declaringClass, Method method) {
        this.declaringClass = declaringClass;
        this.method = method;
        this.hash = Objects.hash(declaringClass, method);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)Key.class.cast(o);
        return Objects.equals(this.declaringClass, key.declaringClass) && Objects.equals(this.method, key.method);
    }

    public int hashCode() {
        return this.hash;
    }
}

