/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.bulkhead;

import jakarta.annotation.PreDestroy;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.safeguard.impl.annotation.AnnotationFinder;
import org.apache.safeguard.impl.asynchronous.BaseAsynchronousInterceptor;
import org.apache.safeguard.impl.cache.Key;
import org.apache.safeguard.impl.cache.UnwrappedCache;
import org.apache.safeguard.impl.config.ConfigurationMapper;
import org.apache.safeguard.impl.interceptor.IdGeneratorInterceptor;
import org.apache.safeguard.impl.metrics.FaultToleranceMetrics;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

@Bulkhead
@Interceptor
@Priority(value=4005)
public class BulkheadInterceptor
extends BaseAsynchronousInterceptor {
    @Inject
    private Cache cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object bulkhead(InvocationContext context) throws Exception {
        Key key;
        Map<Key, Model> models = this.cache.getModels();
        Model model = models.get(key = new Key(context, this.cache.getUnwrappedCache().getUnwrappedCache()));
        if (model == null) {
            model = this.cache.create(context);
            Model existing = models.putIfAbsent(key, model);
            if (existing != null) {
                model = existing;
            } else {
                this.cache.postCreate(model, context);
            }
        }
        if (model.disabled) {
            return context.proceed();
        }
        if (model.useThreads) {
            Map data = context.getContextData();
            Object id = data.get(IdGeneratorInterceptor.class.getName());
            data.put(BulkheadInterceptor.class.getName() + ".model_" + id, model);
            data.put(BulkheadInterceptor.class.getName() + "_" + id, model.pool);
            data.put(Asynchronous.class.getName() + ".skip_" + id, Boolean.TRUE);
            return this.around(context);
        }
        if (!model.semaphore.tryAcquire()) {
            model.callsRejected.inc();
            throw new BulkheadException("No more permission available");
        }
        model.callsAccepted.inc();
        model.concurrentCalls.incrementAndGet();
        long start = System.nanoTime();
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            model.executionDuration.update(System.nanoTime() - start);
            model.semaphore.release();
            model.concurrentCalls.decrementAndGet();
        }
    }

    private Model getModel(InvocationContext context) {
        return (Model)Model.class.cast(context.getContextData().get(BulkheadInterceptor.class.getName() + ".model_" + context.getContextData().get(IdGeneratorInterceptor.class.getName())));
    }

    @Override
    protected BaseAsynchronousInterceptor.FutureWrapper<Object> newFuture(InvocationContext context, Map<String, Object> data) {
        return new ContextualFutureWrapper<Object>(this.getModel(context), context.getContextData());
    }

    @Override
    protected BaseAsynchronousInterceptor.ExtendedCompletableFuture<Object> newCompletableFuture(InvocationContext context) {
        return new ContextualCompletableFuture<Object>(this.getModel(context));
    }

    @Override
    protected Executor getExecutor(InvocationContext context) {
        return (Executor)Executor.class.cast(context.getContextData().get(BulkheadInterceptor.class.getName() + "_" + context.getContextData().get(IdGeneratorInterceptor.class.getName())));
    }

    @ApplicationScoped
    public static class Cache {
        private final Map<Key, Model> models = new ConcurrentHashMap<Key, Model>();
        @Inject
        private AnnotationFinder finder;
        @Inject
        private FaultToleranceMetrics metrics;
        @Inject
        private ConfigurationMapper configurationMapper;
        @Inject
        private UnwrappedCache unwrappedCache;

        public UnwrappedCache getUnwrappedCache() {
            return this.unwrappedCache;
        }

        @PreDestroy
        private void destroy() {
            this.models.values().stream().filter(m -> ((Model)m).pool != null).forEach(m -> ((Model)m).pool.shutdownNow());
        }

        public Map<Key, Model> getModels() {
            return this.models;
        }

        public Model create(InvocationContext context) {
            boolean useThreads = this.finder.findAnnotation(Asynchronous.class, context) != null;
            String metricsNameBase = this.getMetricsNameBase(context);
            FaultToleranceMetrics.Counter callsAccepted = this.metrics.counter(metricsNameBase + "callsAccepted.total", "Number of calls accepted by the bulkhead");
            FaultToleranceMetrics.Counter callsRejected = this.metrics.counter(metricsNameBase + "callsRejected.total", "Number of calls rejected by the bulkhead");
            FaultToleranceMetrics.Histogram executionDuration = this.metrics.histogram(metricsNameBase + "executionDuration", "Histogram of method execution times. This does not include any time spent waiting in the bulkhead queue.");
            FaultToleranceMetrics.Histogram waitingDuration = useThreads ? this.metrics.histogram(metricsNameBase + "waiting.duration", "Histogram of the time executions spend waiting in the queue") : null;
            return new Model(!this.configurationMapper.isEnabled(context.getMethod(), Bulkhead.class), context, this.configurationMapper.map(this.finder.findAnnotation(Bulkhead.class, context), context.getMethod(), Bulkhead.class), useThreads, callsAccepted, callsRejected, executionDuration, waitingDuration);
        }

        private String getMetricsNameBase(InvocationContext context) {
            return "ft." + context.getMethod().getDeclaringClass().getCanonicalName() + "." + context.getMethod().getName() + ".bulkhead.";
        }

        public void postCreate(Model model, InvocationContext context) {
            String metricsNameBase = this.getMetricsNameBase(context);
            this.metrics.gauge(metricsNameBase + "concurrentExecutions", "Number of currently running executions", "none", model.concurrentCalls::get);
            if (model.workQueue != null) {
                this.metrics.gauge(metricsNameBase + "waitingQueue.population", "Number of executions currently waiting in the queue", "none", () -> model.workQueue.size());
            }
        }
    }

    static class Model {
        private final boolean disabled;
        private final int value;
        private final int waitingQueue;
        private final boolean useThreads;
        private final ThreadPoolExecutor pool;
        private final Semaphore semaphore;
        private final AtomicLong concurrentCalls = new AtomicLong();
        private final ArrayBlockingQueue<Runnable> workQueue;
        private final FaultToleranceMetrics.Counter callsAccepted;
        private final FaultToleranceMetrics.Counter callsRejected;
        private final FaultToleranceMetrics.Histogram executionDuration;
        private final FaultToleranceMetrics.Histogram waitingDuration;

        private Model(boolean disabled, final InvocationContext context, Bulkhead bulkhead, boolean useThreads, final FaultToleranceMetrics.Counter callsAccepted, FaultToleranceMetrics.Counter callsRejected, final FaultToleranceMetrics.Histogram executionDuration, final FaultToleranceMetrics.Histogram waitingDuration) {
            this.disabled = disabled;
            this.value = bulkhead.value();
            if (this.value <= 0) {
                throw new FaultToleranceDefinitionException("Invalid value in @Bulkhead: " + this.value);
            }
            this.waitingQueue = bulkhead.waitingTaskQueue();
            if (this.waitingQueue <= 0) {
                throw new FaultToleranceDefinitionException("Invalid value in @Bulkhead: " + this.value);
            }
            this.callsAccepted = callsAccepted;
            this.callsRejected = callsRejected;
            this.executionDuration = executionDuration;
            this.waitingDuration = waitingDuration;
            this.useThreads = useThreads;
            if (this.useThreads) {
                this.workQueue = new ArrayBlockingQueue(this.waitingQueue);
                this.pool = new ThreadPoolExecutor(this.value, this.value, 0L, TimeUnit.MILLISECONDS, this.workQueue, new ThreadFactory(){
                    private final ThreadGroup group = Optional.ofNullable(System.getSecurityManager()).map(SecurityManager::getThreadGroup).orElseGet(() -> Thread.currentThread().getThreadGroup());
                    private final String prefix = "org.apache.geronimo.safeguard.bulkhead@" + System.identityHashCode(this) + "[" + context.getMethod() + "]-";
                    private final AtomicLong counter = new AtomicLong();

                    @Override
                    public Thread newThread(Runnable r) {
                        return new Thread(this.group, r, this.prefix + this.counter.incrementAndGet());
                    }
                }, (r, executor) -> {
                    callsRejected.inc();
                    throw new BulkheadException("Can't accept task " + r);
                }){

                    @Override
                    public void execute(Runnable command) {
                        long submitted = System.nanoTime();
                        super.execute(() -> {
                            long start = System.nanoTime();
                            waitingDuration.update(start - submitted);
                            try {
                                command.run();
                            }
                            finally {
                                executionDuration.update(System.nanoTime() - start);
                            }
                        });
                        callsAccepted.inc();
                    }
                };
                this.semaphore = null;
            } else {
                this.workQueue = null;
                this.pool = null;
                this.semaphore = new Semaphore(this.value);
            }
        }
    }

    private static class ContextualFutureWrapper<T>
    extends BaseAsynchronousInterceptor.FutureWrapper<T> {
        private final Model model;

        private ContextualFutureWrapper(Model model, Map<String, Object> data) {
            super(data);
            this.model = model;
        }

        @Override
        public void before() {
            this.model.concurrentCalls.incrementAndGet();
        }

        @Override
        public void after() {
            this.model.concurrentCalls.decrementAndGet();
        }
    }

    private static class ContextualCompletableFuture<T>
    extends BaseAsynchronousInterceptor.ExtendedCompletableFuture<T> {
        private final Model model;

        private ContextualCompletableFuture(Model model) {
            this.model = model;
        }

        @Override
        public void before() {
            this.model.concurrentCalls.incrementAndGet();
        }

        @Override
        public void after() {
            this.model.concurrentCalls.decrementAndGet();
        }
    }
}

