/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.asynchronous;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.safeguard.impl.asynchronous.BaseAsynchronousInterceptor;
import org.apache.safeguard.impl.cache.Key;
import org.apache.safeguard.impl.cache.UnwrappedCache;
import org.apache.safeguard.impl.config.ConfigurationMapper;
import org.apache.safeguard.impl.customizable.Safeguard;
import org.apache.safeguard.impl.interceptor.IdGeneratorInterceptor;
import org.eclipse.microprofile.faulttolerance.Asynchronous;

@Interceptor
@Asynchronous
@Priority(value=4006)
public class AsynchronousInterceptor
extends BaseAsynchronousInterceptor {
    @Inject
    private Cache cache;

    @Override
    protected Executor getExecutor(InvocationContext context) {
        return this.cache.getExecutor();
    }

    @AroundInvoke
    public Object async(InvocationContext context) throws Exception {
        Key cacheKey;
        Map<Key, Boolean> models = this.cache.getEnabled();
        Boolean enabled = models.get(cacheKey = new Key(context, this.cache.getUnwrappedCache().getUnwrappedCache()));
        if (enabled == null) {
            enabled = this.cache.getMapper().isEnabled(context.getMethod(), Asynchronous.class);
            models.putIfAbsent(cacheKey, enabled);
        }
        if (!enabled.booleanValue()) {
            return context.proceed();
        }
        String key = Asynchronous.class.getName() + ".skip_" + context.getContextData().get(IdGeneratorInterceptor.class.getName());
        if (context.getContextData().putIfAbsent(key, Boolean.TRUE) != null) {
            return context.proceed();
        }
        return this.around(context);
    }

    @ApplicationScoped
    public static class Cache {
        private final Map<Key, Boolean> enabled = new ConcurrentHashMap<Key, Boolean>();
        @Inject
        @Safeguard
        private Executor executor;
        @Inject
        private ConfigurationMapper mapper;
        @Inject
        private UnwrappedCache unwrappedCache;

        public UnwrappedCache getUnwrappedCache() {
            return this.unwrappedCache;
        }

        public ConfigurationMapper getMapper() {
            return this.mapper;
        }

        public Executor getExecutor() {
            return this.executor;
        }

        public Map<Key, Boolean> getEnabled() {
            return this.enabled;
        }
    }
}

