/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.client;

import jakarta.xml.ws.WebServiceFeature;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.util.ServiceInfos;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.Service;
import org.apache.openejb.config.sys.Openejb;
import org.apache.openejb.core.ivm.naming.JaxWsServiceReference;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;

public class WebServiceInjectionConfigurator
implements JaxWsServiceReference.WebServiceClientCustomizer {
    private static final String CXF_JAXWS_CLIENT_PREFIX = "cxf.jaxws.client.";

    public WebServiceFeature[] features(QName qname, Properties properties) {
        LinkedList list = null;
        for (String suffix : Arrays.asList("", (qname == null ? "_" : qname.toString()) + ".")) {
            List instances;
            String wsFeatures = properties.getProperty(CXF_JAXWS_CLIENT_PREFIX + suffix + "wsFeatures");
            if (wsFeatures == null || (instances = ServiceInfos.resolve(this.createServiceInfos(properties), (String[])wsFeatures.split(" *, *"))) == null || instances.isEmpty()) continue;
            for (Object i : instances) {
                if (!WebServiceFeature.class.isInstance(i)) {
                    throw new IllegalArgumentException("Not a WebServiceFeature: " + i);
                }
                if (list == null) {
                    list = new LinkedList();
                }
                list.add(WebServiceFeature.class.cast(i));
            }
        }
        return list != null ? list.toArray(new WebServiceFeature[list.size()]) : null;
    }

    public void customize(Object o, Properties properties) {
        Client client;
        try {
            client = ClientProxy.getClient((Object)o);
        }
        catch (Exception e) {
            return;
        }
        this.configure(client, properties);
    }

    private void configure(Client client, Properties properties) {
        if (properties == null) {
            return;
        }
        for (String suffix : Arrays.asList("", client.getEndpoint().getEndpointInfo().getName().toString() + ".")) {
            CxfUtil.configureInterceptors((InterceptorProvider)client, (String)(CXF_JAXWS_CLIENT_PREFIX + suffix), this.lazyServiceInfoList(properties), (Properties)properties);
        }
    }

    private List<ServiceInfo> lazyServiceInfoList(final Properties properties) {
        return (List)List.class.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{List.class}, new InvocationHandler(){
            private List<ServiceInfo> list = null;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (this.list == null) {
                    this.list = WebServiceInjectionConfigurator.this.createServiceInfos(properties);
                }
                try {
                    return method.invoke(this.list, args);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getCause();
                }
            }
        }));
    }

    private List<ServiceInfo> createServiceInfos(Properties properties) {
        OpenEjbConfiguration config = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>(config.facilities != null && config.facilities.services != null ? config.facilities.services : Collections.emptyList());
        services.addAll(this.getServices(properties));
        return services;
    }

    private Collection<ServiceInfo> getServices(Properties properties) {
        ConfigurationFactory cf = (ConfigurationFactory)SystemInstance.get().getComponent(ConfigurationFactory.class);
        if (cf == null || !ConfigurationFactory.class.isInstance(cf)) {
            return Collections.emptyList();
        }
        Openejb openejb = new Openejb();
        ConfigurationFactory.fillOpenEjb((Openejb)openejb, (Properties)properties);
        List services = openejb.getServices();
        if (services.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ServiceInfo> info = new ArrayList<ServiceInfo>(services.size());
        for (org.apache.openejb.config.sys.Service s : services) {
            String prefix = s.getId() + ".";
            for (String key : properties.stringPropertyNames()) {
                if (!key.startsWith(prefix)) continue;
                s.getProperties().put(key.substring(prefix.length()), properties.getProperty(key));
            }
            try {
                info.add(cf.configureService((Service)s, ServiceInfo.class));
            }
            catch (OpenEJBException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return info;
    }
}

