/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.cdi;

import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.geronimo.microprofile.metrics.cdi.Names;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Metered;

@Metered
@Interceptor
@Priority(value=1000)
public class MeteredInterceptor
implements Serializable {
    @Inject
    private MetricRegistry registry;
    @Inject
    @Intercepted
    private Bean<?> bean;
    @Inject
    private BeanManager beanManager;
    private volatile transient ConcurrentMap<Executable, Meter> meters = new ConcurrentHashMap<Executable, Meter>();

    @AroundConstruct
    public Object onConstructor(InvocationContext context) throws Exception {
        this.findMeter(context.getConstructor()).mark();
        return context.proceed();
    }

    @AroundInvoke
    public Object onMethod(InvocationContext context) throws Exception {
        this.findMeter(context.getMethod()).mark();
        return context.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Meter findMeter(Executable executable) {
        Meter meter;
        if (this.meters == null) {
            MeteredInterceptor meteredInterceptor = this;
            synchronized (meteredInterceptor) {
                if (this.meters == null) {
                    this.meters = new ConcurrentHashMap<Executable, Meter>();
                }
            }
        }
        if ((meter = (Meter)this.meters.get(executable)) == null) {
            AnnotatedType type = this.beanManager.createAnnotatedType(this.bean.getBeanClass());
            Metered metered = Stream.concat(type.getMethods().stream(), type.getConstructors().stream()).filter(it -> it.getJavaMember().equals(executable)).findFirst().map(m -> (Metered)m.getAnnotation(Metered.class)).orElse(null);
            String name = Names.findName(Modifier.isAbstract(executable.getDeclaringClass().getModifiers()) ? type.getJavaClass() : executable.getDeclaringClass(), executable, metered == null ? null : metered.name(), metered != null && metered.absolute(), Optional.ofNullable(type.getAnnotation(Metered.class)).map(Metered::name).orElse(""));
            meter = (Meter)Meter.class.cast(this.registry.getMetrics().get(name));
            if (meter == null) {
                throw new IllegalStateException("No meter with name [" + name + "] found in registry [" + this.registry + "]");
            }
            this.meters.putIfAbsent(executable, meter);
        }
        return meter;
    }
}

