/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.MessageFactory;
import com.sun.faces.util.RequestStateManager;
import jakarta.faces.FacesException;
import jakarta.faces.application.Application;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;

public class PropertyEditorHelper {
    private Application app;

    public PropertyEditorHelper(Application app) {
        this.app = app;
    }

    public Object convertToObject(Class<?> targetClass, String textValue) {
        UIComponent component = this.getComponent();
        Converter converter = this.app.createConverter(targetClass);
        if (null == converter) {
            FacesException e = new FacesException("Cannot create Converter to convert value " + textValue + " to instance of target class " + targetClass.getName() + '.');
            throw e;
        }
        FacesContext currentInstance = FacesContext.getCurrentInstance();
        try {
            return converter.getAsObject(currentInstance, component, textValue);
        }
        catch (ConverterException ce) {
            this.addConversionErrorMessage(currentInstance, component, ce);
            return null;
        }
    }

    public String convertToString(Class<?> targetClass, Object value) {
        UIComponent component = this.getComponent();
        Converter converter = this.app.createConverter(targetClass);
        if (null == converter) {
            throw new FacesException("Cannot create Converter to convert " + targetClass.getName() + " value " + value + " to string.");
        }
        FacesContext currentInstance = FacesContext.getCurrentInstance();
        try {
            return converter.getAsString(currentInstance, component, value);
        }
        catch (ConverterException ce) {
            this.addConversionErrorMessage(currentInstance, component, ce);
            return null;
        }
    }

    protected UIComponent getComponent() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            return (UIComponent)RequestStateManager.get(context, "com.sun.faces.ComponentForValue");
        }
        return null;
    }

    protected void addConversionErrorMessage(FacesContext context, UIComponent component, ConverterException ce) {
        FacesMessage message;
        String converterMessageString = null;
        if (component instanceof UIInput) {
            UIInput input = (UIInput)component;
            converterMessageString = input.getConverterMessage();
            input.setValid(false);
        }
        if (null != converterMessageString) {
            message = new FacesMessage(FacesMessage.SEVERITY_ERROR, converterMessageString, converterMessageString);
        } else {
            message = ce.getFacesMessage();
            if (message == null && (message = MessageFactory.getMessage(context, "jakarta.faces.component.UIInput.CONVERSION", new Object[0])).getDetail() == null) {
                message.setDetail(ce.getMessage());
            }
        }
        context.addMessage(component != null ? component.getClientId(context) : null, message);
    }
}

